/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.InputFilter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.socialize.Socialize;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.SocializeSession;
import com.socialize.auth.AuthProviderType;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.i18n.LocalizationService;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.networks.SocialNetworkCheckbox;
import com.socialize.networks.SocialNetworkSignOutListener;
import com.socialize.ui.profile.ProfileLayoutView;
import com.socialize.ui.profile.ProfilePictureEditView;
import com.socialize.ui.profile.ProfileSaveButtonListener;
import com.socialize.ui.profile.UserSettings;
import com.socialize.ui.user.UserService;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.view.CustomCheckbox;
import com.socialize.ui.view.SocializeButton;
import com.socialize.ui.view.SocializeEditText;
import com.socialize.util.AppUtils;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.util.SafeBitmapDrawable;
import com.socialize.view.BaseView;

public class ProfileContentView
extends BaseView {
    private DisplayUtils displayUtils;
    private AppUtils appUtils;
    private Drawables drawables;
    private LocalizationService localizationService;
    private ProfilePictureEditView profilePictureEditView;
    private SocializeEditText firstNameEdit;
    private SocializeEditText lastNameEdit;
    private SocializeButton saveButton;
    private SocializeButton cancelButton;
    private User currentUser;
    private ProfileLayoutView parent;
    private Toast toaster;
    private IBeanFactory<SocializeEditText> socializeEditTextFactory;
    private IBeanFactory<ProfilePictureEditView> profilePictureEditViewFactory;
    private IBeanFactory<SocializeButton> profileCancelButtonFactory;
    private IBeanFactory<SocializeButton> profileSaveButtonFactory;
    private IBeanFactory<ProfileSaveButtonListener> profileSaveButtonListenerFactory;
    private UserService userService;
    private Activity context;
    private TextView userId;
    private CheckBox autoPostFacebook;
    private CheckBox autoPostTwitter;
    private CustomCheckbox notificationsEnabledCheckbox;
    private CustomCheckbox locationEnabledCheckbox;
    private SocialNetworkCheckbox facebookEnabledCheckbox;
    private SocialNetworkCheckbox twitterEnabledCheckbox;
    private IBeanFactory<CustomCheckbox> notificationsEnabledCheckboxFactory;
    private IBeanFactory<CustomCheckbox> locationEnabledCheckboxFactory;
    private IBeanFactory<SocialNetworkCheckbox> facebookEnabledCheckboxFactory;
    private IBeanFactory<SocialNetworkCheckbox> twitterEnabledCheckboxFactory;
    private LinearLayout.LayoutParams commonParams;
    private int buttonLayoutViewId = 0;
    private SocializeAuthListener socialSignInListener;
    private SocialNetworkSignOutListener socialSignOutListener;

    public ProfileContentView(Activity context, ProfileLayoutView parent) {
        super((Context)context);
        this.parent = parent;
        this.context = context;
    }

    public void init() {
        this.setOrientation(1);
        CompatUtils.setBackgroundDrawable((View)this, this.drawables.getDrawable("slate.png", true, true, true));
        LinearLayout.LayoutParams viewParams = new LinearLayout.LayoutParams(-1, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)viewParams);
        ViewGroup master = this.makeMasterLayout();
        ViewGroup buttons = this.makeButtonLayout();
        int margin = this.displayUtils.getDIP(8);
        this.buttonLayoutViewId = this.getNextViewId((View)this);
        this.commonParams = new LinearLayout.LayoutParams(-1, -2);
        this.commonParams.setMargins(0, margin, 0, margin);
        this.profilePictureEditView = (ProfilePictureEditView)((Object)this.profilePictureEditViewFactory.getBean());
        this.userId = new TextView(this.getContext());
        this.userId.setTextColor(-1);
        this.userId.setTextSize(1, 10.0f);
        this.userId.setGravity(5);
        LinearLayout.LayoutParams userIdParams = new LinearLayout.LayoutParams(-1, -2);
        userIdParams.gravity = 5;
        this.userId.setLayoutParams((ViewGroup.LayoutParams)userIdParams);
        this.firstNameEdit = (SocializeEditText)((Object)this.socializeEditTextFactory.getBean());
        this.lastNameEdit = (SocializeEditText)((Object)this.socializeEditTextFactory.getBean());
        this.firstNameEdit.setLabel(this.localizationService.getString("socialize_settings_label_firstname"));
        this.lastNameEdit.setLabel(this.localizationService.getString("socialize_settings_label_lastname"));
        this.saveButton = (SocializeButton)((Object)this.profileSaveButtonFactory.getBean());
        this.cancelButton = (SocializeButton)((Object)this.profileCancelButtonFactory.getBean());
        InputFilter[] maxLength = new InputFilter[]{new InputFilter.LengthFilter(128)};
        this.firstNameEdit.setFilters(maxLength);
        this.lastNameEdit.setFilters(maxLength);
        this.profilePictureEditView.setLayoutParams((ViewGroup.LayoutParams)this.commonParams);
        this.firstNameEdit.setLayoutParams((ViewGroup.LayoutParams)this.commonParams);
        this.lastNameEdit.setLayoutParams((ViewGroup.LayoutParams)this.commonParams);
        master.addView((View)this.userId);
        master.addView((View)this.profilePictureEditView);
        master.addView((View)this.firstNameEdit);
        master.addView((View)this.lastNameEdit);
        if (this.appUtils.isLocationAvailable(this.getContext())) {
            this.locationEnabledCheckbox = (CustomCheckbox)this.locationEnabledCheckboxFactory.getBean();
            this.locationEnabledCheckbox.setLayoutParams((ViewGroup.LayoutParams)this.commonParams);
            master.addView((View)this.locationEnabledCheckbox);
        }
        if (this.appUtils.isNotificationsAvailable(this.getContext())) {
            this.notificationsEnabledCheckbox = (CustomCheckbox)this.notificationsEnabledCheckboxFactory.getBean();
            this.notificationsEnabledCheckbox.setLayoutParams((ViewGroup.LayoutParams)this.commonParams);
            master.addView((View)this.notificationsEnabledCheckbox);
        }
        this.setupSocialButtons(master);
        this.setupListeners();
        buttons.addView((View)this.cancelButton);
        buttons.addView((View)this.saveButton);
        ViewGroup scrollView = this.makeScrollLayout();
        LinearLayout.LayoutParams childViewLayout = new LinearLayout.LayoutParams(-1, -1);
        scrollView.addView((View)master, (ViewGroup.LayoutParams)childViewLayout);
        this.addView((View)scrollView);
        this.addView((View)buttons);
    }

    protected void setupSocialButtons(ViewGroup group) {
        if (this.getSocialize().isSupported((Context)this.context, AuthProviderType.FACEBOOK)) {
            this.facebookEnabledCheckbox = (SocialNetworkCheckbox)this.facebookEnabledCheckboxFactory.getBean();
            this.autoPostFacebook = new CheckBox(this.getContext());
            this.setupSocialButton(group, this.facebookEnabledCheckbox, this.autoPostFacebook, this.localizationService.getString("socialize_facebook_autopost"));
        }
        if (this.getSocialize().isSupported((Context)this.context, AuthProviderType.TWITTER)) {
            this.twitterEnabledCheckbox = (SocialNetworkCheckbox)this.twitterEnabledCheckboxFactory.getBean();
            this.autoPostTwitter = new CheckBox(this.getContext());
            this.setupSocialButton(group, this.twitterEnabledCheckbox, this.autoPostTwitter, this.localizationService.getString("socialize_twitter_autopost"));
        }
    }

    protected void setupSocialButton(ViewGroup group, SocialNetworkCheckbox checkbox, CheckBox shareOption, String shareText) {
        checkbox.setLayoutParams((ViewGroup.LayoutParams)this.commonParams);
        shareOption.setText((CharSequence)shareText);
        shareOption.setTextSize(1, 12.0f);
        LinearLayout.LayoutParams optionsParams = new LinearLayout.LayoutParams(-1, -2);
        shareOption.setLayoutParams((ViewGroup.LayoutParams)optionsParams);
        checkbox.setVisibility(4);
        shareOption.setVisibility(4);
        group.addView((View)checkbox);
        ViewGroup fbLayout = this.makeSocialNetworkOptionsLayout();
        fbLayout.addView((View)shareOption);
        group.addView((View)fbLayout);
    }

    protected SocializeAuthListener getSignInListener() {
        return new SocializeAuthListener(){

            @Override
            public void onError(SocializeException error) {
                error.printStackTrace();
                ProfileContentView.this.showErrorToast(ProfileContentView.this.getContext(), error);
            }

            @Override
            public void onCancel() {
            }

            @Override
            public void onAuthSuccess(SocializeSession session) {
                ProfileContentView.this.parent.setUserId(session.getUser().getId().toString());
                ProfileContentView.this.parent.doGetUserProfile();
            }

            @Override
            public void onAuthFail(SocializeException error) {
                error.printStackTrace();
                ProfileContentView.this.showErrorToast(ProfileContentView.this.getContext(), error);
            }
        };
    }

    protected SocialNetworkSignOutListener getSignOutListener() {
        return new SocialNetworkSignOutListener(){

            @Override
            public void onSignOut() {
                ProfileContentView.this.parent.setUserId(Socialize.getSocialize().getSession().getUser().getId().toString());
                ProfileContentView.this.parent.doGetUserProfile();
            }

            @Override
            public void onCancel() {
            }
        };
    }

    protected void setupListeners() {
        this.socialSignInListener = this.getSignInListener();
        this.socialSignOutListener = this.getSignOutListener();
        this.cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ProfileContentView.this.context.finish();
            }
        });
        this.saveButton.setOnClickListener((View.OnClickListener)this.profileSaveButtonListenerFactory.getBean(new Object[]{this.getContext(), this}));
        if (this.facebookEnabledCheckbox != null) {
            this.facebookEnabledCheckbox.setSignInListener(this.socialSignInListener);
            this.facebookEnabledCheckbox.setSignOutListener(this.socialSignOutListener);
        }
        if (this.twitterEnabledCheckbox != null) {
            this.twitterEnabledCheckbox.setSignInListener(this.socialSignInListener);
            this.twitterEnabledCheckbox.setSignOutListener(this.socialSignOutListener);
        }
    }

    protected ViewGroup makeScrollLayout() {
        LinearLayout.LayoutParams scrollViewLayout = new LinearLayout.LayoutParams(-1, -2);
        scrollViewLayout.weight = 1.0f;
        ScrollView scrollView = new ScrollView(this.getContext());
        scrollView.setFillViewport(true);
        scrollView.setLayoutParams((ViewGroup.LayoutParams)scrollViewLayout);
        return scrollView;
    }

    protected ViewGroup makeSocialNetworkOptionsLayout() {
        LinearLayout master = new LinearLayout(this.getContext());
        int padding = this.displayUtils.getDIP(8);
        LinearLayout.LayoutParams masterParams = new LinearLayout.LayoutParams(-1, -2);
        masterParams.setMargins(padding, 0, 0, 0);
        master.setLayoutParams((ViewGroup.LayoutParams)masterParams);
        master.setOrientation(1);
        master.setGravity(48);
        return master;
    }

    protected ViewGroup makeMasterLayout() {
        LinearLayout master = new LinearLayout(this.getContext());
        int padding = this.displayUtils.getDIP(8);
        LinearLayout.LayoutParams masterParams = new LinearLayout.LayoutParams(-1, -2);
        masterParams.weight = 1.0f;
        master.setLayoutParams((ViewGroup.LayoutParams)masterParams);
        master.setOrientation(1);
        master.setPadding(padding, padding, padding, padding);
        master.setGravity(48);
        return master;
    }

    protected ViewGroup makeButtonLayout() {
        LinearLayout buttons = new LinearLayout(this.getContext());
        int padding = this.displayUtils.getDIP(8);
        LinearLayout.LayoutParams buttonParams = new LinearLayout.LayoutParams(-1, -2);
        buttons.setId(this.buttonLayoutViewId);
        buttons.setLayoutParams((ViewGroup.LayoutParams)buttonParams);
        buttons.setOrientation(0);
        buttons.setPadding(padding, padding, padding, padding);
        buttons.setGravity(85);
        ColorDrawable background = new ColorDrawable(-16777216);
        background.setAlpha(64);
        CompatUtils.setBackgroundDrawable((View)buttons, (Drawable)background);
        return buttons;
    }

    public void setUserDetails(User user, UserSettings settings) {
        this.profilePictureEditView.setUserDetails(user);
        this.userId.setText((CharSequence)("ID: " + String.valueOf(user.getId())));
        this.firstNameEdit.setText(settings.getFirstName());
        this.lastNameEdit.setText(settings.getLastName());
        User currentUser = this.userService.getCurrentUser();
        this.setCurrentUser(currentUser);
        if (this.getSocialize().isSupported((Context)this.context, AuthProviderType.FACEBOOK) && Socialize.getSocialize().isAuthenticatedForRead(AuthProviderType.FACEBOOK, new String[0])) {
            this.facebookEnabledCheckbox.setChecked(true);
            this.autoPostFacebook.setChecked(settings.isAutoPostFacebook());
        }
        if (this.getSocialize().isSupported((Context)this.context, AuthProviderType.TWITTER)) {
            if (Socialize.getSocialize().isAuthenticatedForRead(AuthProviderType.TWITTER, new String[0])) {
                this.twitterEnabledCheckbox.setChecked(true);
                this.autoPostTwitter.setChecked(settings.isAutoPostTwitter());
            } else {
                this.twitterEnabledCheckbox.setChecked(false);
            }
        }
        if (this.notificationsEnabledCheckbox != null) {
            this.notificationsEnabledCheckbox.setChecked(settings.isNotificationsEnabled());
        }
        if (this.locationEnabledCheckbox != null) {
            this.locationEnabledCheckbox.setChecked(settings.isLocationEnabled());
        }
        this.onNetworksChanged();
    }

    public void onNetworksChanged() {
        if (this.getSocialize().isSupported((Context)this.context, AuthProviderType.FACEBOOK)) {
            if (this.facebookEnabledCheckbox != null) {
                this.facebookEnabledCheckbox.setVisibility(0);
            }
            if (this.autoPostFacebook != null) {
                if (Socialize.getSocialize().isAuthenticatedForRead(AuthProviderType.FACEBOOK, new String[0])) {
                    this.autoPostFacebook.setVisibility(0);
                } else {
                    this.autoPostFacebook.setVisibility(8);
                }
            }
        } else {
            if (this.facebookEnabledCheckbox != null) {
                this.facebookEnabledCheckbox.setVisibility(8);
            }
            if (this.autoPostFacebook != null) {
                this.autoPostFacebook.setVisibility(8);
            }
        }
        if (this.getSocialize().isSupported((Context)this.context, AuthProviderType.TWITTER)) {
            if (this.twitterEnabledCheckbox != null) {
                this.twitterEnabledCheckbox.setVisibility(0);
            }
            if (this.autoPostTwitter != null) {
                if (Socialize.getSocialize().isAuthenticatedForRead(AuthProviderType.TWITTER, new String[0])) {
                    this.autoPostTwitter.setVisibility(0);
                } else {
                    this.autoPostTwitter.setVisibility(8);
                }
            }
        } else {
            if (this.twitterEnabledCheckbox != null) {
                this.twitterEnabledCheckbox.setVisibility(8);
            }
            if (this.autoPostTwitter != null) {
                this.autoPostTwitter.setVisibility(8);
            }
        }
    }

    @Override
    public void onViewLoad() {
        super.onViewLoad();
        this.onNetworksChanged();
    }

    public void onProfilePictureChange(Bitmap image) {
        this.profilePictureEditView.setProfileImage((Drawable)new SafeBitmapDrawable(image));
    }

    public User getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(User currentUser) {
        this.currentUser = currentUser;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setProfileCancelButtonFactory(IBeanFactory<SocializeButton> profileCancelButtonFactory) {
        this.profileCancelButtonFactory = profileCancelButtonFactory;
    }

    public void setProfileSaveButtonFactory(IBeanFactory<SocializeButton> profileSaveButtonFactory) {
        this.profileSaveButtonFactory = profileSaveButtonFactory;
    }

    public void setProfileSaveButtonListenerFactory(IBeanFactory<ProfileSaveButtonListener> profileSaveButtonListenerFactory) {
        this.profileSaveButtonListenerFactory = profileSaveButtonListenerFactory;
    }

    public void setProfilePictureEditViewFactory(IBeanFactory<ProfilePictureEditView> profilePictureEditViewFactory) {
        this.profilePictureEditViewFactory = profilePictureEditViewFactory;
    }

    public void setSocializeEditTextFactory(IBeanFactory<SocializeEditText> socializeEditTextFactory) {
        this.socializeEditTextFactory = socializeEditTextFactory;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setNotificationsEnabledCheckboxFactory(IBeanFactory<CustomCheckbox> notificationsEnabledCheckboxFactory) {
        this.notificationsEnabledCheckboxFactory = notificationsEnabledCheckboxFactory;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    protected ProfilePictureEditView getProfilePictureEditView() {
        return this.profilePictureEditView;
    }

    protected SocializeEditText getFirstNameEdit() {
        return this.firstNameEdit;
    }

    protected SocializeEditText getLastNameEdit() {
        return this.lastNameEdit;
    }

    protected CheckBox getAutoPostFacebook() {
        return this.autoPostFacebook;
    }

    protected CheckBox getAutoPostTwitter() {
        return this.autoPostTwitter;
    }

    protected CustomCheckbox getNotificationsEnabledCheckbox() {
        return this.notificationsEnabledCheckbox;
    }

    protected CustomCheckbox getLocationEnabledCheckbox() {
        return this.locationEnabledCheckbox;
    }

    protected SocialNetworkCheckbox getFacebookEnabledCheckbox() {
        return this.facebookEnabledCheckbox;
    }

    public void setFacebookEnabledCheckboxFactory(IBeanFactory<SocialNetworkCheckbox> facebookEnabledCheckboxFactory) {
        this.facebookEnabledCheckboxFactory = facebookEnabledCheckboxFactory;
    }

    public void setTwitterEnabledCheckboxFactory(IBeanFactory<SocialNetworkCheckbox> twitterEnabledCheckboxFactory) {
        this.twitterEnabledCheckboxFactory = twitterEnabledCheckboxFactory;
    }

    public void setLocationEnabledCheckboxFactory(IBeanFactory<CustomCheckbox> locationEnabledCheckboxFactory) {
        this.locationEnabledCheckboxFactory = locationEnabledCheckboxFactory;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    protected void toast(String text) {
        if (this.toaster != null) {
            this.toaster.cancel();
        }
        this.toaster = Toast.makeText((Context)this.getContext(), (CharSequence)text, (int)0);
        this.toaster.show();
    }
}

