/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.profile;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import com.socialize.ui.profile.ProfileImageContextMenu;
import com.socialize.util.DeviceUtils;

public class DefaultProfileImageContextMenu
implements ProfileImageContextMenu {
    private Activity context;
    private DeviceUtils deviceUtils;

    public DefaultProfileImageContextMenu(Activity context) {
        this.context = context;
    }

    @Override
    public void show() {
        if (this.deviceUtils != null && this.deviceUtils.hasCamera()) {
            CharSequence[] items = new String[]{"From Gallery", "From Camera"};
            AlertDialog.Builder ab = new AlertDialog.Builder((Context)this.context);
            ab.setTitle((CharSequence)"New Profile Picture");
            ab.setItems(items, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface d, int choice) {
                    if (choice == 0) {
                        DefaultProfileImageContextMenu.this.launchGallery();
                    } else if (choice == 1) {
                        DefaultProfileImageContextMenu.this.launchCamera();
                    }
                }
            });
            ab.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            });
            ab.show();
        } else {
            this.launchGallery();
        }
    }

    protected void launchGallery() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.GET_CONTENT");
        if (Build.VERSION.SDK_INT >= 11) {
            intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        }
        this.context.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select Picture"), 1338);
    }

    protected void launchCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.context.startActivityForResult(cameraIntent, 1337);
    }

    public void setDeviceUtils(DeviceUtils deviceUtils) {
        this.deviceUtils = deviceUtils;
    }
}

