/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.notifications;

import android.content.Context;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.notifications.DirectUrlListener;

public class DirectUrlWebView
extends WebView {
    private SocializeLogger logger;
    private DirectUrlListener listener;

    public DirectUrlWebView(Context context) {
        super(context);
    }

    public void init() {
        FrameLayout.LayoutParams FILL = new FrameLayout.LayoutParams(-1, -1);
        this.getSettings().setJavaScriptEnabled(true);
        this.getSettings().setLoadWithOverviewMode(true);
        this.getSettings().setUseWideViewPort(true);
        this.getSettings().setSupportZoom(true);
        this.getSettings().setBuiltInZoomControls(true);
        this.setLayoutParams((ViewGroup.LayoutParams)FILL);
        this.setWebChromeClient(this.newWebChromeClient());
        this.setWebViewClient(this.newWebViewClient());
    }

    public void destroy() {
        this.clearCache(false);
        this.destroyDrawingCache();
    }

    protected WebChromeClient newWebChromeClient() {
        WebChromeClient client = new WebChromeClient(){

            public void onConsoleMessage(String message, int lineNumber, String sourceID) {
                if (DirectUrlWebView.this.logger != null && DirectUrlWebView.this.logger.isInfoEnabled()) {
                    DirectUrlWebView.this.logger.info(message + " (" + sourceID + ": " + lineNumber + ")");
                }
                super.onConsoleMessage(message, lineNumber, sourceID);
            }
        };
        return client;
    }

    protected WebViewClient newWebViewClient() {
        WebViewClient client = new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                if (DirectUrlWebView.this.logger != null && DirectUrlWebView.this.logger.isInfoEnabled()) {
                    DirectUrlWebView.this.logger.info("Direct URL loaded page: " + url);
                }
                if (DirectUrlWebView.this.listener != null) {
                    DirectUrlWebView.this.listener.onAfterPageLoaded(DirectUrlWebView.this, url);
                }
                super.onPageFinished(view, url);
            }
        };
        return client;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setListener(DirectUrlListener listener) {
        this.listener = listener;
    }
}

