/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.image;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.socialize.util.CacheableDrawable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class ImageUrlLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableDrawable loadImageFromUrl(String url, int width, int height) throws IOException {
        URL imageUrl = new URL(url);
        URLConnection conn = null;
        try (InputStream is = null;){
            conn = imageUrl.openConnection();
            is = conn.getInputStream();
            Bitmap bitmap = this.newBitmapDrawable(is);
            if (width > 0 && height > 0) {
                Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
                bitmap.recycle();
                CacheableDrawable cacheableDrawable = this.newCacheableDrawable(scaled, url);
                return cacheableDrawable;
            }
            CacheableDrawable cacheableDrawable = this.newCacheableDrawable(bitmap, url);
            return cacheableDrawable;
        }
    }

    protected CacheableDrawable newCacheableDrawable(Bitmap bitmap, String url) {
        return new CacheableDrawable(bitmap, url);
    }

    protected Bitmap newBitmapDrawable(InputStream is) {
        return BitmapFactory.decodeStream((InputStream)is);
    }
}

