/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.image;

import com.socialize.log.SocializeLogger;
import com.socialize.ui.image.ImageLoadAsyncTask;
import com.socialize.ui.image.ImageLoadListener;
import com.socialize.ui.image.ImageLoadRequest;
import com.socialize.ui.image.ImageLoadType;
import com.socialize.util.CacheableDrawable;
import com.socialize.util.Drawables;

public class ImageLoader {
    private Drawables drawables;
    private ImageLoadAsyncTask imageLoadAsyncTask;
    private SocializeLogger logger;

    public void init() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("ImageLoader starting image load task");
        }
        this.imageLoadAsyncTask.start();
    }

    public void destroy() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("ImageLoader stopping image load task");
        }
        this.imageLoadAsyncTask.finish();
    }

    public void cancel(String url) {
        this.imageLoadAsyncTask.cancel(url);
    }

    public void loadImageByData(String name, String encodedData, int width, int height, ImageLoadListener listener) {
        ImageLoadRequest request = this.makeRequest();
        request.setUrl(name);
        request.setEncodedImageData(encodedData);
        request.setType(ImageLoadType.ENCODED);
        this.loadImage(request, listener);
    }

    public void loadImageByUrl(String url, ImageLoadListener listener) {
        this.loadImageByUrl(url, -1, -1, listener);
    }

    public void loadImageByUrl(String url, int width, int height, ImageLoadListener listener) {
        ImageLoadRequest request = this.makeRequest();
        request.setUrl(url);
        request.setType(ImageLoadType.URL);
        request.setScaleWidth(width);
        request.setScaleHeight(height);
        this.loadImage(request, listener);
    }

    public void loadImage(ImageLoadRequest request, ImageLoadListener listener) {
        String url = request.getUrl();
        CacheableDrawable drawable2 = (CacheableDrawable)this.drawables.getCache().get(url);
        if (drawable2 != null && !drawable2.isRecycled()) {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("ImageLoader loading image from cache for " + url);
            }
            if (listener != null) {
                listener.onImageLoad(request, drawable2);
            }
        } else {
            if (this.logger != null && this.logger.isDebugEnabled()) {
                if (drawable2 != null && drawable2.isRecycled()) {
                    this.logger.debug("ImageLoader image was recycled, reloading " + url);
                } else {
                    this.logger.debug("ImageLoader enqueuing request for image " + url);
                }
            }
            if (listener != null) {
                request.addListener(listener);
            }
            this.imageLoadAsyncTask.enqueue(request);
        }
    }

    public Drawables getDrawables() {
        return this.drawables;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    protected ImageLoadRequest makeRequest() {
        return new ImageLoadRequest();
    }

    public void setImageLoadAsyncTask(ImageLoadAsyncTask imageLoadAsyncTask) {
        this.imageLoadAsyncTask = imageLoadAsyncTask;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public boolean isLoading(String url) {
        return this.imageLoadAsyncTask.isLoading(url);
    }

    public boolean isEmpty() {
        return this.imageLoadAsyncTask.isEmpty();
    }
}

