/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.image;

import com.socialize.log.SocializeLogger;
import com.socialize.ui.image.ImageLoadRequest;
import com.socialize.ui.image.ImageUrlLoader;
import com.socialize.util.Base64Utils;
import com.socialize.util.CacheableDrawable;
import com.socialize.util.DrawableCache;
import com.socialize.util.Drawables;
import com.socialize.util.SafeBitmapDrawable;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ImageLoadAsyncTask
extends Thread {
    private Queue<ImageLoadRequest> requests;
    private Map<String, ImageLoadRequest> requestsInProcess;
    private boolean running = false;
    private SocializeLogger logger;
    private ImageUrlLoader imageUrlLoader;
    private DrawableCache cache;
    private Drawables drawables;
    private Base64Utils base64Utils;

    public ImageLoadAsyncTask() {
        super("ImageLoadAsyncTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.requests != null) {
            while (this.running) {
                while (!this.requests.isEmpty() && this.running) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("ImageLoadAsyncTask has [" + this.requests.size() + "] images to load");
                    }
                    ImageLoadRequest request = this.requests.poll();
                    String url = request.getUrl();
                    if (!request.isCanceled()) {
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("ImageLoadAsyncTask found image to load at: " + url);
                        }
                        try {
                            SafeBitmapDrawable drawable2 = null;
                            if (this.cache != null) {
                                drawable2 = (SafeBitmapDrawable)((Object)this.cache.get(url));
                            }
                            if (drawable2 == null || drawable2.isRecycled()) {
                                switch (request.getType()) {
                                    case ENCODED: {
                                        if (this.logger != null && this.logger.isDebugEnabled()) {
                                            this.logger.debug("ImageLoadAsyncTask image loading from encoded data for: " + url);
                                        }
                                        drawable2 = (SafeBitmapDrawable)this.drawables.getDrawableFromUrl(url, this.base64Utils.decode(request.getEncodedImageData()), request.getScaleWidth(), request.getScaleHeight());
                                        break;
                                    }
                                    default: {
                                        if (this.logger != null && this.logger.isDebugEnabled()) {
                                            this.logger.debug("ImageLoadAsyncTask image loading from remote url for: " + url);
                                        }
                                        drawable2 = this.loadImageFromUrl(url, request.getScaleWidth(), request.getScaleHeight());
                                    }
                                }
                                if (drawable2 != null) {
                                    this.cache.put(url, (CacheableDrawable)drawable2, false);
                                }
                            }
                            int notified = request.notifyListeners(drawable2);
                            if (this.logger == null || !this.logger.isDebugEnabled()) continue;
                            this.logger.debug("Notified [" + notified + "] listeners for image load of url [" + url + "]");
                            continue;
                        }
                        catch (Exception e) {
                            request.notifyListeners(e);
                            continue;
                        }
                        finally {
                            this.requestsInProcess.remove(url);
                            continue;
                        }
                    }
                    this.requestsInProcess.remove(url);
                    if (this.logger == null || !this.logger.isDebugEnabled()) continue;
                    this.logger.debug("ImageLoadAsyncTask request canceled for " + request.getUrl());
                }
                ImageLoadAsyncTask imageLoadAsyncTask = this;
                synchronized (imageLoadAsyncTask) {
                    if (this.running) {
                        try {
                            this.doWait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    protected CacheableDrawable loadImageFromUrl(String url, int width, int height) throws Exception {
        return this.imageUrlLoader.loadImageFromUrl(url, width, height);
    }

    public void cancel(String url) {
        ImageLoadRequest request;
        if (this.requestsInProcess != null && (request = this.requestsInProcess.get(url)) != null) {
            request.setCanceled(true);
        }
    }

    public synchronized void enqueue(ImageLoadRequest request) {
        if (this.isRunning()) {
            String url = request.getUrl();
            ImageLoadRequest current = this.requestsInProcess.get(url);
            if (current != null && !current.isCanceled() && !current.isListenersNotified()) {
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Image with url [" + url + "] already being loaded. Adding listener to queue on current request [" + current.getUrl() + "]");
                }
                current.merge(request);
                this.notifyAll();
            } else {
                this.requests.add(request);
                this.requestsInProcess.put(url, request);
                this.notifyAll();
            }
        } else if (this.logger != null) {
            this.logger.warn("Image load task is not running.  Enqueue request ignored");
        }
    }

    public void init() {
        this.requests = this.makeRequests();
        this.requestsInProcess = this.makePendingRequests();
    }

    protected void onStart() {
        this.init();
        this.running = true;
        this.setDaemon(true);
    }

    @Override
    public void start() {
        this.onStart();
        super.start();
    }

    protected Queue<ImageLoadRequest> makeRequests() {
        return new ConcurrentLinkedQueue<ImageLoadRequest>();
    }

    protected Map<String, ImageLoadRequest> makePendingRequests() {
        return new ConcurrentHashMap<String, ImageLoadRequest>();
    }

    protected void doWait() throws InterruptedException {
        this.wait();
    }

    public synchronized void finish() {
        this.running = false;
        if (this.requests != null) {
            this.requests.clear();
        }
        if (this.requests != null) {
            this.requestsInProcess.clear();
        }
        this.notifyAll();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setImageUrlLoader(ImageUrlLoader imageUrlLoader) {
        this.imageUrlLoader = imageUrlLoader;
    }

    public void setCache(DrawableCache cache) {
        this.cache = cache;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setBase64Utils(Base64Utils base64Utils) {
        this.base64Utils = base64Utils;
    }

    public boolean isEmpty() {
        return this.requestsInProcess.isEmpty();
    }

    public boolean isLoading(String url) {
        return this.requestsInProcess.containsKey(url);
    }
}

