/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.dialog;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import com.socialize.i18n.LocalizationService;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.dialog.DialogRegistration;
import com.socialize.ui.dialog.SafeProgressDialog;
import com.socialize.ui.dialog.SimpleDialogFactory;
import com.socialize.util.Drawables;

public class ProgressDialogFactory
implements SimpleDialogFactory<ProgressDialog> {
    private SocializeLogger logger;
    private Drawables drawables;
    private LocalizationService localizationService;

    @Override
    public ProgressDialog show(Context context, String title, String message) {
        if (this.localizationService != null) {
            title = this.localizationService.getString(title);
            message = this.localizationService.getString(message);
        }
        try {
            ProgressDialog dialog = this.makeDialog(context);
            dialog.setTitle((CharSequence)title);
            dialog.setMessage((CharSequence)message);
            if (this.drawables != null) {
                dialog.setIcon(this.drawables.getDrawable("socialize_icon_white.png"));
            }
            DialogRegistration.register(context, (Dialog)dialog);
            dialog.show();
            return dialog;
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("Error displaying progress dialog", (Throwable)e);
            } else {
                SocializeLogger.e(e.getMessage(), e);
            }
            return null;
        }
    }

    protected ProgressDialog makeDialog(Context context) {
        return new SafeProgressDialog(context);
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }
}

