/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.comment;

import android.app.ProgressDialog;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import com.socialize.ConfigUtils;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.comment.CommentOptions;
import com.socialize.api.action.comment.CommentUtilsProxy;
import com.socialize.api.action.comment.SubscriptionUtilsProxy;
import com.socialize.api.action.user.UserUtilsProxy;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.Comment;
import com.socialize.entity.Entity;
import com.socialize.entity.ListResult;
import com.socialize.entity.Subscription;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.listener.comment.CommentAddListener;
import com.socialize.listener.comment.CommentListListener;
import com.socialize.listener.subscription.SubscriptionCheckListener;
import com.socialize.listener.subscription.SubscriptionResultListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.notifications.SubscriptionType;
import com.socialize.ui.comment.CommentAdapter;
import com.socialize.ui.comment.CommentAddButtonListener;
import com.socialize.ui.comment.CommentButtonCallback;
import com.socialize.ui.comment.CommentEditField;
import com.socialize.ui.comment.CommentEntrySliderItem;
import com.socialize.ui.comment.CommentScrollCallback;
import com.socialize.ui.comment.CommentScrollListener;
import com.socialize.ui.comment.OnCommentViewActionListener;
import com.socialize.ui.dialog.SimpleDialogFactory;
import com.socialize.ui.header.SocializeHeader;
import com.socialize.ui.image.ImageLoader;
import com.socialize.ui.profile.UserSettings;
import com.socialize.ui.slider.ActionBarSliderFactory;
import com.socialize.ui.slider.ActionBarSliderView;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.view.CustomCheckbox;
import com.socialize.ui.view.LoadingListView;
import com.socialize.util.AppUtils;
import com.socialize.util.CacheableDrawable;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.util.StringUtils;
import com.socialize.view.BaseView;
import java.util.List;

public class CommentListView
extends BaseView {
    private int defaultGrabLength = 30;
    private int iconSize = 100;
    private IBeanFactory<CommentAdapter> commentAdapterFactory;
    private CommentAdapter commentAdapter;
    private boolean loading = true;
    private boolean headerDisplayed = true;
    private Entity entity;
    private int startIndex = 0;
    private int endIndex = this.defaultGrabLength;
    private SocializeLogger logger;
    private SimpleDialogFactory<ProgressDialog> progressDialogFactory;
    private Drawables drawables;
    private AppUtils appUtils;
    private DisplayUtils displayUtils;
    private CommentUtilsProxy commentUtils;
    private SubscriptionUtilsProxy subscriptionUtils;
    private UserUtilsProxy userUtils;
    private ProgressDialog dialog = null;
    private SocializeConfig config;
    private IBeanFactory<SocializeHeader> commentHeaderFactory;
    private IBeanFactory<CommentEditField> commentEditFieldFactory;
    private IBeanFactory<LoadingListView> commentContentViewFactory;
    private IBeanFactory<CustomCheckbox> notificationEnabledOptionFactory;
    private CommentEditField commentEntryField;
    private SocializeHeader header;
    private LoadingListView content;
    private String customHeaderText;
    private boolean showCommentCountInHeader = true;
    private IBeanFactory<CommentEntrySliderItem> commentEntryFactory;
    private ActionBarSliderView commentEntrySlider;
    private ActionBarSliderFactory<ActionBarSliderView> sliderFactory;
    private RelativeLayout layoutAnchor;
    private ViewGroup sliderAnchor;
    private CustomCheckbox notifyBox;
    private ImageLoader imageLoader;
    private CommentEntrySliderItem commentEntrySliderItem;
    private OnCommentViewActionListener onCommentViewActionListener;

    public CommentListView(Context context) {
        super(context);
    }

    public void init() {
        boolean notificationsAvailable;
        this.commentAdapter = (CommentAdapter)((Object)this.commentAdapterFactory.getBean());
        LinearLayout.LayoutParams fill = new LinearLayout.LayoutParams(-1, -1);
        this.setOrientation(1);
        this.setLayoutParams((ViewGroup.LayoutParams)fill);
        CompatUtils.setBackgroundDrawable((View)this, this.drawables.getDrawable("crosshatch.png", true, true, true));
        this.setPadding(0, 0, 0, 0);
        boolean landscape = this.displayUtils.isLandscape();
        this.iconSize = this.displayUtils.getDIP(this.iconSize);
        this.layoutAnchor = new RelativeLayout(this.getContext());
        LinearLayout.LayoutParams innerParams = new LinearLayout.LayoutParams(-1, -1);
        this.layoutAnchor.setLayoutParams((ViewGroup.LayoutParams)innerParams);
        LinearLayout top = new LinearLayout(this.getContext());
        LinearLayout middle = new LinearLayout(this.getContext());
        this.sliderAnchor = new LinearLayout(this.getContext());
        int topId = this.getNextViewId(this.getParentView());
        int middleId = this.getNextViewId(this.getParentView());
        int bottomId = this.getNextViewId(this.getParentView());
        top.setPadding(0, 0, 0, 0);
        middle.setPadding(0, 0, 0, 0);
        this.sliderAnchor.setPadding(0, 0, 0, 0);
        top.setId(topId);
        middle.setId(middleId);
        this.sliderAnchor.setId(bottomId);
        RelativeLayout.LayoutParams topParams = new RelativeLayout.LayoutParams(-1, -2);
        RelativeLayout.LayoutParams middleParams = new RelativeLayout.LayoutParams(-1, -1);
        RelativeLayout.LayoutParams bottomParams = new RelativeLayout.LayoutParams(-1, -2);
        topParams.setMargins(0, 0, 0, 0);
        middleParams.setMargins(0, 0, 0, 0);
        bottomParams.setMargins(0, 0, 0, 0);
        topParams.addRule(10);
        bottomParams.addRule(12);
        middleParams.addRule(3, topId);
        middleParams.addRule(2, bottomId);
        top.setLayoutParams((ViewGroup.LayoutParams)topParams);
        middle.setLayoutParams((ViewGroup.LayoutParams)middleParams);
        this.sliderAnchor.setLayoutParams((ViewGroup.LayoutParams)bottomParams);
        if (!landscape && this.config.isShowCommentHeader() && this.headerDisplayed) {
            this.header = (SocializeHeader)((Object)this.commentHeaderFactory.getBean());
        }
        this.commentEntryField = (CommentEditField)((Object)this.commentEditFieldFactory.getBean());
        this.content = (LoadingListView)this.commentContentViewFactory.getBean();
        if (this.commentEntryFactory != null) {
            this.commentEntrySliderItem = (CommentEntrySliderItem)this.commentEntryFactory.getBean(new Object[]{this.getCommentAddButtonListener()});
        }
        if (notificationsAvailable = this.appUtils.isNotificationsAvailable(this.getContext())) {
            this.notifyBox = (CustomCheckbox)this.notificationEnabledOptionFactory.getBean();
            this.notifyBox.setEnabled(false);
            this.notifyBox.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CommentListView.this.doNotificationStatusSave();
                }
            });
            this.notifyBox.setVisibility(8);
            try {
                UserSettings user = this.userUtils.getUserSettings(this.getContext());
                if (user.isNotificationsEnabled()) {
                    this.notifyBox.setVisibility(0);
                }
            }
            catch (SocializeException e) {
                if (this.logger != null) {
                    this.logger.error("Error getting user settings", (Throwable)e);
                }
                e.printStackTrace();
            }
            this.sliderAnchor.addView((View)this.notifyBox);
        }
        this.content.setListAdapter((ListAdapter)this.commentAdapter);
        this.content.setScrollListener(this.getCommentScrollListener());
        if (this.header != null) {
            top.addView((View)this.header);
        }
        middle.addView((View)this.content);
        this.sliderAnchor.addView((View)this.commentEntryField);
        this.layoutAnchor.addView((View)top);
        this.layoutAnchor.addView((View)middle);
        this.layoutAnchor.addView((View)this.sliderAnchor);
        this.addView((View)this.layoutAnchor);
        this.setDefaultGrabLength(ConfigUtils.getConfig(this.getContext()).getIntProperty("comment.page.size", 20));
    }

    protected CommentScrollListener getCommentScrollListener() {
        return new CommentScrollListener(new CommentScrollCallback(){

            @Override
            public void onGetNextSet() {
                CommentListView.this.getNextSet();
            }

            @Override
            public boolean isLoading() {
                return CommentListView.this.loading;
            }

            @Override
            public boolean hasMoreItems() {
                return !CommentListView.this.commentAdapter.isLast();
            }
        });
    }

    protected CommentAddButtonListener getCommentAddButtonListener() {
        return new CommentAddButtonListener(new CommentButtonCallback(){

            @Override
            public void onError(Context context, SocializeException e) {
                CommentListView.this.showError(CommentListView.this.getContext(), e);
                if (CommentListView.this.onCommentViewActionListener != null) {
                    CommentListView.this.onCommentViewActionListener.onError(e);
                }
            }

            @Override
            public void onCancel() {
                if (CommentListView.this.commentEntrySlider != null) {
                    CommentListView.this.commentEntrySlider.close();
                }
            }

            @Override
            public void onComment(String text, boolean shareLocation, boolean subscribe) {
                text = StringUtils.replaceNewLines(text, 3, 2);
                if (CommentListView.this.progressDialogFactory != null) {
                    CommentListView.this.dialog = (ProgressDialog)CommentListView.this.progressDialogFactory.show(CommentListView.this.getContext(), "socialize_comment_dialog", "socialize_please_wait");
                }
                CommentOptions options = CommentListView.this.newShareOptions();
                options.setSubscribeToUpdates(subscribe);
                options.setShowAuthDialog(true);
                options.setShowShareDialog(true);
                CommentListView.this.commentUtils.addComment(CommentListView.this.getActivity(), CommentListView.this.entity, text, options, CommentListView.this.getCommentAddListener(subscribe), new SocialNetwork[0]);
                SocializeSession session = CommentListView.this.getSocialize().getSession();
                if (session != null && session.getUserSettings() != null) {
                    session.getUserSettings().setLocationEnabled(shareLocation);
                }
            }
        });
    }

    protected CommentAddListener getCommentAddListener(final boolean subscribe) {
        return new CommentAddListener(){

            @Override
            public void onError(SocializeException error) {
                CommentListView.this.showError(CommentListView.this.getContext(), error);
                if (CommentListView.this.dialog != null) {
                    CommentListView.this.dialog.dismiss();
                }
                if (CommentListView.this.onCommentViewActionListener != null) {
                    CommentListView.this.onCommentViewActionListener.onError(error);
                }
                if (CommentListView.this.commentEntrySliderItem != null) {
                    CommentListView.this.commentEntrySliderItem.getCommentEntryView().getPostCommentButton().setEnabled(true);
                }
            }

            @Override
            public void onCreate(Comment entity) {
                List<Comment> comments = CommentListView.this.commentAdapter.getComments();
                if (comments != null) {
                    comments.add(0, entity);
                }
                CommentListView.this.startIndex++;
                CommentListView.this.endIndex++;
                if (CommentListView.this.commentEntrySlider != null) {
                    CommentListView.this.commentEntrySlider.clearContent();
                    CommentListView.this.commentEntrySlider.close();
                }
                CommentListView.this.commentAdapter.setTotalCount(CommentListView.this.commentAdapter.getTotalCount() + 1);
                CommentListView.this.commentAdapter.notifyDataSetChanged();
                CommentListView.this.setHeaderText();
                CommentListView.this.content.scrollToTop();
                if (CommentListView.this.dialog != null) {
                    CommentListView.this.dialog.dismiss();
                }
                if (CommentListView.this.notifyBox != null) {
                    CommentListView.this.notifyBox.setChecked(subscribe);
                }
                if (CommentListView.this.onCommentViewActionListener != null) {
                    CommentListView.this.onCommentViewActionListener.onPostComment(entity);
                }
                if (CommentListView.this.commentEntrySliderItem != null) {
                    CommentListView.this.commentEntrySliderItem.getCommentEntryView().getPostCommentButton().setEnabled(true);
                }
            }

            @Override
            public void onCancel() {
                if (CommentListView.this.dialog != null) {
                    CommentListView.this.dialog.dismiss();
                }
                if (CommentListView.this.commentEntrySliderItem != null) {
                    CommentListView.this.commentEntrySliderItem.getCommentEntryView().getPostCommentButton().setEnabled(true);
                }
            }
        };
    }

    public void reload() {
        this.content.showLoading();
        this.commentAdapter.reset();
        this.content.setListAdapter((ListAdapter)this.commentAdapter);
        if (this.onCommentViewActionListener != null) {
            this.onCommentViewActionListener.onReload(this);
        }
        this.doListComments(true);
    }

    public CommentAdapter getCommentAdapter() {
        return this.commentAdapter;
    }

    public void doListComments(final boolean update) {
        this.startIndex = 0;
        this.endIndex = this.defaultGrabLength;
        this.loading = true;
        final List<Comment> comments = this.commentAdapter.getComments();
        if (update || comments == null || comments.size() == 0) {
            this.commentUtils.getCommentsByEntity(this.getActivity(), this.entity.getKey(), this.startIndex, this.endIndex, new CommentListListener(){

                @Override
                public void onError(SocializeException error) {
                    CommentListView.this.showError(CommentListView.this.getContext(), error);
                    CommentListView.this.content.showList();
                    if (CommentListView.this.dialog != null) {
                        CommentListView.this.dialog.dismiss();
                    }
                    CommentListView.this.loading = false;
                    if (CommentListView.this.onCommentViewActionListener != null) {
                        CommentListView.this.onCommentViewActionListener.onError(error);
                    }
                }

                @Override
                public void onList(ListResult<Comment> entities) {
                    if (entities != null) {
                        int totalCount = entities.getTotalCount();
                        List<Comment> items = entities.getItems();
                        CommentListView.this.commentAdapter.setComments(items);
                        CommentListView.this.commentAdapter.setTotalCount(totalCount);
                        CommentListView.this.setHeaderText();
                        if (totalCount <= CommentListView.this.endIndex) {
                            CommentListView.this.commentAdapter.setLast(true);
                        }
                        if (update || comments == null || comments.size() == 0) {
                            CommentListView.this.content.scrollToTop();
                        }
                        CommentListView.this.commentAdapter.notifyDataSetChanged();
                    }
                    CommentListView.this.content.showList();
                    CommentListView.this.loading = false;
                    if (CommentListView.this.onCommentViewActionListener != null && entities != null) {
                        CommentListView.this.onCommentViewActionListener.onCommentList(CommentListView.this, entities.getItems(), CommentListView.this.startIndex, CommentListView.this.endIndex);
                    }
                    if (CommentListView.this.dialog != null) {
                        CommentListView.this.dialog.dismiss();
                    }
                }
            });
        } else {
            this.content.showList();
            this.setHeaderText();
            this.commentAdapter.notifyDataSetChanged();
            if (this.dialog != null) {
                this.dialog.dismiss();
            }
            this.loading = false;
            if (this.onCommentViewActionListener != null) {
                this.onCommentViewActionListener.onCommentList(this, comments, this.startIndex, this.endIndex);
            }
        }
    }

    protected Comment newComment() {
        return new Comment();
    }

    protected void setHeaderText() {
        if (this.header != null) {
            String name;
            String string = name = this.customHeaderText == null ? this.entity.getName() : this.customHeaderText;
            if (StringUtils.isEmpty(name)) {
                if (this.showCommentCountInHeader) {
                    this.header.setText(this.commentAdapter.getTotalCount() + " Comments");
                }
            } else if (this.showCommentCountInHeader) {
                this.header.setText(name + " (" + this.commentAdapter.getTotalCount() + ")");
            } else {
                this.header.setText(name);
            }
        }
    }

    protected void doNotificationStatusSave() {
        this.notifyBox.showLoading();
        if (this.notifyBox.isChecked()) {
            this.subscriptionUtils.subscribe(this.getActivity(), this.entity, SubscriptionType.NEW_COMMENTS, new SubscriptionResultListener(){

                @Override
                public void onError(SocializeException error) {
                    CommentListView.this.showError(CommentListView.this.getContext(), error);
                    CommentListView.this.notifyBox.setChecked(false);
                    CommentListView.this.notifyBox.hideLoading();
                }

                @Override
                public void onCreate(Subscription entity) {
                    if (CommentListView.this.commentEntrySliderItem != null) {
                        CommentListView.this.commentEntrySliderItem.getCommentEntryView().setNotifySubscribeState(true);
                    }
                    CommentListView.this.notifyBox.hideLoading();
                }
            });
        } else {
            this.subscriptionUtils.unsubscribe(this.getActivity(), this.entity, SubscriptionType.NEW_COMMENTS, new SubscriptionResultListener(){

                @Override
                public void onError(SocializeException error) {
                    CommentListView.this.showError(CommentListView.this.getContext(), error);
                    CommentListView.this.notifyBox.setChecked(true);
                    CommentListView.this.notifyBox.hideLoading();
                }

                @Override
                public void onCreate(Subscription entity) {
                    if (CommentListView.this.commentEntrySliderItem != null) {
                        CommentListView.this.commentEntrySliderItem.getCommentEntryView().setNotifySubscribeState(false);
                    }
                    CommentListView.this.notifyBox.hideLoading();
                }
            });
        }
    }

    protected void doNotificationStatusLoad() {
        if (this.notifyBox != null) {
            this.notifyBox.showLoading();
            this.subscriptionUtils.isSubscribed(this.getActivity(), this.entity, SubscriptionType.NEW_COMMENTS, new SubscriptionCheckListener(){

                @Override
                public void onSubscribed(Subscription subscription) {
                    CommentListView.this.notifyBox.setChecked(subscription.isSubscribed());
                    if (CommentListView.this.commentEntrySliderItem != null) {
                        CommentListView.this.commentEntrySliderItem.getCommentEntryView().setNotifySubscribeState(subscription.isSubscribed());
                    }
                    CommentListView.this.notifyBox.hideLoading();
                }

                @Override
                public void onNotSubscribed() {
                    CommentListView.this.notifyBox.setChecked(false);
                    if (CommentListView.this.commentEntrySliderItem != null) {
                        CommentListView.this.commentEntrySliderItem.getCommentEntryView().setNotifySubscribeState(true);
                    }
                    CommentListView.this.notifyBox.hideLoading();
                }

                @Override
                public void onError(SocializeException error) {
                    CommentListView.this.notifyBox.setChecked(false);
                    if (CommentListView.this.logger != null) {
                        CommentListView.this.logger.error("Error retrieving subscription info", (Throwable)error);
                    } else {
                        SocializeLogger.e(error.getMessage(), error);
                    }
                    if (CommentListView.this.commentEntrySliderItem != null) {
                        CommentListView.this.commentEntrySliderItem.getCommentEntryView().setNotifySubscribeState(true);
                    }
                    CommentListView.this.notifyBox.hideLoading();
                }
            });
        }
    }

    public void getNextSet() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("getNextSet called on CommentListView");
        }
        this.loading = true;
        this.startIndex = this.endIndex;
        this.endIndex += this.defaultGrabLength;
        int totalCount = this.commentAdapter.getTotalCount();
        if (this.endIndex > totalCount) {
            this.endIndex = totalCount;
            if (this.startIndex >= this.endIndex) {
                this.commentAdapter.setLast(true);
                this.commentAdapter.notifyDataSetChanged();
                this.loading = false;
                return;
            }
        }
        this.commentUtils.getCommentsByEntity(this.getActivity(), this.entity.getKey(), this.startIndex, this.endIndex, new CommentListListener(){

            @Override
            public void onError(SocializeException error) {
                if (CommentListView.this.logger != null) {
                    CommentListView.this.logger.error("Error retrieving comments", (Throwable)error);
                } else {
                    SocializeLogger.e(error.getMessage(), error);
                }
                CommentListView.this.loading = false;
                if (CommentListView.this.onCommentViewActionListener != null) {
                    CommentListView.this.onCommentViewActionListener.onError(error);
                }
            }

            @Override
            public void onList(ListResult<Comment> entities) {
                List<Comment> comments = CommentListView.this.commentAdapter.getComments();
                if (entities != null) {
                    comments.addAll(entities.getItems());
                    CommentListView.this.preLoadImages(comments);
                }
                CommentListView.this.commentAdapter.setComments(comments);
                CommentListView.this.commentAdapter.notifyDataSetChanged();
                CommentListView.this.loading = false;
                if (CommentListView.this.onCommentViewActionListener != null && entities != null) {
                    CommentListView.this.onCommentViewActionListener.onCommentList(CommentListView.this, comments, CommentListView.this.startIndex, CommentListView.this.endIndex);
                }
            }
        });
    }

    protected void preLoadImages(List<Comment> comments) {
        if (comments != null) {
            for (Comment comment : comments) {
                CacheableDrawable cached;
                String imageUrl;
                User user = comment.getUser();
                if (user == null || StringUtils.isEmpty(imageUrl = user.getSmallImageUri()) || (cached = (CacheableDrawable)this.drawables.getCache().get(imageUrl)) != null && !cached.isRecycled()) continue;
                this.imageLoader.loadImageByUrl(imageUrl, this.iconSize, this.iconSize, null);
            }
        }
    }

    @Override
    public void onViewLoad() {
        super.onViewLoad();
        if (this.onCommentViewActionListener != null) {
            this.onCommentViewActionListener.onCreate(this);
        }
        if (this.commentAdapter != null && this.onCommentViewActionListener != null) {
            this.commentAdapter.setOnCommentViewActionListener(this.onCommentViewActionListener);
        }
    }

    @Override
    public void onViewRendered(int width, int height) {
        if (this.sliderFactory != null && this.commentEntrySlider == null) {
            this.commentEntrySlider = this.sliderFactory.wrap((View)this.getSliderAnchor(), ActionBarSliderFactory.ZOrder.FRONT, height);
        }
        if (this.commentEntrySliderItem != null) {
            this.commentEntrySlider.loadItem(this.commentEntrySliderItem);
            this.commentEntryField.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (CommentListView.this.commentEntrySlider != null) {
                        CommentListView.this.commentEntrySlider.showSliderItem(CommentListView.this.commentEntrySliderItem);
                    }
                }
            });
        } else if (this.commentEntryField != null) {
            this.commentEntryField.setVisibility(8);
        }
        if (this.getSocialize().isAuthenticated()) {
            this.doListComments(false);
            this.doNotificationStatusLoad();
        } else {
            SocializeException e = new SocializeException("Socialize not authenticated");
            this.showError(this.getContext(), e);
            if (this.onCommentViewActionListener != null) {
                this.onCommentViewActionListener.onError(e);
            }
            if (this.content != null) {
                this.content.showList();
            }
        }
        if (this.onCommentViewActionListener != null) {
            this.onCommentViewActionListener.onRender(this);
        }
    }

    public void setCommentAdapter(CommentAdapter commentAdapter) {
        this.commentAdapter = commentAdapter;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setProgressDialogFactory(SimpleDialogFactory<ProgressDialog> progressDialogFactory) {
        this.progressDialogFactory = progressDialogFactory;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setDefaultGrabLength(int defaultGrabLength) {
        this.defaultGrabLength = defaultGrabLength;
    }

    public void setCommentHeaderFactory(IBeanFactory<SocializeHeader> commentHeaderFactory) {
        this.commentHeaderFactory = commentHeaderFactory;
    }

    public void setCommentEditFieldFactory(IBeanFactory<CommentEditField> commentEditFieldFactory) {
        this.commentEditFieldFactory = commentEditFieldFactory;
    }

    public void setCommentContentViewFactory(IBeanFactory<LoadingListView> commentContentViewFactory) {
        this.commentContentViewFactory = commentContentViewFactory;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    public void setNotificationEnabledOptionFactory(IBeanFactory<CustomCheckbox> notificationEnabledOptionFactory) {
        this.notificationEnabledOptionFactory = notificationEnabledOptionFactory;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public boolean isLoading() {
        return this.loading;
    }

    protected void setLoading(boolean loading) {
        this.loading = loading;
    }

    protected void setCommentEntryField(CommentEditField field) {
        this.commentEntryField = field;
    }

    protected void setHeader(SocializeHeader header) {
        this.header = header;
    }

    protected void setContent(LoadingListView content) {
        this.content = content;
    }

    protected void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    protected void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setCommentEntryFactory(IBeanFactory<CommentEntrySliderItem> commentEntryFactory) {
        this.commentEntryFactory = commentEntryFactory;
    }

    public int getTotalCount() {
        return this.commentAdapter.getTotalCount();
    }

    public void onProfileUpdate() {
        this.commentAdapter.notifyDataSetChanged();
        if (this.commentEntrySlider != null) {
            this.commentEntrySlider.updateContent();
        }
        if (this.notifyBox != null) {
            try {
                UserSettings user = this.userUtils.getUserSettings(this.getContext());
                if (user.isNotificationsEnabled()) {
                    this.notifyBox.setVisibility(0);
                } else {
                    this.notifyBox.setVisibility(8);
                }
            }
            catch (SocializeException e) {
                if (this.logger != null) {
                    this.logger.error("Error getting user settings", (Throwable)e);
                } else {
                    e.printStackTrace();
                }
                this.notifyBox.setVisibility(8);
            }
        }
    }

    protected CommentOptions newShareOptions() {
        return this.commentUtils.getUserCommentOptions(this.getContext());
    }

    protected RelativeLayout getLayoutAnchor() {
        return this.layoutAnchor;
    }

    protected ViewGroup getSliderAnchor() {
        return this.sliderAnchor;
    }

    public void setSliderFactory(ActionBarSliderFactory<ActionBarSliderView> sliderFactory) {
        this.sliderFactory = sliderFactory;
    }

    public void setOnCommentViewActionListener(OnCommentViewActionListener onCommentViewActionListener) {
        this.onCommentViewActionListener = onCommentViewActionListener;
        if (this.commentAdapter != null) {
            this.commentAdapter.setOnCommentViewActionListener(onCommentViewActionListener);
        }
    }

    public ActionBarSliderView getCommentEntryViewSlider() {
        return this.commentEntrySlider;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    public void setDisplayUtils(DisplayUtils displayUtils) {
        this.displayUtils = displayUtils;
    }

    public void setCommentUtils(CommentUtilsProxy commentUtils) {
        this.commentUtils = commentUtils;
    }

    public void setSubscriptionUtils(SubscriptionUtilsProxy subscriptionUtils) {
        this.subscriptionUtils = subscriptionUtils;
    }

    public void setUserUtils(UserUtilsProxy userUtils) {
        this.userUtils = userUtils;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public CommentEditField getCommentEntryField() {
        return this.commentEntryField;
    }

    public String getCustomHeaderText() {
        return this.customHeaderText;
    }

    public void setCustomHeaderText(String customHeaderText) {
        this.customHeaderText = customHeaderText;
    }

    public boolean isShowCommentCountInHeader() {
        return this.showCommentCountInHeader;
    }

    public void setShowCommentCountInHeader(boolean showCommentCountInHeader) {
        this.showCommentCountInHeader = showCommentCountInHeader;
    }

    public void setCommentAdapterFactory(IBeanFactory<CommentAdapter> commentAdapterFactory) {
        this.commentAdapterFactory = commentAdapterFactory;
    }

    public SocializeHeader getHeader() {
        return this.header;
    }

    public LoadingListView getContent() {
        return this.content;
    }

    public void setHeaderDisplayed(boolean showHeader) {
        this.headerDisplayed = showHeader;
        if (this.header != null) {
            if (this.headerDisplayed) {
                this.header.setVisibility(0);
            } else {
                this.header.setVisibility(8);
            }
        }
    }
}

