/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.comment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.SocializeUIActivity;
import com.socialize.ui.comment.CommentView;
import com.socialize.ui.slider.ActionBarSliderView;
import com.socialize.util.DefaultAppUtils;

public class CommentActivity
extends SocializeUIActivity {
    private CommentView view;

    @Override
    protected void onCreateSafe(Bundle savedInstanceState) {
        Bundle extras = this.getIntent().getExtras();
        if (extras == null || !extras.containsKey("socialize.entity")) {
            SocializeLogger.w("No entity found for Comment Activity. Aborting");
            this.finish();
        } else {
            Object entity = extras.get("socialize.entity");
            if (entity == null) {
                SocializeLogger.w("No entity found for Comment Activity. Aborting");
                this.finish();
            } else {
                this.view = new CommentView((Context)this);
                this.setContentView((View)this.view);
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            ActionBarSliderView slider;
            if (this.view != null && (slider = this.view.getCommentEntryViewSlider()) != null && slider.getDisplayState().equals((Object)ActionBarSliderView.DisplayState.MAXIMIZE)) {
                slider.close();
                return true;
            }
            if (this.isTaskRoot() && DefaultAppUtils.launchMainApp(this)) {
                this.finish();
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == 1347) {
            this.view.onProfileUpdate();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        if (this.view != null) {
            return this.view.onCreateOptionsMenu(this, menu);
        }
        return false;
    }

    @Override
    public void onCreateContextMenu(ContextMenu menu, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (this.view != null) {
            this.view.onCreateContextMenu(this, menu, v, menuInfo);
        }
    }

    @Override
    public boolean onContextItemSelected(MenuItem item) {
        if (this.view != null) {
            return this.view.onContextItemSelected(this, item);
        }
        return super.onContextItemSelected(item);
    }
}

