/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.animation;

import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;

public class RotatingFadeViewAnimator {
    private int size;
    private View[] views;
    private int currentView = 0;
    private long fadeInTime = 1000L;
    private long fadeOutTime = 1000L;
    private long stickTime = 2000L;
    private AlphaAnimation fadeIn;
    private AlphaAnimation fadeOut;

    public RotatingFadeViewAnimator(int size) {
        this.views = new View[size];
        this.size = size;
    }

    public void addView(int order, View view) {
        this.views[order] = view;
        if (order > 0) {
            view.setVisibility(8);
        }
    }

    public void setFadeInTime(long fadeInTime) {
        this.fadeInTime = fadeInTime;
    }

    public void setFadeOutTime(long fadeOutTime) {
        this.fadeOutTime = fadeOutTime;
    }

    public void setStickTime(long stickTime) {
        this.stickTime = stickTime;
    }

    public void startAt(int index) {
        this.currentView = index;
        this.start();
    }

    public void start() {
        if (this.fadeIn == null || this.fadeOut == null) {
            this.initAnimations();
        }
        View view = this.getCurrentView();
        view.startAnimation((Animation)this.fadeIn);
    }

    public void stop() {
        if (this.fadeIn != null) {
            this.fadeIn.reset();
        }
        if (this.fadeOut != null) {
            this.fadeOut.reset();
        }
        for (View view : this.views) {
            view.clearAnimation();
            view.setVisibility(8);
        }
        this.currentView = 0;
    }

    public void reset() {
        this.restartAt(0);
    }

    public void skipToNext() {
        this.restartAt((this.currentView + 1) % this.size);
    }

    protected void restartAt(int index) {
        this.stop();
        this.startAt(index);
    }

    protected View getCurrentView() {
        return this.views[this.currentView];
    }

    protected View getNextView() {
        this.currentView = (this.currentView + 1) % this.size;
        return this.getCurrentView();
    }

    protected void initAnimations() {
        this.fadeIn = new AlphaAnimation(0.0f, 1.0f);
        this.fadeIn.setDuration(this.fadeInTime);
        this.fadeOut = new AlphaAnimation(1.0f, 0.0f);
        this.fadeOut.setStartOffset(this.stickTime);
        this.fadeOut.setDuration(this.fadeOutTime);
        this.fadeIn.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                View view = RotatingFadeViewAnimator.this.getCurrentView();
                view.setVisibility(0);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                View view = RotatingFadeViewAnimator.this.getCurrentView();
                view.startAnimation((Animation)RotatingFadeViewAnimator.this.fadeOut);
            }
        });
        this.fadeOut.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                View current = RotatingFadeViewAnimator.this.getCurrentView();
                View next = RotatingFadeViewAnimator.this.getNextView();
                current.setVisibility(8);
                next.setVisibility(0);
                next.startAnimation((Animation)RotatingFadeViewAnimator.this.fadeIn);
            }
        });
    }
}

