/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.actionbar;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import com.socialize.entity.Entity;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.actionbar.ActionBarEditView;
import com.socialize.ui.actionbar.ActionBarLayoutView;
import com.socialize.ui.actionbar.ActionBarListener;
import com.socialize.ui.actionbar.ActionBarLoadingView;
import com.socialize.ui.actionbar.ActionBarOptions;
import com.socialize.ui.actionbar.OnActionBarEventListener;
import com.socialize.ui.actionbar.OnActionBarReloadListener;
import com.socialize.ui.comment.OnCommentViewActionListener;
import com.socialize.ui.view.EntityView;

public class ActionBarView
extends EntityView {
    public static final int ACTION_BAR_HEIGHT = 44;
    public static final int ACTION_BAR_BUTTON_WIDTH = 80;
    private ActionBarLayoutView actionBarLayoutView;
    private ActionBarListener actionBarListener;
    private ActionBarOptions actionBarOptions;
    private Entity entity;
    private OnActionBarEventListener onActionBarEventListener;
    private OnCommentViewActionListener onCommentViewActionListener;

    public ActionBarView(Context context) {
        super(context);
    }

    public ActionBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public View getLoadingView() {
        ActionBarLoadingView loadingView = new ActionBarLoadingView(this.getContext());
        loadingView.init(this.getActivity());
        return loadingView;
    }

    @Override
    protected View getView(Bundle bundle, Object ... entityKeys) {
        if (this.actionBarLayoutView == null) {
            this.actionBarLayoutView = (ActionBarLayoutView)this.container.getBean("actionBarLayoutView", new Object[]{this, this.actionBarOptions});
            if (this.actionBarLayoutView == null) {
                SocializeLogger.w("Request for bean [actionBarLayoutView] returned null");
            }
        }
        this.setListeners();
        if (this.actionBarListener != null) {
            this.actionBarListener.onCreate(this);
        }
        return this.actionBarLayoutView;
    }

    protected void setListeners() {
        if (this.actionBarLayoutView != null) {
            if (this.onActionBarEventListener != null) {
                this.actionBarLayoutView.setOnActionBarEventListener(this.onActionBarEventListener);
            }
            if (this.onCommentViewActionListener != null) {
                this.actionBarLayoutView.setOnCommentViewActionListener(this.onCommentViewActionListener);
            }
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    protected String[] getBundleKeys() {
        return null;
    }

    @Override
    public void showError(Context context, Exception e) {
        SocializeLogger.e(e.getMessage(), e);
    }

    @Override
    protected View getEditModeView() {
        return new ActionBarEditView(this.getContext());
    }

    public void setOnActionBarEventListener(OnActionBarEventListener onActionBarEventListener) {
        this.onActionBarEventListener = onActionBarEventListener;
        this.setListeners();
    }

    public void setOnCommentViewActionListener(OnCommentViewActionListener onCommentViewActionListener) {
        this.onCommentViewActionListener = onCommentViewActionListener;
        this.setListeners();
    }

    public void refresh() {
        this.refresh(null);
    }

    public void refresh(OnActionBarReloadListener listener) {
        if (this.actionBarLayoutView != null) {
            this.actionBarLayoutView.reload(listener);
        }
    }

    public void stopTicker() {
        if (this.actionBarLayoutView != null) {
            this.actionBarLayoutView.stopTicker();
        }
    }

    public void startTicker() {
        if (this.actionBarLayoutView != null) {
            this.actionBarLayoutView.startTicker();
        }
    }

    public void setActionBarListener(ActionBarListener actionBarListener) {
        this.actionBarListener = actionBarListener;
    }

    public ActionBarOptions getActionBarOptions() {
        return this.actionBarOptions;
    }

    public void setActionBarOptions(ActionBarOptions actionBarOptions) {
        this.actionBarOptions = actionBarOptions;
    }
}

