/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.actionbar;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.socialize.EntityUtils;
import com.socialize.LikeUtils;
import com.socialize.ShareUtils;
import com.socialize.ViewUtils;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.action.comment.CommentUtilsProxy;
import com.socialize.api.action.share.ShareUtilsProxy;
import com.socialize.api.action.share.SocialNetworkDialogListener;
import com.socialize.entity.Entity;
import com.socialize.entity.EntityStats;
import com.socialize.entity.Like;
import com.socialize.entity.View;
import com.socialize.error.SocializeApiError;
import com.socialize.error.SocializeException;
import com.socialize.i18n.LocalizationService;
import com.socialize.listener.entity.EntityGetListener;
import com.socialize.listener.like.LikeAddListener;
import com.socialize.listener.like.LikeDeleteListener;
import com.socialize.listener.like.LikeGetListener;
import com.socialize.listener.view.ViewAddListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.ui.actionbar.ActionBarButton;
import com.socialize.ui.actionbar.ActionBarButtonBackground;
import com.socialize.ui.actionbar.ActionBarButtonListener;
import com.socialize.ui.actionbar.ActionBarItem;
import com.socialize.ui.actionbar.ActionBarOptions;
import com.socialize.ui.actionbar.ActionBarTicker;
import com.socialize.ui.actionbar.ActionBarView;
import com.socialize.ui.actionbar.OnActionBarEventListener;
import com.socialize.ui.actionbar.OnActionBarReloadListener;
import com.socialize.ui.cache.CacheableEntity;
import com.socialize.ui.cache.EntityCache;
import com.socialize.ui.comment.OnCommentViewActionListener;
import com.socialize.ui.dialog.ProgressDialogFactory;
import com.socialize.ui.util.CompatUtils;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.view.BaseView;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.json.JSONObject;

public class ActionBarLayoutView
extends BaseView {
    static final NumberFormat countFormat = new DecimalFormat("##0.0K");
    private LocalizationService localizationService;
    private ActionBarButton commentButton;
    private ActionBarButton likeButton;
    private ActionBarButton shareButton;
    private ActionBarTicker ticker;
    private ActionBarItem viewsItem;
    private ActionBarItem commentsItem;
    private ActionBarItem likesItem;
    private ActionBarItem sharesItem;
    private Drawables drawables;
    private EntityCache entityCache;
    private SocializeLogger logger;
    private Drawable likeIcon;
    private Drawable likeIconHi;
    private Drawable commentIcon;
    private Drawable viewIcon;
    private Drawable shareIcon;
    private IBeanFactory<ActionBarButton> buttonFactory;
    private IBeanFactory<ActionBarTicker> tickerFactory;
    private IBeanFactory<ActionBarItem> itemFactory;
    private ProgressDialogFactory progressDialogFactory;
    private DisplayUtils displayUtils;
    private ShareUtilsProxy shareUtils;
    private CommentUtilsProxy commentUtils;
    private ActionBarView actionBarView;
    private ActionBarOptions options;
    final String loadingText = "...";
    private OnActionBarEventListener onActionBarEventListener;
    private OnCommentViewActionListener onCommentViewActionListener;

    public ActionBarLayoutView(Activity context, ActionBarView actionBarView) {
        this(context, actionBarView, new ActionBarOptions());
    }

    public ActionBarLayoutView(Activity context, ActionBarView actionBarView, ActionBarOptions options) {
        super((Context)context);
        this.actionBarView = actionBarView;
        this.options = options;
    }

    private Drawable getIcon(Integer resourceId, String defaultName) {
        return resourceId == null ? this.drawables.getDrawable(defaultName) : this.getContext().getResources().getDrawable(resourceId.intValue());
    }

    public void init() {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("init called on " + this.getClass().getSimpleName());
        }
        int height = 44;
        if (this.displayUtils != null) {
            height = this.displayUtils.getDIP(44);
        }
        LinearLayout.LayoutParams masterParams = new LinearLayout.LayoutParams(-1, height);
        masterParams.gravity = this.options.getGravity() | 0x10;
        this.setLayoutParams((ViewGroup.LayoutParams)masterParams);
        this.setGravity(this.options.getGravity());
        if (!this.options.isHideLike() || !this.options.isHideTicker()) {
            this.likeIcon = this.getIcon(this.options.getLikeIconResourceId(), "icon_like.png");
            this.likeIconHi = this.getIcon(this.options.getLikeIconActiveResourceId(), "icon_like_hi.png");
        }
        if (!this.options.isHideComment() || !this.options.isHideTicker()) {
            this.commentIcon = this.getIcon(this.options.getCommentIconResourceId(), "icon_comment.png");
        }
        if (!this.options.isHideShare() || !this.options.isHideTicker()) {
            this.shareIcon = this.getIcon(this.options.getShareIconResourceId(), "icon_share.png");
        }
        if (!this.options.isHideTicker()) {
            this.viewIcon = this.getIcon(this.options.getViewIconResourceId(), "icon_view.png");
        }
        int accentHeight = this.displayUtils.getDIP(4);
        int strokeWidth = this.displayUtils.getDIP(1);
        int width = 80;
        int likeWidth = width - 5;
        int commentWidth = width + 15;
        int shareWidth = width - 5;
        if (!this.options.isHideTicker()) {
            this.ticker = (ActionBarTicker)((Object)this.tickerFactory.getBean(new Object[]{this.options.getBackgroundColor()}));
        }
        int textColor = -1;
        if (this.options.getTextColor() != null) {
            textColor = this.options.getTextColor();
        }
        if (!this.options.isHideComment() || !this.options.isHideTicker()) {
            this.commentsItem = (ActionBarItem)((Object)this.itemFactory.getBean(new Object[]{textColor}));
            this.commentsItem.setIcon(this.commentIcon);
            if (!this.options.isHideComment()) {
                this.commentButton = (ActionBarButton)((Object)this.buttonFactory.getBean());
            }
        }
        if (!this.options.isHideLike() || !this.options.isHideTicker()) {
            this.likesItem = (ActionBarItem)((Object)this.itemFactory.getBean(new Object[]{textColor}));
            this.likesItem.setIcon(this.likeIcon);
            if (!this.options.isHideLike()) {
                this.likeButton = (ActionBarButton)((Object)this.buttonFactory.getBean());
            }
        }
        if (!this.options.isHideShare() || !this.options.isHideTicker()) {
            this.sharesItem = (ActionBarItem)((Object)this.itemFactory.getBean(new Object[]{textColor}));
            this.sharesItem.setIcon(this.shareIcon);
            if (!this.options.isHideShare()) {
                this.shareButton = (ActionBarButton)((Object)this.buttonFactory.getBean());
            }
        }
        if (!this.options.isHideTicker()) {
            this.viewsItem = (ActionBarItem)((Object)this.itemFactory.getBean(new Object[]{textColor}));
            this.viewsItem.setIcon(this.viewIcon);
            this.ticker.addTickerView((android.view.View)this.viewsItem);
            this.ticker.addTickerView((android.view.View)this.commentsItem);
            this.ticker.addTickerView((android.view.View)this.likesItem);
            this.ticker.addTickerView((android.view.View)this.sharesItem);
        }
        ActionBarButtonBackground bg = new ActionBarButtonBackground(accentHeight, strokeWidth, this.options.getStrokeColor(), this.options.getAccentColor(), this.options.getFillColor(), this.options.getHighlightColor(), this.options.getColorLayout());
        if (this.commentButton != null) {
            this.commentButton.setIcon(this.commentIcon);
            CompatUtils.setBackgroundDrawable((android.view.View)this.commentButton, (Drawable)bg);
            this.commentButton.setListener(new ActionBarButtonListener(){

                @Override
                public void onClick(ActionBarButton button) {
                    boolean consumed = false;
                    if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                        consumed = ActionBarLayoutView.this.onActionBarEventListener.onClick(ActionBarLayoutView.this.actionBarView, OnActionBarEventListener.ActionBarEvent.COMMENT);
                    }
                    if (!consumed) {
                        ActionBarLayoutView.this.commentUtils.showCommentView(ActionBarLayoutView.this.getActivity(), ActionBarLayoutView.this.actionBarView.getEntity(), ActionBarLayoutView.this.onCommentViewActionListener);
                    }
                }
            });
        }
        if (this.likeButton != null) {
            this.likeButton.setIcon(this.likeIcon);
            CompatUtils.setBackgroundDrawable((android.view.View)this.likeButton, (Drawable)bg);
            this.likeButton.setListener(new ActionBarButtonListener(){

                @Override
                public void onClick(ActionBarButton button) {
                    boolean consumed = false;
                    if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                        consumed = ActionBarLayoutView.this.onActionBarEventListener.onClick(ActionBarLayoutView.this.actionBarView, OnActionBarEventListener.ActionBarEvent.LIKE);
                    }
                    if (!consumed) {
                        ActionBarLayoutView.this.doLike(ActionBarLayoutView.this.likeButton, null);
                    }
                }
            });
        }
        if (this.shareButton != null) {
            this.shareButton.setIcon(this.shareIcon);
            CompatUtils.setBackgroundDrawable((android.view.View)this.shareButton, (Drawable)bg);
            this.shareButton.setListener(new ActionBarButtonListener(){

                @Override
                public void onClick(ActionBarButton button) {
                    boolean consumed = false;
                    SocialNetworkDialogListener snListener = null;
                    if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                        consumed = ActionBarLayoutView.this.onActionBarEventListener.onClick(ActionBarLayoutView.this.actionBarView, OnActionBarEventListener.ActionBarEvent.SHARE);
                        if (ActionBarLayoutView.this.onActionBarEventListener instanceof SocialNetworkDialogListener) {
                            snListener = (SocialNetworkDialogListener)((Object)ActionBarLayoutView.this.onActionBarEventListener);
                        }
                    }
                    if (!consumed) {
                        if (snListener == null) {
                            snListener = new SocialNetworkDialogListener(){

                                @Override
                                public void onError(SocializeException error) {
                                    Toast.makeText((Context)ActionBarLayoutView.this.getActivity(), (CharSequence)ActionBarLayoutView.this.localizationService.getString("socialize_actionbar_toast_sharefail"), (int)0).show();
                                }

                                @Override
                                public void onNetworkError(Activity context, SocialNetwork network, Exception error) {
                                    Toast.makeText((Context)context, (CharSequence)ActionBarLayoutView.this.localizationService.getString("socialize_actionbar_toast_sharefail"), (int)0).show();
                                }

                                @Override
                                public void onAfterPost(Activity parent, SocialNetwork socialNetwork, JSONObject responseObject) {
                                    Toast.makeText((Context)parent, (CharSequence)ActionBarLayoutView.this.localizationService.getString("socialize_actionbar_toast_sharesuccess"), (int)0).show();
                                }

                                @Override
                                public void onCancel(Dialog dialog) {
                                    dialog.dismiss();
                                }
                            };
                        }
                        ShareUtils.showShareDialog(ActionBarLayoutView.this.getActivity(), ActionBarLayoutView.this.actionBarView.getEntity(), snListener);
                    }
                }
            });
        }
        if (this.ticker != null) {
            this.ticker.setOnClickListener(new View.OnClickListener(){

                public void onClick(android.view.View v) {
                    boolean consumed = false;
                    if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                        consumed = ActionBarLayoutView.this.onActionBarEventListener.onClick(ActionBarLayoutView.this.actionBarView, OnActionBarEventListener.ActionBarEvent.VIEW);
                    }
                    if (!consumed) {
                        ActionBarLayoutView.this.ticker.skipToNext();
                    }
                }
            });
        }
        if (this.viewsItem != null) {
            this.viewsItem.init();
            this.viewsItem.setText("...");
        }
        if (this.commentsItem != null) {
            this.commentsItem.init();
            this.commentsItem.setText("...");
            if (this.commentButton != null) {
                this.commentButton.init(commentWidth, 0.0f, textColor);
                this.commentButton.setText(this.localizationService.getString("socialize_actionbar_label_comment"));
            }
        }
        if (this.likesItem != null) {
            this.likesItem.init();
            this.likesItem.setText("...");
            if (this.likeButton != null) {
                this.likeButton.init(likeWidth, 0.0f, textColor);
                this.likeButton.setText("...");
            }
        }
        if (this.sharesItem != null) {
            this.sharesItem.init();
            this.sharesItem.setText("...");
            if (this.shareButton != null) {
                this.shareButton.init(shareWidth, 0.0f, textColor);
                this.shareButton.setText(this.localizationService.getString("socialize_actionbar_label_share"));
            }
        }
        if (this.ticker != null) {
            this.ticker.init(-1, 1.0f);
        }
        if (this.ticker != null) {
            this.addView((android.view.View)this.ticker);
        }
        if (this.likeButton != null) {
            this.addView((android.view.View)this.likeButton);
        }
        if (this.shareButton != null) {
            this.addView((android.view.View)this.shareButton);
        }
        if (this.commentButton != null) {
            this.addView((android.view.View)this.commentButton);
        }
    }

    @Override
    public void onViewLoad() {
        super.onViewLoad();
        this.doLoadSequence(false, null);
    }

    @Override
    public void onViewUpdate() {
        super.onViewUpdate();
        this.doLoadSequence(true, null);
    }

    protected void doLoadSequence(boolean reload, OnActionBarReloadListener listener) {
        this.shareUtils.preloadShareDialog(this.getActivity());
        this.shareUtils.preloadLinkDialog(this.getActivity());
        Entity userProvidedEntity = this.actionBarView.getEntity();
        if (this.ticker != null) {
            this.ticker.resetTicker();
        }
        if (userProvidedEntity != null) {
            if (reload) {
                if (this.viewsItem != null) {
                    this.viewsItem.setText("...");
                }
                if (this.commentsItem != null) {
                    this.commentsItem.setText("...");
                }
                if (this.likesItem != null) {
                    this.likesItem.setText("...");
                }
                if (this.sharesItem != null) {
                    this.sharesItem.setText("...");
                }
                if (this.likeButton != null) {
                    this.likeButton.setText("...");
                }
                if (this.onActionBarEventListener != null) {
                    this.onActionBarEventListener.onUpdate(this.actionBarView);
                }
            } else {
                if (this.ticker != null) {
                    this.ticker.startTicker();
                }
                if (this.onActionBarEventListener != null) {
                    this.onActionBarEventListener.onLoad(this.actionBarView);
                }
            }
            this.updateEntity(userProvidedEntity, reload, listener);
        } else if (this.logger != null) {
            this.logger.warn("No entity provided to ActionBar.  Load sequence aborted.");
        }
    }

    @Override
    public void onViewError(Exception e) {
        super.onViewError(e);
        if (this.onActionBarEventListener != null) {
            this.onActionBarEventListener.onLoadFail(e);
        }
    }

    protected void updateEntity(final Entity entity, boolean reload, final OnActionBarReloadListener listener) {
        CacheableEntity localEntity = this.getLocalEntity();
        if (localEntity == null) {
            ViewUtils.view(this.getActivity(), entity, new ViewAddListener(){

                @Override
                public void onError(SocializeException error) {
                    SocializeLogger.e(error.getMessage(), error);
                    ActionBarLayoutView.this.getLike(entity.getKey(), listener);
                }

                @Override
                public void onCreate(View view) {
                    ActionBarLayoutView.this.getLike(view.getEntity().getKey(), listener);
                }
            });
        } else if (reload) {
            if (localEntity.isLiked()) {
                this.getLike(entity.getKey(), listener);
            } else {
                this.getEntity(entity.getKey(), listener);
            }
        } else {
            if (this.onActionBarEventListener != null) {
                this.onActionBarEventListener.onGetEntity(this.actionBarView, localEntity.getEntity());
            }
            this.setEntityData(localEntity, listener);
        }
    }

    public void reload() {
        this.reload(null);
    }

    public void reload(OnActionBarReloadListener listener) {
        if (this.actionBarView.getEntity() != null) {
            this.entityCache.remove(this.actionBarView.getEntity().getKey());
        }
        this.doLoadSequence(true, listener);
    }

    protected void doLike(final ActionBarButton button, final OnActionBarReloadListener listener) {
        CacheableEntity localEntity = this.getLocalEntity();
        if (localEntity != null && localEntity.isLiked()) {
            this.doUnLike(button, localEntity, listener);
            return;
        }
        button.showLoading();
        LikeUtils.like(this.getActivity(), this.actionBarView.getEntity(), new LikeAddListener(){

            @Override
            public void onCancel() {
                button.hideLoading();
            }

            @Override
            public void onError(SocializeException error) {
                ActionBarLayoutView.this.logError("Error posting like", error);
                button.hideLoading();
            }

            @Override
            public void onCreate(Like like) {
                CacheableEntity localEntity = ActionBarLayoutView.this.setLocalEntity(like.getEntity());
                localEntity.setLiked(true);
                localEntity.setLikeId(like.getId());
                ActionBarLayoutView.this.setEntityData(localEntity, listener);
                button.hideLoading();
                if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                    ActionBarLayoutView.this.onActionBarEventListener.onPostLike(ActionBarLayoutView.this.actionBarView, like);
                }
            }
        });
    }

    protected void doUnLike(final ActionBarButton button, final CacheableEntity localEntity, final OnActionBarReloadListener listener) {
        button.showLoading();
        LikeUtils.unlike(this.getActivity(), localEntity.getKey(), new LikeDeleteListener(){

            @Override
            public void onError(SocializeException error) {
                ActionBarLayoutView.this.logError("Error deleting like", error);
                localEntity.setLiked(false);
                ActionBarLayoutView.this.setEntityData(localEntity, listener);
                button.hideLoading();
            }

            @Override
            public void onDelete() {
                localEntity.setLiked(false);
                ActionBarLayoutView.this.setEntityData(localEntity, listener);
                button.hideLoading();
                if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                    ActionBarLayoutView.this.onActionBarEventListener.onPostUnlike(ActionBarLayoutView.this.actionBarView);
                }
            }
        });
    }

    protected CacheableEntity getLocalEntity() {
        if (this.entityCache != null && this.actionBarView != null && this.actionBarView.getEntity() != null) {
            return (CacheableEntity)this.entityCache.get(this.actionBarView.getEntity().getKey());
        }
        return null;
    }

    protected CacheableEntity setLocalEntity(Entity entity) {
        if (this.actionBarView.getEntity() != null) {
            if (entity.getKey().equals(this.actionBarView.getEntity().getKey())) {
                return this.entityCache.putEntity(entity);
            }
            return this.entityCache.putEntity(this.actionBarView.getEntity());
        }
        return this.entityCache.putEntity(entity);
    }

    protected void getLike(final String entityKey, final OnActionBarReloadListener listener) {
        LikeUtils.getLike(this.getActivity(), entityKey, new LikeGetListener(){

            @Override
            public void onGet(Like like) {
                if (like != null) {
                    CacheableEntity putEntity = ActionBarLayoutView.this.setLocalEntity(like.getEntity());
                    putEntity.setLiked(true);
                    putEntity.setLikeId(like.getId());
                    ActionBarLayoutView.this.setEntityData(putEntity, listener);
                    if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                        ActionBarLayoutView.this.onActionBarEventListener.onGetLike(ActionBarLayoutView.this.actionBarView, like);
                    }
                    if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                        ActionBarLayoutView.this.onActionBarEventListener.onGetEntity(ActionBarLayoutView.this.actionBarView, like.getEntity());
                    }
                } else {
                    ActionBarLayoutView.this.getEntity(entityKey, listener);
                }
            }

            @Override
            public void onError(SocializeException error) {
                if (error instanceof SocializeApiError && ((SocializeApiError)error).getResultCode() == 404) {
                    ActionBarLayoutView.this.getEntity(entityKey, listener);
                    return;
                }
                if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                    ActionBarLayoutView.this.onActionBarEventListener.onLoadFail(error);
                }
                ActionBarLayoutView.this.logError("Error retrieving entity data", error);
            }
        });
    }

    protected void getEntity(String entityKey, final OnActionBarReloadListener listener) {
        EntityUtils.getEntity(this.getActivity(), entityKey, new EntityGetListener(){

            @Override
            public void onGet(Entity entity) {
                CacheableEntity putEntity = ActionBarLayoutView.this.setLocalEntity(entity);
                ActionBarLayoutView.this.setEntityData(putEntity, listener);
                if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                    ActionBarLayoutView.this.onActionBarEventListener.onGetEntity(ActionBarLayoutView.this.actionBarView, entity);
                }
            }

            @Override
            public void onError(SocializeException error) {
                if (ActionBarLayoutView.this.logger != null && ActionBarLayoutView.this.logger.isDebugEnabled()) {
                    ActionBarLayoutView.this.logger.debug("Error retrieving entity data.  This may be ok if the entity is new", error);
                }
                if (ActionBarLayoutView.this.onActionBarEventListener != null) {
                    ActionBarLayoutView.this.onActionBarEventListener.onLoadFail(error);
                }
            }
        });
    }

    protected void setEntityData(CacheableEntity ce, OnActionBarReloadListener listener) {
        Entity entity = ce.getEntity();
        this.actionBarView.setEntity(entity);
        EntityStats stats = entity.getEntityStats();
        if (stats != null) {
            if (this.viewsItem != null) {
                this.viewsItem.setText(this.getCountText(stats.getViews()));
            }
            if (this.commentsItem != null) {
                this.commentsItem.setText(this.getCountText(stats.getComments()));
            }
            if (this.likesItem != null) {
                this.likesItem.setText(this.getCountText(stats.getLikes()));
            }
            if (this.sharesItem != null) {
                this.sharesItem.setText(this.getCountText(stats.getShares()));
            }
        }
        if (this.likeButton != null) {
            if (ce.isLiked()) {
                this.likeButton.setText(this.localizationService.getString("socialize_actionbar_label_unlike"));
                this.likeButton.setIcon(this.likeIconHi);
            } else {
                this.likeButton.setText(this.localizationService.getString("socialize_actionbar_label_like"));
                this.likeButton.setIcon(this.likeIcon);
            }
        }
        if (listener != null) {
            listener.onReload(entity);
        }
    }

    protected String getCountText(Integer value) {
        String viewText = "0";
        if (value != null) {
            int iVal = value;
            if (iVal >= 1000) {
                float fVal = (float)iVal / 1000.0f;
                viewText = countFormat.format(fVal);
            } else {
                viewText = value.toString();
            }
        }
        return viewText;
    }

    protected void logError(String msg, Exception error) {
        if (this.logger != null) {
            this.logger.error(msg, (Throwable)error);
        } else {
            SocializeLogger.e(msg, error);
        }
    }

    public ActionBarButton getShareButton() {
        return this.shareButton;
    }

    public ActionBarButton getCommentButton() {
        return this.commentButton;
    }

    public ActionBarButton getLikeButton() {
        return this.likeButton;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setButtonFactory(IBeanFactory<ActionBarButton> buttonFactory) {
        this.buttonFactory = buttonFactory;
    }

    public void setEntityCache(EntityCache entityCache) {
        this.entityCache = entityCache;
    }

    public ProgressDialogFactory getProgressDialogFactory() {
        return this.progressDialogFactory;
    }

    public void setProgressDialogFactory(ProgressDialogFactory progressDialogFactory) {
        this.progressDialogFactory = progressDialogFactory;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setTickerFactory(IBeanFactory<ActionBarTicker> tickerFactory) {
        this.tickerFactory = tickerFactory;
    }

    public void setItemFactory(IBeanFactory<ActionBarItem> itemFactory) {
        this.itemFactory = itemFactory;
    }

    public void setShareUtils(ShareUtilsProxy shareUtils) {
        this.shareUtils = shareUtils;
    }

    public void setCommentUtils(CommentUtilsProxy commentUtils) {
        this.commentUtils = commentUtils;
    }

    public void stopTicker() {
        if (this.ticker != null) {
            this.ticker.stopTicker();
        }
    }

    public void startTicker() {
        if (this.ticker != null) {
            this.ticker.startTicker();
        }
    }

    public void setOnActionBarEventListener(OnActionBarEventListener onActionBarEventListener) {
        this.onActionBarEventListener = onActionBarEventListener;
    }

    public OnActionBarEventListener getOnActionBarEventListener() {
        return this.onActionBarEventListener;
    }

    public OnCommentViewActionListener getOnCommentViewActionListener() {
        return this.onCommentViewActionListener;
    }

    public void setOnCommentViewActionListener(OnCommentViewActionListener onCommentViewActionListener) {
        this.onCommentViewActionListener = onCommentViewActionListener;
    }

    public void setLocalizationService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }
}

