/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.actionbar;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.PaintDrawable;
import com.socialize.ui.actionbar.ActionBarOptions;

public class ActionBarButtonBackground
extends LayerDrawable {
    public static final int DEFAULT_ACCENT_COLOR = Color.parseColor((String)"#03a6dc");
    public static final int DEFAULT_STROKE_COLOR = Color.parseColor((String)"#222222");
    public static final int DEFAULT_HIGHLIGHT_COLOR = Color.parseColor((String)"#666666");
    public static final int DEFAULT_FILL_COLOR = Color.parseColor((String)"#454545");

    public ActionBarButtonBackground(int accentHeight, int strokeWidth) {
        this(accentHeight, strokeWidth, DEFAULT_STROKE_COLOR, DEFAULT_ACCENT_COLOR, DEFAULT_FILL_COLOR, DEFAULT_HIGHLIGHT_COLOR, ActionBarOptions.ColorLayout.BOTTOM);
    }

    public ActionBarButtonBackground(int accentHeight, int strokeWidth, Integer strokeColor, Integer accentColor, Integer fillColor, Integer highlightColor, ActionBarOptions.ColorLayout colorLayout) {
        super(new Drawable[]{new PaintDrawable(strokeColor == null ? DEFAULT_STROKE_COLOR : strokeColor), new PaintDrawable(accentColor == null ? DEFAULT_ACCENT_COLOR : accentColor), new PaintDrawable(highlightColor == null ? DEFAULT_HIGHLIGHT_COLOR : highlightColor), new PaintDrawable(fillColor == null ? DEFAULT_FILL_COLOR : fillColor)});
        if (colorLayout.equals((Object)ActionBarOptions.ColorLayout.TOP)) {
            this.setLayerInset(1, strokeWidth, strokeWidth, 0, 0);
            this.setLayerInset(2, strokeWidth, accentHeight + strokeWidth, 0, 0);
            this.setLayerInset(3, strokeWidth, accentHeight + strokeWidth, 0, strokeWidth);
        } else {
            this.setLayerInset(1, strokeWidth, 0, 0, strokeWidth);
            this.setLayerInset(2, strokeWidth, 0, 0, accentHeight + strokeWidth);
            this.setLayerInset(3, strokeWidth, strokeWidth, 0, accentHeight + strokeWidth);
        }
    }

    public ActionBarButtonBackground(Drawable[] layers) {
        super(layers);
    }
}

