/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui.action;

import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.location.Address;
import android.net.Uri;
import android.text.InputFilter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.entity.SocializeAction;
import com.socialize.entity.User;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.profile.activity.UserActivityListItem;
import com.socialize.ui.profile.activity.UserActivityView;
import com.socialize.ui.util.Colors;
import com.socialize.ui.util.CompatUtils;
import com.socialize.ui.util.DateUtils;
import com.socialize.ui.util.GeoUtils;
import com.socialize.util.DisplayUtils;
import com.socialize.util.Drawables;
import com.socialize.view.BaseView;
import java.util.Date;

public class ActionDetailContentView
extends BaseView {
    private ImageView profilePicture;
    private TextView displayName;
    private UserActivityListItem actionView;
    private TextView actionLocation;
    private GeoUtils geoUtils;
    private DateUtils dateUtils;
    private DisplayUtils displayUtils;
    private Colors colors;
    private Drawables drawables;
    private LinearLayout actionLocationLine;
    private TextView divider;
    private IBeanFactory<UserActivityListItem> userActivityListItemFactory;
    private LinearLayout headerView;
    private SocializeLogger logger;
    private IBeanFactory<UserActivityView> userActivityViewFactory;
    private UserActivityView userActivityView;

    public ActionDetailContentView(Context context) {
        super(context);
    }

    public void init() {
        int imagePadding = this.displayUtils.getDIP(4);
        int margin = this.displayUtils.getDIP(8);
        int actionMargin = this.displayUtils.getDIP(4);
        int imageSize = this.displayUtils.getDIP(64);
        int editTextStroke = this.displayUtils.getDIP(2);
        float editTextRadius = editTextStroke;
        int titleColor = this.colors.getColor("TITLE");
        LinearLayout.LayoutParams masterLayout = new LinearLayout.LayoutParams(-1, -1);
        this.setLayoutParams((ViewGroup.LayoutParams)masterLayout);
        this.setOrientation(1);
        this.setPadding(0, 0, 0, 0);
        this.setGravity(48);
        this.headerView = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams masterLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.headerView.setLayoutParams((ViewGroup.LayoutParams)masterLayoutParams);
        this.headerView.setOrientation(0);
        this.headerView.setGravity(48);
        LinearLayout nameLayout = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams nameLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        nameLayout.setLayoutParams((ViewGroup.LayoutParams)nameLayoutParams);
        nameLayout.setOrientation(1);
        nameLayout.setGravity(48);
        LinearLayout.LayoutParams imageLayout = new LinearLayout.LayoutParams(imageSize, imageSize);
        LinearLayout.LayoutParams displayNameTextLayoutParams = new LinearLayout.LayoutParams(-1, -2);
        LinearLayout.LayoutParams actionLocationLineLayout = new LinearLayout.LayoutParams(-1, -2);
        LinearLayout.LayoutParams actionLocationLayout = new LinearLayout.LayoutParams(-2, -2);
        LinearLayout.LayoutParams actionLocationPinLayout = new LinearLayout.LayoutParams(-2, -2);
        masterLayout.setMargins(0, 0, 0, 0);
        imageLayout.setMargins(margin, margin, margin, margin);
        displayNameTextLayoutParams.setMargins(0, margin, margin, margin);
        displayNameTextLayoutParams.weight = 1.0f;
        actionLocationLayout.gravity = 3;
        actionLocationPinLayout.gravity = 16;
        this.profilePicture = new ImageView(this.getContext());
        this.displayName = new TextView(this.getContext());
        this.actionView = (UserActivityListItem)((Object)this.userActivityListItemFactory.getBean());
        this.actionLocation = new TextView(this.getContext());
        ImageView locationPin = new ImageView(this.getContext());
        locationPin.setImageDrawable(this.drawables.getDrawable("icon_location_pin.png"));
        this.actionLocationLine = new LinearLayout(this.getContext());
        this.actionLocationLine.addView((View)locationPin);
        this.actionLocationLine.addView((View)this.actionLocation);
        this.actionLocationLine.setLayoutParams((ViewGroup.LayoutParams)actionLocationLineLayout);
        this.actionLocation.setLayoutParams((ViewGroup.LayoutParams)actionLocationLayout);
        locationPin.setLayoutParams((ViewGroup.LayoutParams)actionLocationPinLayout);
        this.actionLocation.setTextSize(1, 12.0f);
        this.actionLocation.setTextColor(-1);
        ColorDrawable actionbg = new ColorDrawable(-1);
        actionbg.setAlpha(32);
        this.actionView.setBackground((Drawable)actionbg);
        this.actionView.setVisibility(8);
        this.actionLocationLine.setVisibility(4);
        LinearLayout.LayoutParams actionWebViewLayout = new LinearLayout.LayoutParams(-1, -2);
        actionWebViewLayout.setMargins(margin, actionMargin, margin, actionMargin);
        this.actionView.setLayoutParams((ViewGroup.LayoutParams)actionWebViewLayout);
        GradientDrawable imageBG = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{-1, -1});
        imageBG.setStroke(2, -16777216);
        imageBG.setAlpha(64);
        this.profilePicture.setLayoutParams((ViewGroup.LayoutParams)imageLayout);
        this.profilePicture.setPadding(imagePadding, imagePadding, imagePadding, imagePadding);
        CompatUtils.setBackgroundDrawable((View)this.profilePicture, (Drawable)imageBG);
        this.profilePicture.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.displayName.setTextColor(titleColor);
        this.displayName.setTextSize(1, 24.0f);
        this.displayName.setMaxLines(1);
        this.displayName.setTypeface(Typeface.DEFAULT);
        this.displayName.setSingleLine();
        this.displayName.setLayoutParams((ViewGroup.LayoutParams)displayNameTextLayoutParams);
        GradientDrawable textBG = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{this.colors.getColor("TEXT_BG"), this.colors.getColor("TEXT_BG")});
        textBG.setStroke(editTextStroke, this.colors.getColor("TEXT_STROKE"));
        textBG.setCornerRadius(editTextRadius);
        InputFilter[] maxLength = new InputFilter[]{new InputFilter.LengthFilter(128)};
        nameLayout.addView((View)this.displayName);
        nameLayout.addView((View)this.actionLocationLine);
        this.headerView.addView((View)this.profilePicture);
        this.headerView.addView((View)nameLayout);
        this.addView((View)this.headerView);
        this.addView((View)this.actionView);
        if (this.userActivityViewFactory != null) {
            this.divider = new TextView(this.getContext());
            CompatUtils.setBackgroundDrawable((View)this.divider, this.drawables.getDrawable("divider.png", true, false, true));
            LinearLayout.LayoutParams dividerLayout = new LinearLayout.LayoutParams(-1, this.displayUtils.getDIP(30));
            dividerLayout.gravity = 19;
            dividerLayout.setMargins(0, margin, 0, 0);
            this.divider.setLayoutParams((ViewGroup.LayoutParams)dividerLayout);
            this.divider.setTextColor(-1);
            this.divider.setText((CharSequence)"Recent Activity");
            this.divider.setPadding(margin, 0, 0, 0);
            this.divider.setTextSize(1, 12.0f);
            this.divider.setTypeface(Typeface.DEFAULT_BOLD);
            this.divider.setGravity(19);
            this.addView((View)this.divider);
            LinearLayout activityHolder = new LinearLayout(this.getContext());
            LinearLayout.LayoutParams userActivityLayout = new LinearLayout.LayoutParams(-1, -1);
            LinearLayout.LayoutParams activityHolderLayout = new LinearLayout.LayoutParams(-1, -1);
            activityHolderLayout.setMargins(0, 0, 0, 0);
            userActivityLayout.setMargins(0, 0, 0, 0);
            activityHolder.setLayoutParams((ViewGroup.LayoutParams)activityHolderLayout);
            activityHolder.setPadding(margin, margin, margin, margin);
            int activityBg = this.colors.getColor("ACTIVITY_BG");
            GradientDrawable bg = this.makeGradient(activityBg, activityBg);
            bg.setAlpha(144);
            CompatUtils.setBackgroundDrawable((View)activityHolder, (Drawable)bg);
            activityHolderLayout.weight = 1.0f;
            this.userActivityView = (UserActivityView)this.userActivityViewFactory.getBean();
            this.userActivityView.setLayoutParams((ViewGroup.LayoutParams)userActivityLayout);
            activityHolder.addView((View)this.userActivityView);
            this.addView((View)activityHolder);
        }
    }

    public ImageView getProfilePicture() {
        return this.profilePicture;
    }

    public TextView getDisplayName() {
        return this.displayName;
    }

    public void setGeoUtils(GeoUtils geoUtils) {
        this.geoUtils = geoUtils;
    }

    public DateUtils getDateUtils() {
        return this.dateUtils;
    }

    public void setDateUtils(DateUtils dateUtils) {
        this.dateUtils = dateUtils;
    }

    public void setDisplayUtils(DisplayUtils deviceUtils) {
        this.displayUtils = deviceUtils;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setUserActivityListItemFactory(IBeanFactory<UserActivityListItem> userActivityListItemFactory) {
        this.userActivityListItemFactory = userActivityListItemFactory;
    }

    public void setUserActivityViewFactory(IBeanFactory<UserActivityView> userActivityViewFactory) {
        this.userActivityViewFactory = userActivityViewFactory;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void loadUserActivity(User user, SocializeAction current) {
        if (this.userActivityView != null) {
            this.userActivityView.loadUserActivity(user.getId(), current);
        }
    }

    protected GradientDrawable makeGradient(int bottom, int top) {
        return new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{bottom, top});
    }

    public UserActivityView getUserActivityView() {
        return this.userActivityView;
    }

    public void setAction(final SocializeAction action) {
        Address address;
        User user;
        if (this.actionView != null) {
            this.actionView.setAction((Context)this.getActivity(), action, new Date());
            this.actionView.setVisibility(0);
        }
        if ((user = action.getUser()) != null) {
            this.divider.setText((CharSequence)("Recent Activity for " + user.getDisplayName()));
        }
        if (this.actionLocation != null && action.isLocationShared() && action.getLat() != null && action.getLon() != null && (address = this.geoUtils.geoCode(action.getLat(), action.getLon())) != null) {
            this.actionLocationLine.setVisibility(0);
            this.actionLocation.setText((CharSequence)this.geoUtils.getSimpleLocation(address));
            this.actionLocation.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        String uri = "http://maps.google.com/?q=" + action.getLat() + "," + action.getLon() + "&z=17";
                        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
                        ActionDetailContentView.this.getActivity().startActivity(intent);
                    }
                    catch (Exception e) {
                        if (ActionDetailContentView.this.logger != null) {
                            ActionDetailContentView.this.logger.warn("Failed to load map view", (Throwable)e);
                        }
                        SocializeLogger.w("Failed to load map view", e);
                    }
                }
            });
        }
    }
}

