/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.api.SocializeSession;
import com.socialize.api.event.EventSystem;
import com.socialize.concurrent.ManagedAsyncTask;
import com.socialize.error.SocializeErrorHandler;
import com.socialize.error.SocializeException;
import com.socialize.launcher.AsyncLauncher;
import com.socialize.launcher.LaunchListener;
import com.socialize.launcher.LaunchManager;
import com.socialize.launcher.LaunchTask;
import com.socialize.launcher.Launcher;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.log.SocializeLogger;
import com.socialize.ui.ActivityIOCProvider;
import com.socialize.util.StringUtils;

public class SocializeLaunchActivity
extends Activity {
    public static final String LAUNCH_ACTION = "socialize.launch.action";
    public static final String LAUNCH_TASK = "socialize.launch.task";
    protected IOCContainer container;
    protected Launcher launcher;
    protected SocializeLogger logger;
    protected SocializeErrorHandler errorHandler;
    protected Intent originalIntent;
    protected EventSystem eventSystem;

    protected void onNewIntent(Intent intent) {
        this.originalIntent = intent;
        super.onNewIntent(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.superOnCreate(savedInstanceState);
        this.originalIntent = this.getIntent();
        this.setupLayout();
        new Initializer().execute(new Void[0]);
    }

    protected void setupLayout() {
        RelativeLayout layout = new RelativeLayout((Context)this);
        layout.setBackgroundColor(-16777216);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        TextView text = new TextView((Context)this);
        text.setText((CharSequence)"Loading...");
        text.setTextColor(-1);
        RelativeLayout.LayoutParams text_params = new RelativeLayout.LayoutParams(-2, -2);
        text_params.addRule(13);
        text.setLayoutParams((ViewGroup.LayoutParams)text_params);
        layout.addView((View)text);
        layout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setContentView((View)layout);
    }

    protected void doInit() {
        this.initSocialize();
        this.container = this.getContainer();
        this.logger = (SocializeLogger)this.container.getBean("logger");
        this.errorHandler = (SocializeErrorHandler)this.container.getBean("socializeUIErrorHandler");
        this.eventSystem = (EventSystem)this.container.getBean("eventSystem");
    }

    protected void doAuthenticate() {
        this.getSocialize().authenticate((Context)this, this.getAuthListener(this.container));
    }

    protected SocializeAuthListener getAuthListener(final IOCContainer container) {
        return new SocializeAuthListener(){

            @Override
            public void onError(SocializeException error) {
                SocializeLaunchActivity.this.handleError(error);
            }

            @Override
            public void onAuthFail(SocializeException error) {
                SocializeLaunchActivity.this.handleError(error);
            }

            @Override
            public void onCancel() {
                SocializeLaunchActivity.this.finish();
            }

            @Override
            public void onAuthSuccess(SocializeSession session) {
                Bundle extras = SocializeLaunchActivity.this.getIntent().getExtras();
                if (extras != null) {
                    String action;
                    block20: {
                        action = extras.getString(SocializeLaunchActivity.LAUNCH_ACTION);
                        String task = extras.getString(SocializeLaunchActivity.LAUNCH_TASK);
                        if (!StringUtils.isEmpty(task)) {
                            LaunchTask launchTask;
                            if (SocializeLaunchActivity.this.logger != null && SocializeLaunchActivity.this.logger.isDebugEnabled()) {
                                SocializeLaunchActivity.this.logger.debug("Looking for launch task [" + task + "]");
                            }
                            if ((launchTask = (LaunchTask)container.getBean(task)) != null) {
                                try {
                                    if (SocializeLaunchActivity.this.logger != null && SocializeLaunchActivity.this.logger.isDebugEnabled()) {
                                        SocializeLaunchActivity.this.logger.debug("Executing launch task [" + launchTask.getClass() + "]");
                                    }
                                    launchTask.execute((Context)SocializeLaunchActivity.this, extras);
                                }
                                catch (Throwable e) {
                                    if (SocializeLaunchActivity.this.logger != null) {
                                        SocializeLaunchActivity.this.logger.warn("Failed to execute launch task [" + launchTask.getClass().getName() + "]", e);
                                        break block20;
                                    }
                                    SocializeLogger.e(e.getMessage(), e);
                                }
                            } else if (SocializeLaunchActivity.this.logger != null) {
                                SocializeLaunchActivity.this.logger.error("Launch task [" + launchTask + "] specified by no corresponding bean found in the container.");
                            }
                        }
                    }
                    if (!StringUtils.isEmpty(action)) {
                        LaunchManager launchManager = (LaunchManager)container.getBean("launchManager");
                        if (launchManager != null) {
                            SocializeLaunchActivity.this.launcher = launchManager.getLaucher(action);
                            if (SocializeLaunchActivity.this.launcher != null) {
                                if (SocializeLaunchActivity.this.launcher.isAsync()) {
                                    new AsyncLauncher(SocializeLaunchActivity.this, SocializeLaunchActivity.this.launcher, extras, new LaunchListener(){

                                        @Override
                                        public void onError(Exception error) {
                                            SocializeLaunchActivity.this.handleError(error);
                                        }

                                        @Override
                                        public void onAfterLaunch(boolean launched) {
                                            if (!launched || SocializeLaunchActivity.this.launcher.shouldFinish(SocializeLaunchActivity.this)) {
                                                SocializeLaunchActivity.this.finish();
                                            }
                                        }
                                    }).execute(new Void[0]);
                                } else {
                                    boolean launched = SocializeLaunchActivity.this.launcher.launch(SocializeLaunchActivity.this, extras);
                                    if (!launched || SocializeLaunchActivity.this.launcher.shouldFinish(SocializeLaunchActivity.this)) {
                                        SocializeLaunchActivity.this.finish();
                                    }
                                }
                            } else {
                                SocializeLaunchActivity.this.finish();
                            }
                        } else {
                            SocializeLaunchActivity.this.finish();
                        }
                    } else {
                        SocializeLaunchActivity.this.finish();
                    }
                } else {
                    SocializeLaunchActivity.this.finish();
                }
            }
        };
    }

    protected void handleError(Exception error) {
        SocializeLogger.e(error.getMessage(), error);
        if (this.errorHandler != null) {
            this.errorHandler.handleError((Context)this, error);
        }
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.launcher != null) {
            this.launcher.onResult(this, requestCode, resultCode, data, this.originalIntent);
        }
        this.finish();
    }

    protected void superOnCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    protected IOCContainer getContainer() {
        return ActivityIOCProvider.getInstance().getContainer();
    }

    protected void initSocialize() {
        this.getSocialize().init((Context)this);
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    protected class Initializer
    extends ManagedAsyncTask<Void, Void, Void> {
        protected Initializer() {
        }

        protected Void doInBackground(Void ... arg0) {
            SocializeLaunchActivity.this.doInit();
            return null;
        }

        @Override
        protected void onPostExecuteManaged(Void result) {
            SocializeLaunchActivity.this.doAuthenticate();
        }
    }
}

