/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.ui;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import com.socialize.Socialize;
import com.socialize.SocializeSystem;
import com.socialize.UserUtils;
import com.socialize.android.ioc.IOCContainer;
import com.socialize.error.SocializeException;
import com.socialize.i18n.LocalizationService;
import com.socialize.listener.SocializeInitListener;
import com.socialize.log.SocializeLogger;
import com.socialize.util.Drawables;
import com.socialize.view.BaseView;

public abstract class SocializeBaseView
extends BaseView {
    protected IOCContainer container;
    protected Drawables drawables;
    protected LocalizationService localizationService;
    protected Menu menu;
    protected boolean viewLoaded = false;

    public SocializeBaseView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SocializeBaseView(Context context) {
        super(context);
    }

    @Override
    public void onViewLoad() {
        super.onViewLoad();
        View loading = this.getLoadingView();
        if (loading != null) {
            this.addView(loading);
        }
        this.doSocializeInit(this.getContext(), this.getInitLoadListener());
    }

    @Override
    public void onViewUpdate() {
        super.onViewUpdate();
        this.doSocializeInit(this.getContext(), this.getInitUpdateListener());
    }

    protected SocializeInitListener getInitLoadListener() {
        return new SocializeInitListener(){

            @Override
            public void onError(SocializeException error) {
                SocializeLogger.e("Error initializing Socialize", error);
                SocializeBaseView.this.onViewError(error);
            }

            @Override
            public void onInit(Context context, IOCContainer c) {
                SocializeBaseView.this.container = c;
                SocializeBaseView.this.drawables = (Drawables)c.getBean("drawables");
                SocializeBaseView.this.localizationService = (LocalizationService)c.getBean("localizationService");
                SocializeBaseView.this.onViewLoad(SocializeBaseView.this.container);
            }
        };
    }

    protected SocializeInitListener getInitUpdateListener() {
        return new SocializeInitListener(){

            @Override
            public void onError(SocializeException error) {
                SocializeLogger.e("Error initializing Socialize", error);
            }

            @Override
            public void onInit(Context context, IOCContainer c) {
                SocializeBaseView.this.container = c;
                SocializeBaseView.this.drawables = (Drawables)c.getBean("drawables");
                SocializeBaseView.this.localizationService = (LocalizationService)c.getBean("localizationService");
                SocializeBaseView.this.onViewUpdate(SocializeBaseView.this.container);
            }
        };
    }

    public void onViewLoad(IOCContainer container) {
        if (this.menu != null) {
            this.createOptionsMenuItem(this.getActivity(), this.menu);
        }
        this.viewLoaded = true;
    }

    public void onViewUpdate(IOCContainer container) {
    }

    protected void doSocializeInit(Context context, SocializeInitListener listener) {
        if (!this.isInEditMode()) {
            this.onBeforeSocializeInit();
            this.initSocialize(context, listener);
        }
    }

    protected <E> E getBean(String name) {
        return (E)this.container.getBean(name);
    }

    public void setContainer(IOCContainer container) {
        this.container = container;
    }

    protected void initSocialize(Context context, final SocializeInitListener listener) {
        SocializeSystem system = this.getSocialize().getSystem();
        String[] config = system.getBeanConfig(context);
        final SocializeInitListener systemListener = system.getSystemInitListener();
        if (systemListener != null) {
            SocializeInitListener overrideListener = new SocializeInitListener(){

                @Override
                public void onError(SocializeException error) {
                    systemListener.onError(error);
                    listener.onError(error);
                }

                @Override
                public void onInit(Context context, IOCContainer container) {
                    systemListener.onInit(context, container);
                    listener.onInit(context, container);
                }
            };
            this.getSocialize().initAsync(this.getContext(), overrideListener, config);
        } else {
            this.getSocialize().initAsync(this.getContext(), listener, config);
        }
    }

    public abstract View getLoadingView();

    public View getLoadFailView() {
        return null;
    }

    protected void createOptionsMenuItem(final Activity source, Menu menu) {
        if (Socialize.getSocialize().isAuthenticated()) {
            MenuItem add = menu.add((CharSequence)this.localizationService.getString("socialize_settings_header"));
            if (this.drawables != null) {
                add.setIcon(this.drawables.getDrawable("ic_menu_preferences.png"));
            }
            add.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    if (!SocializeBaseView.this.onSettingsMenuItemClick(item)) {
                        UserUtils.showUserSettingsForResult(source, 1347);
                    }
                    return true;
                }
            });
        }
    }

    protected boolean onSettingsMenuItemClick(MenuItem item) {
        return false;
    }

    public final boolean onCreateOptionsMenu(Activity source, Menu menu) {
        this.menu = menu;
        if (this.viewLoaded) {
            this.createOptionsMenuItem(source, menu);
        }
        return true;
    }

    protected void onBeforeSocializeInit() {
    }
}

