/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.share;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Telephony;
import com.socialize.api.ShareMessageBuilder;
import com.socialize.api.action.ShareType;
import com.socialize.entity.Entity;
import com.socialize.entity.PropagationInfo;
import com.socialize.entity.SocializeAction;
import com.socialize.networks.DefaultPostData;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.share.IntentShareHandler;
import java.util.HashMap;

public class SmsShareHandler
extends IntentShareHandler {
    private ShareMessageBuilder shareMessageBuilder;

    @Override
    protected void handle(Activity context, SocializeAction action, String text, PropagationInfo info, SocialNetworkListener listener) throws Exception {
        boolean shareCancelled = false;
        Entity entity = action.getEntity();
        HashMap<String, Object> postValues = new HashMap<String, Object>();
        postValues.put("text", this.shareMessageBuilder.buildShareMessage(action.getEntity(), info, text, false, true));
        DefaultPostData postData = new DefaultPostData();
        postData.setEntity(entity);
        postData.setPropagationInfo(info);
        postData.setPostValues(postValues);
        if (listener != null) {
            shareCancelled = listener.onBeforePost(context, null, postData);
        }
        if (!shareCancelled) {
            String body = String.valueOf(postValues.get("text"));
            Intent sendIntent = this.getIntent((Context)context);
            if (Build.VERSION.SDK_INT >= 19) {
                sendIntent.putExtra("android.intent.extra.TEXT", body);
            } else {
                sendIntent.putExtra("sms_body", body);
            }
            context.startActivity(sendIntent);
        }
        if (listener != null) {
            listener.onAfterPost(context, null, null);
        }
    }

    @Override
    protected Intent getIntent(Context context) {
        Intent sendIntent;
        if (Build.VERSION.SDK_INT >= 19) {
            String defaultSmsPackageName = Telephony.Sms.getDefaultSmsPackage((Context)context);
            sendIntent = new Intent("android.intent.action.SEND");
            if (defaultSmsPackageName != null) {
                sendIntent.setPackage(defaultSmsPackageName);
            }
        } else {
            sendIntent = new Intent("android.intent.action.VIEW");
        }
        sendIntent.setType(this.getMimeType());
        return sendIntent;
    }

    @Override
    protected String getMimeType() {
        if (Build.VERSION.SDK_INT >= 19) {
            return "text/plain";
        }
        return "vnd.android-dir/mms-sms";
    }

    @Override
    protected ShareType getShareType() {
        return ShareType.SMS;
    }

    public void setShareMessageBuilder(ShareMessageBuilder shareMessageBuilder) {
        this.shareMessageBuilder = shareMessageBuilder;
    }
}

