/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.provider;

import android.content.Context;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.SessionLock;
import com.socialize.api.SocializeRequestFactory;
import com.socialize.api.SocializeSession;
import com.socialize.api.SocializeSessionFactory;
import com.socialize.api.SocializeSessionPersister;
import com.socialize.api.WritableSession;
import com.socialize.api.action.ActionType;
import com.socialize.auth.AuthProviderData;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderInfoBuilder;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.DefaultUserProviderCredentials;
import com.socialize.auth.UserProviderCredentials;
import com.socialize.auth.UserProviderCredentialsMap;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.ActionError;
import com.socialize.entity.ErrorFactory;
import com.socialize.entity.ListResult;
import com.socialize.entity.SocializeObject;
import com.socialize.entity.SocializeObjectFactory;
import com.socialize.entity.User;
import com.socialize.entity.UserAuthData;
import com.socialize.error.SocializeApiError;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.net.HttpClientFactory;
import com.socialize.provider.SocializeProvider;
import com.socialize.util.HttpUtils;
import com.socialize.util.IOUtils;
import com.socialize.util.JSONParser;
import com.socialize.util.StringUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseSocializeProvider<T extends SocializeObject>
implements SocializeProvider<T> {
    public static final String JSON_ATTR_ERRORS = "errors";
    public static final String JSON_ATTR_ITEMS = "items";
    public static final String JSON_ATTR_COUNT = "total_count";
    private SocializeObjectFactory<User> userFactory;
    private IBeanFactory<AuthProviderData> authProviderDataFactory;
    private AuthProviderInfoBuilder authProviderInfoBuilder;
    private ErrorFactory errorFactory;
    private HttpClientFactory clientFactory;
    private SocializeSessionFactory sessionFactory;
    private SocializeRequestFactory<T> requestFactory;
    private JSONParser jsonParser;
    private SocializeLogger logger;
    private HttpUtils httpUtils;
    private IOUtils ioUtils;
    private SocializeSessionPersister sessionPersister;
    private SocializeConfig config;
    private WeakReference<Context> context;

    @Override
    public void init(Context context) {
        this.context = new WeakReference<Context>(context);
    }

    public void setUserFactory(SocializeObjectFactory<User> userFactory) {
        this.userFactory = userFactory;
    }

    public void setClientFactory(HttpClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public void setRequestFactory(SocializeRequestFactory<T> requestFactory) {
        this.requestFactory = requestFactory;
    }

    public void setJsonParser(JSONParser jsonParser) {
        this.jsonParser = jsonParser;
    }

    public void setHttpUtils(HttpUtils httpUtils) {
        this.httpUtils = httpUtils;
    }

    public void setIoUtils(IOUtils ioUtils) {
        this.ioUtils = ioUtils;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setErrorFactory(ErrorFactory errorFactory) {
        this.errorFactory = errorFactory;
    }

    public void setSessionFactory(SocializeSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public SocializeSession authenticate(String endpoint, String key, String secret, String uuid, String advertiserId) throws SocializeException {
        if (this.authProviderDataFactory == null) {
            throw new SocializeException("Socialize not initialized");
        }
        AuthProviderData data = (AuthProviderData)this.authProviderDataFactory.getBean();
        if (data == null) {
            throw new SocializeException("Socialize not initialized");
        }
        data.setAuthProviderInfo((AuthProviderInfo)this.authProviderInfoBuilder.getFactory(AuthProviderType.SOCIALIZE).getInstanceForRead(new String[0]));
        return this.authenticate(endpoint, key, secret, data, uuid, advertiserId);
    }

    @Override
    public WritableSession loadSession(String endpoint, String key, String secret) throws SocializeException {
        WritableSession loaded;
        if (this.sessionPersister != null && (loaded = this.sessionPersister.load((Context)this.context.get())) != null) {
            String loadedKey = loaded.getConsumerKey();
            String loadedSecret = loaded.getConsumerSecret();
            String loadedHost = loaded.getHost();
            String host = this.config.getProperty("api.host");
            if (loadedKey != null && loadedKey.equals(key) && loadedSecret != null && loadedSecret.equals(secret) && loadedHost != null && loadedHost.equals(host)) {
                return loaded;
            }
        }
        return null;
    }

    @Override
    public boolean validateSession(SocializeSession session, AuthProviderData data) {
        AuthProviderInfo info = data.getAuthProviderInfo();
        if (info != null) {
            if (info.getType().equals((Object)AuthProviderType.SOCIALIZE)) {
                return true;
            }
            return this.validateSessionAuthData(session, data, info);
        }
        return false;
    }

    public boolean validateSessionAuthData(SocializeSession loaded, AuthProviderData data, AuthProviderInfo info) {
        UserProviderCredentials userProviderCredentials;
        UserProviderCredentialsMap userProviderCredentialsMap = loaded.getUserProviderCredentials();
        if (userProviderCredentialsMap != null && (userProviderCredentials = userProviderCredentialsMap.get(info.getType())) != null && userProviderCredentials.getAuthProviderInfo().matches(info)) {
            boolean ok = true;
            String token3rdParty = data.getToken3rdParty();
            String secret3rdParty = data.getSecret3rdParty();
            if (!StringUtils.isEmpty(token3rdParty)) {
                ok = userProviderCredentials.getAccessToken().equals(token3rdParty);
            }
            if (ok && !StringUtils.isEmpty(secret3rdParty)) {
                ok = userProviderCredentials.getTokenSecret().equals(secret3rdParty);
            }
            return ok;
        }
        return false;
    }

    protected AuthProviderData newAuthProviderData() {
        return new AuthProviderData();
    }

    @Override
    public void clearSession(AuthProviderType type) {
        if (this.sessionPersister != null) {
            this.sessionPersister.delete((Context)this.context.get(), type);
        }
    }

    @Override
    public void clearSession() {
        if (this.sessionPersister != null) {
            this.sessionPersister.delete((Context)this.context.get());
        }
    }

    public void saveSession(SocializeSession session) {
        if (this.sessionPersister != null) {
            this.sessionPersister.save((Context)this.context.get(), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocializeSession authenticate(String endpoint, String key, String secret, AuthProviderData data, String uuid, String advertiserId) throws SocializeException {
        try {
            SessionLock.lock();
            WritableSession session = this.loadSession(endpoint, key, secret);
            if (session != null) {
                if (this.validateSession(session, data)) {
                    WritableSession writableSession = session;
                    return writableSession;
                }
                session = this.setProviderCredentialsForUser(data, session);
            }
            if (session == null) {
                session = this.sessionFactory.create(key, secret, data);
            }
            endpoint = this.prepareEndpoint(session, endpoint, true);
            if (!this.clientFactory.isDestroyed()) {
                HttpClient client = this.clientFactory.getClient();
                HttpEntity entity = null;
                try {
                    HttpUriRequest request = this.requestFactory.getAuthRequest(session, endpoint, uuid, advertiserId, data);
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("Calling authenticate endpoint for device [" + uuid + "]");
                    }
                    HttpResponse response = this.executeRequest(client, request);
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("RESPONSE CODE: " + response.getStatusLine().getStatusCode());
                    }
                    entity = response.getEntity();
                    if (this.httpUtils.isHttpError(response)) {
                        if (this.sessionPersister != null && this.httpUtils.isAuthError(response)) {
                            this.sessionPersister.delete((Context)this.context.get());
                        }
                        String msg = this.ioUtils.readSafe(entity.getContent());
                        throw new SocializeApiError(this.httpUtils, response.getStatusLine().getStatusCode(), msg);
                    }
                    String responseData = this.ioUtils.readSafe(entity.getContent());
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("RESPONSE: " + responseData);
                    }
                    JSONObject json = this.jsonParser.parseObject(responseData);
                    User user = (User)this.userFactory.fromJSON(json.getJSONObject("user"));
                    String oauth_token = json.getString("oauth_token");
                    String oauth_token_secret = json.getString("oauth_token_secret");
                    if (StringUtils.isEmpty(oauth_token)) {
                        throw new SocializeException("oauth_token was empty in response from server");
                    }
                    if (StringUtils.isEmpty(oauth_token_secret)) {
                        throw new SocializeException("oauth_token_secret was empty in response from server");
                    }
                    session.setConsumerToken(oauth_token);
                    session.setConsumerTokenSecret(oauth_token_secret);
                    session.setUser(user);
                    this.setProviderCredentialsForUser(data, session);
                    this.verifyProviderCredentialsForUser(session, user);
                    this.saveSession(session);
                    this.closeEntity(entity);
                }
                catch (Exception e) {
                    try {
                        throw SocializeException.wrap(e);
                    }
                    catch (Throwable throwable) {
                        this.closeEntity(entity);
                        throw throwable;
                    }
                }
            } else if (this.logger != null) {
                this.logger.warn("Attempt to access HttpClientFactory that was already destroyed");
            }
            WritableSession writableSession = session;
            return writableSession;
        }
        finally {
            SessionLock.unlock();
        }
    }

    protected WritableSession setProviderCredentialsForUser(AuthProviderData data, WritableSession session) {
        AuthProviderInfo info = data.getAuthProviderInfo();
        if (info != null) {
            DefaultUserProviderCredentials userProviderCredentials = new DefaultUserProviderCredentials();
            userProviderCredentials.setAccessToken(data.getToken3rdParty());
            userProviderCredentials.setTokenSecret(data.getSecret3rdParty());
            userProviderCredentials.setUserId(data.getUserId3rdParty());
            UserProviderCredentials current = session.getUserProviderCredentials().get(info.getType());
            if (current != null) {
                AuthProviderInfo authProviderInfo = current.getAuthProviderInfo();
                if (authProviderInfo != null) {
                    authProviderInfo.merge(data.getAuthProviderInfo());
                }
                userProviderCredentials.setAuthProviderInfo(authProviderInfo);
            } else {
                userProviderCredentials.setAuthProviderInfo(data.getAuthProviderInfo());
            }
            session.getUserProviderCredentials().put(info.getType(), userProviderCredentials);
        } else {
            session = null;
        }
        return session;
    }

    protected void verifyProviderCredentialsForUser(WritableSession session, User user) {
        List<UserAuthData> authData = user.getAuthData();
        UserProviderCredentialsMap credentials = session.getUserProviderCredentials();
        if (credentials != null) {
            if (authData != null) {
                LinkedHashMap<AuthProviderType, UserProviderCredentials> validCreds = new LinkedHashMap<AuthProviderType, UserProviderCredentials>();
                for (UserAuthData userAuthData : authData) {
                    UserProviderCredentials creds = credentials.get(userAuthData.getAuthProviderType());
                    if (creds == null) continue;
                    validCreds.put(userAuthData.getAuthProviderType(), creds);
                }
                credentials.removeAll();
                Set entrySet = validCreds.entrySet();
                for (Map.Entry entry : entrySet) {
                    credentials.put((AuthProviderType)((Object)entry.getKey()), (UserProviderCredentials)entry.getValue());
                }
            } else {
                credentials.removeAll();
            }
            session.setUserProviderCredentials(credentials);
        }
    }

    @Override
    public T get(SocializeSession session, String endpoint, String id, ActionType type) throws SocializeException {
        endpoint = this.prepareEndpoint(session, endpoint);
        HttpUriRequest get = this.requestFactory.getGetRequest(session, endpoint, id);
        return this.doGetTypeRequest(get, type);
    }

    @Override
    public T get(SocializeSession session, String endpoint, String id) throws SocializeException {
        return (T)this.get(session, endpoint, id, ActionType.UNKNOWN);
    }

    @Override
    public void delete(SocializeSession session, String endpoint, String id) throws SocializeException {
        HttpEntity entity = null;
        if (!this.clientFactory.isDestroyed()) {
            try {
                endpoint = this.prepareEndpoint(session, endpoint);
                HttpClient client = this.clientFactory.getClient();
                HttpUriRequest del = this.requestFactory.getDeleteRequest(session, endpoint, id);
                HttpResponse response = client.execute(del);
                entity = response.getEntity();
                if (this.httpUtils.isHttpError(response)) {
                    if (this.sessionPersister != null && this.httpUtils.isAuthError(response)) {
                        this.sessionPersister.delete((Context)this.context.get());
                    }
                    String msg = this.ioUtils.readSafe(entity.getContent());
                    throw new SocializeApiError(this.httpUtils, response.getStatusLine().getStatusCode(), msg);
                }
                this.closeEntity(entity);
            }
            catch (Exception e) {
                try {
                    throw SocializeException.wrap(e);
                }
                catch (Throwable throwable) {
                    this.closeEntity(entity);
                    throw throwable;
                }
            }
        } else if (this.logger != null) {
            this.logger.warn("Attempt to access HttpClientFactory that was already destroyed");
        }
    }

    @Override
    public ListResult<T> list(SocializeSession session, String endpoint, int startIndex, int endIndex) throws SocializeException {
        endpoint = this.prepareEndpoint(session, endpoint);
        HttpUriRequest request = this.requestFactory.getListRequest(session, endpoint, startIndex, endIndex);
        return this.doListTypeRequest(request, ActionType.UNKNOWN);
    }

    @Override
    public ListResult<T> list(SocializeSession session, String endpoint, String key, String[] ids, String idKey, Map<String, String> extraParams, int startIndex, int endIndex) throws SocializeException {
        endpoint = this.prepareEndpoint(session, endpoint);
        HttpUriRequest request = this.requestFactory.getListRequest(session, endpoint, key, ids, idKey, extraParams, startIndex, endIndex);
        return this.doListTypeRequest(request, ActionType.UNKNOWN);
    }

    @Override
    public ListResult<T> list(SocializeSession session, String endpoint, String key, String[] ids, int startIndex, int endIndex) throws SocializeException {
        endpoint = this.prepareEndpoint(session, endpoint);
        HttpUriRequest request = this.requestFactory.getListRequest(session, endpoint, key, ids, startIndex, endIndex);
        return this.doListTypeRequest(request, ActionType.UNKNOWN);
    }

    @Override
    public ListResult<T> put(SocializeSession session, String endpoint, T object) throws SocializeException {
        endpoint = this.prepareEndpoint(session, endpoint);
        HttpUriRequest request = this.requestFactory.getPutRequest(session, endpoint, object);
        return this.doListTypeRequest(request, ActionType.UNKNOWN);
    }

    @Override
    public ListResult<T> put(SocializeSession session, String endpoint, Collection<T> objects) throws SocializeException {
        endpoint = this.prepareEndpoint(session, endpoint);
        HttpUriRequest request = this.requestFactory.getPutRequest(session, endpoint, objects);
        return this.doListTypeRequest(request, ActionType.UNKNOWN);
    }

    @Override
    public ListResult<T> post(SocializeSession session, String endpoint, T object, boolean jsonResponse) throws SocializeException {
        endpoint = this.prepareEndpoint(session, endpoint);
        HttpUriRequest request = this.requestFactory.getPostRequest(session, endpoint, object);
        return this.doListTypeRequest(request, ActionType.UNKNOWN, jsonResponse);
    }

    @Override
    public T putAsPost(SocializeSession session, String endpoint, T object) throws SocializeException {
        endpoint = this.prepareEndpoint(session, endpoint);
        HttpUriRequest request = this.requestFactory.getPostRequest(session, endpoint, object);
        return this.doGetTypeRequest(request, ActionType.UNKNOWN);
    }

    @Override
    public ListResult<T> post(SocializeSession session, String endpoint, Collection<T> objects, boolean isJSONResponse) throws SocializeException {
        endpoint = this.prepareEndpoint(session, endpoint);
        HttpUriRequest request = this.requestFactory.getPostRequest(session, endpoint, objects);
        return this.doListTypeRequest(request, ActionType.UNKNOWN);
    }

    private T doGetTypeRequest(HttpUriRequest request, ActionType actionType) throws SocializeException {
        HttpEntity entity = null;
        if (!this.clientFactory.isDestroyed()) {
            T t;
            try {
                HttpClient client = this.clientFactory.getClient();
                HttpResponse response = this.executeRequest(client, request);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("RESPONSE CODE: " + response.getStatusLine().getStatusCode());
                }
                entity = response.getEntity();
                if (this.httpUtils.isHttpError(response)) {
                    if (this.sessionPersister != null && this.httpUtils.isAuthError(response)) {
                        this.sessionPersister.delete((Context)this.context.get());
                    }
                    String msg = this.ioUtils.readSafe(entity.getContent());
                    throw new SocializeApiError(this.httpUtils, response.getStatusLine().getStatusCode(), msg);
                }
                String responseData = this.ioUtils.readSafe(entity.getContent());
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("RESPONSE: " + responseData);
                }
                JSONObject json = this.jsonParser.parseObject(responseData);
                t = this.fromJSON(json, actionType);
                this.closeEntity(entity);
            }
            catch (Exception e) {
                try {
                    throw SocializeException.wrap(e);
                }
                catch (Throwable throwable) {
                    this.closeEntity(entity);
                    throw throwable;
                }
            }
            return t;
        }
        if (this.logger != null) {
            this.logger.warn("Attempt to access HttpClientFactory that was already destroyed");
        }
        return null;
    }

    private HttpResponse executeRequest(HttpClient client, HttpUriRequest request) throws IOException {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            Header[] allHeaders;
            StringBuilder builder = new StringBuilder();
            for (Header header : allHeaders = request.getAllHeaders()) {
                builder.append(header.getName());
                builder.append(":");
                builder.append(header.getValue());
                builder.append("\n");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("REQUEST \nurl:[" + request.getURI().toString() + "] \nheaders:\n" + builder.toString());
            }
            if (request instanceof HttpPost) {
                HttpPost post = (HttpPost)request;
                HttpEntity entity = post.getEntity();
                String requestData = this.ioUtils.readSafe(entity.getContent());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("REQUEST \ndata:[" + requestData + "]");
                }
            }
        }
        return client.execute(request);
    }

    private ListResult<T> doListTypeRequest(HttpUriRequest request, ActionType type) throws SocializeException {
        return this.doListTypeRequest(request, type, true);
    }

    private ListResult<T> doListTypeRequest(HttpUriRequest request, ActionType type, boolean isJSONResponse) throws SocializeException {
        ArrayList<T> results = null;
        ArrayList<ActionError> errors = null;
        HttpEntity entity = null;
        ListResult result = null;
        if (!this.clientFactory.isDestroyed()) {
            try {
                HttpClient client = this.clientFactory.getClient();
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("Request: " + request.getMethod() + " " + request.getRequestLine().getUri());
                }
                HttpResponse response = this.executeRequest(client, request);
                if (this.logger != null && this.logger.isDebugEnabled()) {
                    this.logger.debug("RESPONSE CODE: " + response.getStatusLine().getStatusCode());
                }
                entity = response.getEntity();
                if (this.httpUtils.isHttpError(response)) {
                    if (this.sessionPersister != null && this.httpUtils.isAuthError(response)) {
                        this.sessionPersister.delete((Context)this.context.get());
                    }
                    String msg = this.ioUtils.readSafe(entity.getContent());
                    throw new SocializeApiError(this.httpUtils, response.getStatusLine().getStatusCode(), msg);
                }
                result = new ListResult();
                if (isJSONResponse) {
                    String json = this.ioUtils.readSafe(entity.getContent());
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("RESPONSE: " + json);
                    }
                    if (!StringUtils.isEmpty(json)) {
                        int i;
                        int length;
                        JSONObject object;
                        try {
                            object = this.jsonParser.parseObject(json);
                        }
                        catch (JSONException je) {
                            throw new SocializeException("Failed to parse response as JSON [" + json + "]", je);
                        }
                        if (object.has(JSON_ATTR_ERRORS) && !object.isNull(JSON_ATTR_ERRORS)) {
                            JSONArray errorList = object.getJSONArray(JSON_ATTR_ERRORS);
                            length = errorList.length();
                            errors = new ArrayList<ActionError>(length);
                            for (i = 0; i < length; ++i) {
                                JSONObject jsonObject = errorList.getJSONObject(i);
                                ActionError error = (ActionError)this.errorFactory.fromJSON(jsonObject);
                                errors.add(error);
                            }
                            result.setErrors(errors);
                        }
                        if (object.has(JSON_ATTR_ITEMS) && !object.isNull(JSON_ATTR_ITEMS)) {
                            JSONArray list = object.getJSONArray(JSON_ATTR_ITEMS);
                            length = list.length();
                            results = new ArrayList<T>(length);
                            for (i = 0; i < length; ++i) {
                                results.add(this.fromJSON(list.getJSONObject(i), type));
                            }
                            result.setItems(results);
                        }
                        if (object.has(JSON_ATTR_COUNT) && !object.isNull(JSON_ATTR_COUNT)) {
                            result.setTotalCount(object.getInt(JSON_ATTR_COUNT));
                        }
                    }
                }
                this.closeEntity(entity);
            }
            catch (Throwable e) {
                try {
                    throw SocializeException.wrap(e);
                }
                catch (Throwable throwable) {
                    this.closeEntity(entity);
                    throw throwable;
                }
            }
            return result;
        }
        if (this.logger != null) {
            this.logger.warn("Attempt to access HttpClientFactory that was already destroyed");
        }
        return null;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setSessionPersister(SocializeSessionPersister sessionPersister) {
        this.sessionPersister = sessionPersister;
    }

    public void setAuthProviderDataFactory(IBeanFactory<AuthProviderData> authProviderDataFactory) {
        this.authProviderDataFactory = authProviderDataFactory;
    }

    public void setAuthProviderInfoBuilder(AuthProviderInfoBuilder authProviderInfoBuilder) {
        this.authProviderInfoBuilder = authProviderInfoBuilder;
    }

    private final String prepareEndpoint(SocializeSession session, String endpoint) {
        return this.prepareEndpoint(session, endpoint, false);
    }

    private final String prepareEndpoint(SocializeSession session, String endpoint, boolean secure) {
        return this.prepareEndpoint(session.getHost(), endpoint, secure);
    }

    private final String prepareEndpoint(String host, String endpoint, boolean secure) {
        endpoint = endpoint.trim();
        if (StringUtils.isEmpty(host)) {
            this.logger.warn("The session did not have a host configured, using the config");
            host = this.config.getProperty("api.host");
        }
        if (host != null) {
            if (!host.startsWith("http")) {
                host = secure ? "https://" + host : "http://" + host;
            }
            if (!host.endsWith("/")) {
                if (!endpoint.startsWith("/")) {
                    host = host + "/";
                }
            } else if (endpoint.startsWith("/")) {
                endpoint = endpoint.substring(1, endpoint.length());
            }
            endpoint = host + endpoint;
        } else {
            this.logger.error("Could not locate host property in session or config!");
        }
        if (!endpoint.endsWith("/")) {
            endpoint = endpoint + "/";
        }
        return endpoint;
    }

    private final void closeEntity(HttpEntity entity) {
        block3: {
            if (entity != null) {
                try {
                    entity.consumeContent();
                }
                catch (IOException e) {
                    if (this.logger == null) break block3;
                    this.logger.warn("Failed to fully consume http response content", (Throwable)e);
                }
            }
        }
    }

    public SocializeSessionPersister getSessionPersister() {
        return this.sessionPersister;
    }

    public abstract T fromJSON(JSONObject var1, ActionType var2) throws JSONException;
}

