/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.oauth;

import com.socialize.api.SocializeSession;
import com.socialize.error.SocializeException;
import com.socialize.oauth.OAuthAuthorizer;
import com.socialize.oauth.OAuthConsumerFactory;
import com.socialize.oauth.OAuthRequestSigner;
import com.socialize.oauth.OAuthSignListener;
import com.socialize.oauth.signpost.OAuthConsumer;
import com.socialize.oauth.signpost.signature.SigningStrategy;
import org.apache.http.client.methods.HttpUriRequest;

public class DefaultOauthRequestSigner
implements OAuthRequestSigner {
    private OAuthConsumerFactory consumerFactory;
    private SigningStrategy strategy;

    public DefaultOauthRequestSigner(OAuthConsumerFactory consumerFactory, SigningStrategy strategy) {
        this.strategy = strategy;
        this.consumerFactory = consumerFactory;
    }

    @Override
    public <R extends HttpUriRequest> R sign(SocializeSession session, R request) throws SocializeException {
        return this.sign(session, request, null);
    }

    @Override
    public <R extends HttpUriRequest> R sign(SocializeSession session, R request, OAuthSignListener listener) throws SocializeException {
        try {
            OAuthConsumer consumer = this.consumerFactory.createConsumer(session.getConsumerKey(), session.getConsumerSecret());
            return this.sign(consumer, session, request, listener);
        }
        catch (Exception e) {
            throw new SocializeException(e.getMessage(), e);
        }
    }

    public <R extends HttpUriRequest> R sign(OAuthConsumer consumer, OAuthAuthorizer authorizer, R request, OAuthSignListener listener) throws SocializeException {
        try {
            consumer.setSigningStrategy(this.strategy);
            consumer.setTokenWithSecret(authorizer.getConsumerToken(), authorizer.getConsumerTokenSecret());
            consumer.sign(request, listener);
            return request;
        }
        catch (Exception e) {
            throw new SocializeException(e.getMessage(), e);
        }
    }

    @Override
    public <R extends HttpUriRequest> R sign(String consumerKey, String consumerSecret, String accessToken, String accessTokenSecret, R request, OAuthSignListener listener) throws SocializeException {
        try {
            OAuthConsumer consumer = this.consumerFactory.createConsumer(consumerKey, consumerSecret);
            consumer.setSigningStrategy(this.strategy);
            consumer.setTokenWithSecret(accessToken, accessTokenSecret);
            consumer.sign(request, listener);
            return request;
        }
        catch (Exception e) {
            throw new SocializeException(e.getMessage(), e);
        }
    }
}

