/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.app.Notification;
import android.content.Context;
import android.os.Bundle;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.user.UserSystem;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.JSONFactory;
import com.socialize.entity.User;
import com.socialize.error.SocializeException;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.C2DMCallback;
import com.socialize.notifications.NotificationManagerFacade;
import com.socialize.notifications.NotificationMessage;
import com.socialize.notifications.NotificationMessageBuilder;
import com.socialize.notifications.NotificationRegistrationState;
import com.socialize.notifications.NotificationRegistrationSystem;
import com.socialize.notifications.NotificationType;
import com.socialize.ui.profile.UserSettings;
import com.socialize.util.AppUtils;
import com.socialize.util.StringUtils;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class SocializeC2DMCallback
implements C2DMCallback {
    private int notificationIcon = 17301646;
    private SocializeLogger logger;
    private SocializeConfig config;
    private AppUtils appUtils;
    private UserSystem userSystem;
    private Map<String, JSONFactory<NotificationMessage>> messageFactories;
    private Map<String, NotificationMessageBuilder> messageBuilders;
    private NotificationRegistrationState notificationRegistrationState;
    private NotificationRegistrationSystem notificationRegistrationSystem;
    private NotificationManagerFacade notificationManagerFacade;

    @Override
    public void onRegister(Context context, String registrationId) {
        if (this.logger != null && this.logger.isInfoEnabled()) {
            this.logger.info("Registration with GCM successful: " + registrationId);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GCM ID [" + registrationId + "]");
            }
        }
        this.notificationRegistrationState.setC2DMRegistrationId(registrationId);
        this.notificationRegistrationState.save(context);
        this.notificationRegistrationSystem.registerSocialize(context, registrationId);
    }

    @Override
    public void onError(Context context, String errorId) {
        if (this.logger != null && this.logger.isWarnEnabled()) {
            this.logger.warn("Registration with GCM failed: " + errorId);
        }
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public void onMessage(Context context, Bundle data) {
        try {
            SocializeSession session = this.userSystem.authenticateSynchronous(context, this.config.getProperty("socialize.consumer.key"), this.config.getProperty("socialize.consumer.secret"));
            this.handleNotification(context, data, session);
        }
        catch (SocializeException e) {
            this.handleError("Failed to authenticate user for notification receipt", e);
        }
    }

    protected void handleNotification(Context context, Bundle data, SocializeSession session) {
        block19: {
            UserSettings settings = session.getUserSettings();
            User user = session.getUser();
            if (settings != null && settings.isNotificationsEnabled()) {
                String json = data.getString("message");
                if (!StringUtils.isEmpty(json)) {
                    if (this.logger != null && this.logger.isDebugEnabled()) {
                        this.logger.debug("Received notification [" + json + "]");
                    }
                    try {
                        JSONObject message = this.newJSONObject(json);
                        String notification_type = "notification_type";
                        if (message.has(notification_type) && !message.isNull(notification_type)) {
                            String type = message.getString(notification_type).trim().toUpperCase();
                            NotificationType notificationType = null;
                            try {
                                notificationType = NotificationType.valueOf(type);
                            }
                            catch (Exception e) {
                                this.handleError("Invalid notification_type [" + type + "] defined in notification message [" + json + "]", e);
                            }
                            if (notificationType != null) {
                                JSONFactory<NotificationMessage> factory = this.messageFactories.get(notificationType.name());
                                if (factory != null) {
                                    NotificationMessage notificationMessage = factory.fromJSON(message);
                                    NotificationMessageBuilder builder = this.messageBuilders.get(notificationType.name());
                                    if (builder != null) {
                                        int icon = this.getNotificationIcon(context);
                                        Notification notification = builder.build(context, data, notificationMessage, icon);
                                        this.doNotify(context, this.getNotificationTag(notificationMessage), this.getNotificationId(notificationMessage), notification);
                                    } else {
                                        this.handleError("No message builder defined for notification type [" + (Object)((Object)notificationType) + "]");
                                    }
                                } else {
                                    this.handleError("No message factory defined for notification type [" + (Object)((Object)notificationType) + "]");
                                }
                            }
                            break block19;
                        }
                        this.handleError("No notification_type defined in notification message [" + json + "]");
                    }
                    catch (JSONException e) {
                        this.handleError("Notification system received an invalid JSON message [" + json + "]", (Exception)((Object)e));
                    }
                    catch (Exception e) {
                        this.handleError("Error building notification message", e);
                    }
                } else {
                    this.handleError("No data found in message bundle under key [message]");
                }
            } else if (settings == null) {
                this.handleError("No user settings found in session!");
            } else if (this.logger != null && this.logger.isDebugEnabled()) {
                this.logger.debug("Notification for user [" + user.getId() + "] ignored.  Notifications are disabled for this user");
            }
        }
    }

    protected void doNotify(Context context, String tag, int id, Notification notification) {
        this.notificationManagerFacade.notify(context, tag, id, notification);
    }

    protected String getNotificationTag(NotificationMessage message) {
        if (message.getEntityId() != null) {
            return String.valueOf(message.getEntityId());
        }
        if (message.getUrl() != null) {
            return message.getUrl();
        }
        return String.valueOf(message.getActionId());
    }

    protected int getNotificationId(NotificationMessage message) {
        if (message.getEntityId() != null) {
            return message.getEntityId().intValue();
        }
        return 0;
    }

    protected JSONObject newJSONObject(String json) throws JSONException {
        return new JSONObject(json);
    }

    protected int getNotificationIcon(Context context) {
        int icon = this.notificationIcon;
        if (this.config.getBooleanProperty("socialize.notification.app.icon", true) && (icon = this.appUtils.getAppIconId(context)) <= 0 && this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Could not locate ID for application icon.  Using default icon for notification");
            icon = this.notificationIcon;
        }
        return icon;
    }

    protected void handleError(String msg) {
        if (this.logger != null) {
            this.logger.error(msg);
        } else {
            System.err.println(msg);
        }
    }

    protected void handleError(String msg, Exception e) {
        if (this.logger != null) {
            this.logger.error(msg, (Throwable)e);
        } else {
            SocializeLogger.e(msg, e);
        }
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    public int getNotificationIcon() {
        return this.notificationIcon;
    }

    public void setNotificationIcon(int notificationIcon) {
        this.notificationIcon = notificationIcon;
    }

    public void setMessageFactories(Map<String, JSONFactory<NotificationMessage>> messageFactories) {
        this.messageFactories = messageFactories;
    }

    public void setMessageBuilders(Map<String, NotificationMessageBuilder> messageBuilders) {
        this.messageBuilders = messageBuilders;
    }

    public void setNotificationRegistrationState(NotificationRegistrationState notificationRegistrationState) {
        this.notificationRegistrationState = notificationRegistrationState;
    }

    public void setNotificationRegistrationSystem(NotificationRegistrationSystem notificationRegistrationSystem) {
        this.notificationRegistrationSystem = notificationRegistrationSystem;
    }

    public void setUserSystem(UserSystem userSystem) {
        this.userSystem = userSystem;
    }

    public void setNotificationManagerFacade(NotificationManagerFacade notificationManagerFacade) {
        this.notificationManagerFacade = notificationManagerFacade;
    }
}

