/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import android.content.Context;
import com.socialize.Socialize;
import com.socialize.api.SocializeSession;
import com.socialize.config.SocializeConfig;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.NotificationRegistrationState;
import com.socialize.notifications.NotificationRegistrationSystem;
import com.socialize.util.AppUtils;
import com.socialize.util.StringUtils;

public class NotificationChecker {
    private NotificationRegistrationSystem notificationRegistrationSystem;
    private NotificationRegistrationState notificationRegistrationState;
    private SocializeLogger logger;
    private SocializeConfig config;
    private AppUtils appUtils;
    private boolean checked = false;
    private boolean checking = false;

    public void checkRegistrations(final Context context) {
        if (!this.checked) {
            Socialize.getSocialize().authenticate(context, new SocializeAuthListener(){

                @Override
                public void onError(SocializeException error) {
                    NotificationChecker.this.logError(error);
                }

                @Override
                public void onCancel() {
                }

                @Override
                public void onAuthSuccess(final SocializeSession session) {
                    new Thread(){

                        @Override
                        public void run() {
                            NotificationChecker.this.checked = NotificationChecker.this.checkRegistrations(context, session);
                        }
                    }.start();
                }

                @Override
                public void onAuthFail(SocializeException error) {
                    NotificationChecker.this.logError(error);
                }
            });
        }
    }

    protected void logError(Exception e) {
        if (this.logger != null) {
            this.logger.error("Error checking notification state", (Throwable)e);
        } else {
            SocializeLogger.e(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRegistrations(Context context, SocializeSession session) {
        boolean checked = false;
        if (!this.checking) {
            this.checking = true;
            try {
                if (this.appUtils.isNotificationsAvailable(context)) {
                    if (this.config.getBooleanProperty("socialize.check.notifications", true)) {
                        if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("Checking GCM registration state");
                        }
                        boolean c2DMRegistered = this.notificationRegistrationSystem.isRegisteredC2DM(context);
                        boolean socRegistered = this.notificationRegistrationSystem.isRegisteredSocialize(context, session.getUser());
                        if (!c2DMRegistered || !socRegistered) {
                            this.notificationRegistrationState.reload(context);
                            c2DMRegistered = this.notificationRegistrationSystem.isRegisteredC2DM(context);
                            socRegistered = this.notificationRegistrationSystem.isRegisteredSocialize(context, session.getUser());
                            if (!c2DMRegistered || !socRegistered) {
                                if (!c2DMRegistered && this.config.getBooleanProperty("gcm.registration.enabled", true)) {
                                    if (this.notificationRegistrationSystem.isRegistrationPending()) {
                                        if (this.logger != null && this.logger.isDebugEnabled()) {
                                            this.logger.debug("GCM Registration already pending");
                                        }
                                    } else {
                                        if (this.logger != null && this.logger.isInfoEnabled()) {
                                            this.logger.info("Not registered with GCM, sending registration request...");
                                        }
                                        this.notificationRegistrationSystem.registerC2DMAsync(context);
                                    }
                                } else if (!socRegistered && !StringUtils.isEmpty(this.notificationRegistrationState.getC2DMRegistrationId())) {
                                    if (this.notificationRegistrationSystem.isSocializeRegistrationPending()) {
                                        if (this.logger != null && this.logger.isDebugEnabled()) {
                                            this.logger.debug("Registration already pending with Socialize for GCM");
                                        }
                                    } else {
                                        if (this.logger != null && this.logger.isInfoEnabled()) {
                                            this.logger.info("Not registered with Socialize for GCM, registering...");
                                        }
                                        this.notificationRegistrationSystem.registerSocialize(context, this.notificationRegistrationState.getC2DMRegistrationId());
                                    }
                                }
                            } else if (this.logger != null && this.logger.isDebugEnabled()) {
                                this.logger.debug("GCM registration OK");
                            }
                        } else if (this.logger != null && this.logger.isDebugEnabled()) {
                            this.logger.debug("GCM registration OK");
                        }
                        checked = true;
                    } else if (this.logger != null && this.logger.isWarnEnabled()) {
                        this.logger.warn("GCM registration check skipped");
                    }
                } else {
                    if (this.logger != null && this.logger.isInfoEnabled()) {
                        this.logger.info("Notifications not enabled.  Check the AndroidManifest.xml for correct configuration.");
                    }
                    checked = true;
                }
            }
            finally {
                this.checking = false;
            }
        }
        return checked;
    }

    public void setNotificationRegistrationSystem(NotificationRegistrationSystem notificationRegistrationSystem) {
        this.notificationRegistrationSystem = notificationRegistrationSystem;
    }

    public void setNotificationRegistrationState(NotificationRegistrationState notificationRegistrationState) {
        this.notificationRegistrationState = notificationRegistrationState;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }
}

