/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import com.socialize.notifications.BaseNotificationMessageFactory;
import com.socialize.notifications.NotificationMessage;
import com.socialize.notifications.NotificationType;
import com.socialize.util.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class DeveloperNotificationMessageFactory
extends BaseNotificationMessageFactory {
    @Override
    protected void fromJSON(JSONObject from, NotificationMessage to) throws JSONException {
        to.setText(this.getString(from, "message"));
        to.setUrl(this.getString(from, "url"));
        to.setEntityId(this.getLongObject(from, "entity_id"));
        String notificationType = this.getString(from, "notification_type");
        if (!StringUtils.isEmpty(notificationType)) {
            try {
                to.setNotificationType(NotificationType.valueOf(notificationType.trim().toUpperCase()));
            }
            catch (Exception e) {
                String msg = "Invalid notification type [" + notificationType + "]";
                this.handleError(msg, e);
                to.setNotificationType(NotificationType.DEVELOPER_NOTIFICATION);
            }
        }
    }
}

