/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.notifications;

import com.socialize.api.action.ActionType;
import com.socialize.notifications.BaseNotificationMessageFactory;
import com.socialize.notifications.NotificationMessage;
import com.socialize.notifications.NotificationType;
import com.socialize.util.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ActionNotificationMessageFactory
extends BaseNotificationMessageFactory {
    @Override
    protected void fromJSON(JSONObject from, NotificationMessage to) throws JSONException {
        String msg;
        to.setText(this.getString(from, "text"));
        to.setUser(this.getString(from, "user"));
        to.setEntity(this.getString(from, "entity"));
        to.setActionId(this.getLong(from, "activity_id"));
        to.setEntityId(this.getLongObject(from, "entity_id"));
        String actionType = this.getString(from, "activity_type");
        String notificationType = this.getString(from, "notification_type");
        if (!StringUtils.isEmpty(notificationType)) {
            try {
                to.setNotificationType(NotificationType.valueOf(notificationType.trim().toUpperCase()));
            }
            catch (Exception e) {
                msg = "Invalid notification type [" + notificationType + "]";
                this.handleError(msg, e);
                to.setNotificationType(NotificationType.NEW_COMMENTS);
            }
        }
        if (!StringUtils.isEmpty(actionType)) {
            try {
                to.setActionType(ActionType.valueOf(actionType.trim().toUpperCase()));
            }
            catch (Exception e) {
                msg = "Invalid action type [" + actionType + "]";
                this.handleError(msg, e);
                if (to.getNotificationType().equals((Object)NotificationType.NEW_COMMENTS)) {
                    to.setActionType(ActionType.COMMENT);
                }
                to.setActionType(ActionType.UNKNOWN);
            }
        }
    }
}

