/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks.twitter;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import com.socialize.ConfigUtils;
import com.socialize.ShareUtils;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.apache.http.entity.mime.HttpMultipartMode;
import com.socialize.apache.http.entity.mime.MultipartEntity;
import com.socialize.apache.http.entity.mime.content.ByteArrayBody;
import com.socialize.apache.http.entity.mime.content.StringBody;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.share.ShareOptions;
import com.socialize.api.action.share.SocialNetworkShareListener;
import com.socialize.api.action.user.UserSystem;
import com.socialize.auth.AuthProviderInfoBuilder;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.DefaultUserProviderCredentials;
import com.socialize.auth.UserProviderCredentials;
import com.socialize.auth.twitter.TwitterAuthProviderInfo;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.Entity;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.net.HttpRequestListener;
import com.socialize.net.HttpRequestProvider;
import com.socialize.networks.DefaultPostData;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.networks.SocialNetworkPostListener;
import com.socialize.networks.twitter.PhotoTweet;
import com.socialize.networks.twitter.Tweet;
import com.socialize.networks.twitter.TwitterUtilsProxy;
import com.socialize.oauth.OAuthRequestSigner;
import com.socialize.util.ImageUtils;
import com.socialize.util.JSONParser;
import com.socialize.util.StringUtils;
import com.socialize.util.UrlBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

public class TwitterUtilsImpl
implements TwitterUtilsProxy {
    private UserSystem userSystem;
    private SocializeConfig config;
    private OAuthRequestSigner requestSigner;
    private HttpRequestProvider httpRequestProvider;
    private ImageUtils imageUtils;
    private AuthProviderInfoBuilder authProviderInfoBuilder;
    private JSONParser jsonParser;
    private SocializeConfig socializeConfig;

    @Override
    public void link(Activity context, SocializeAuthListener listener) {
        this.getSocialize().authenticateForWrite((Context)context, AuthProviderType.TWITTER, listener, new String[0]);
    }

    @Override
    public void link(Activity context, String token, String secret, SocializeAuthListener listener) {
        TwitterAuthProviderInfo twInfo = new TwitterAuthProviderInfo();
        twInfo.setConsumerKey(this.config.getProperty("twitter.consumer.key"));
        twInfo.setConsumerSecret(this.config.getProperty("twitter.consumer.secret"));
        DefaultUserProviderCredentials credentials = new DefaultUserProviderCredentials();
        credentials.setAuthProviderInfo(twInfo);
        credentials.setAccessToken(token);
        credentials.setTokenSecret(secret);
        this.getSocialize().authenticateKnownUser((Context)context, credentials, listener);
    }

    @Override
    public void unlink(Context context) {
        SocializeSession session = this.getSocialize().getSession();
        session.clear(AuthProviderType.TWITTER);
        session.getUserSettings().setAutoPostTwitter(false);
        this.userSystem.saveSession(context, session);
    }

    @Override
    public boolean isLinked(Context context) {
        return this.getSocialize().isAuthenticatedForWrite(AuthProviderType.TWITTER, new String[0]);
    }

    @Override
    public boolean isAvailable(Context context) {
        return this.authProviderInfoBuilder.isSupported(AuthProviderType.TWITTER);
    }

    @Override
    public void setCredentials(Context context, String consumerKey, String consumerSecret) {
        this.config.setTwitterKeySecret(consumerKey, consumerSecret);
    }

    @Override
    public String getAccessToken(Context context) {
        UserProviderCredentials creds = this.getSocialize().getSession().getUserProviderCredentials(AuthProviderType.TWITTER);
        if (creds != null) {
            return creds.getAccessToken();
        }
        return null;
    }

    @Override
    public String getTokenSecret(Context context) {
        UserProviderCredentials creds = this.getSocialize().getSession().getUserProviderCredentials(AuthProviderType.TWITTER);
        if (creds != null) {
            return creds.getTokenSecret();
        }
        return null;
    }

    @Override
    public void tweetEntity(Activity context, Entity entity, String text, SocialNetworkShareListener listener) {
        ShareOptions options = ShareUtils.getUserShareOptions((Context)context);
        options.setText(text);
        options.setShowAuthDialog(false);
        ShareUtils.shareViaSocialNetworks(context, entity, options, listener, SocialNetwork.TWITTER);
    }

    @Override
    public void tweetPhoto(Activity context, PhotoTweet tweet, SocialNetworkPostListener listener) {
        block2: {
            try {
                MultipartEntity multipart = this.newMultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
                ByteArrayBody body = new ByteArrayBody(tweet.getImageData(), "media");
                StringBody status = new StringBody(tweet.getText());
                StringBody possiblySensitive = new StringBody(String.valueOf(tweet.isPossiblySensitive()));
                multipart.addPart("media", body);
                multipart.addPart("status", status);
                multipart.addPart("possibly_sensitive", possiblySensitive);
                String photoEndpoint = this.config.getProperty("twitter.upload.endpoint");
                this.post(context, photoEndpoint + "statuses/update_with_media.json", multipart, listener);
            }
            catch (Exception e) {
                if (listener == null) break block2;
                listener.onNetworkError(context, SocialNetwork.TWITTER, e);
            }
        }
    }

    protected MultipartEntity newMultipartEntity(HttpMultipartMode mode) {
        return new MultipartEntity(mode);
    }

    @Override
    public void tweet(Activity context, Tweet tweet, SocialNetworkListener listener) {
        this.tweet(context, null, tweet, listener);
    }

    @Override
    public void tweet(Activity context, Entity entity, Tweet tweet, SocialNetworkListener listener) {
        DefaultPostData postData = new DefaultPostData();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", tweet.getText());
        if (tweet.isShareLocation() && tweet.getLocation() != null) {
            map.put("lat", String.valueOf(tweet.getLocation().getLatitude()));
            map.put("long", String.valueOf(tweet.getLocation().getLongitude()));
            map.put("display_coordinates", "true");
        }
        postData.setPostValues(map);
        postData.setEntity(entity);
        boolean okToGo = true;
        if (listener != null) {
            boolean bl = okToGo = !listener.onBeforePost(context, SocialNetwork.TWITTER, postData);
        }
        if (okToGo) {
            String path = postData.getPath();
            if (StringUtils.isEmpty(path)) {
                path = "statuses/update.json";
            }
            this.post(context, path, postData.getPostValues(), (SocialNetworkPostListener)listener);
        }
    }

    @Override
    public void post(Activity context, String resource, Map<String, Object> postData, SocialNetworkPostListener listener) {
        block3: {
            try {
                Set<Map.Entry<String, Object>> entries = postData.entrySet();
                ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, Object> entry : entries) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (key == null || value == null) continue;
                    data.add(new BasicNameValuePair(key, value.toString()));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(data, "UTF-8");
                String apiEndpoint = this.config.getProperty("twitter.api.endpoint");
                this.post(context, apiEndpoint + resource, (HttpEntity)entity, listener);
            }
            catch (Exception e) {
                if (listener == null) break block3;
                listener.onNetworkError(context, SocialNetwork.TWITTER, e);
            }
        }
    }

    protected void post(final Activity context, String resource, HttpEntity entity, final SocialNetworkPostListener listener) {
        block3: {
            try {
                resource = resource.trim();
                if (!resource.endsWith(".json")) {
                    resource = resource + ".json";
                }
                HttpPost post = new HttpPost(resource);
                post.setEntity(entity);
                SocializeSession session = this.getSocialize().getSession();
                UserProviderCredentials creds = session.getUserProviderCredentials(AuthProviderType.TWITTER);
                String consumerKey = ConfigUtils.getConfig((Context)context).getProperty("twitter.consumer.key");
                String consumerSecret = ConfigUtils.getConfig((Context)context).getProperty("twitter.consumer.secret");
                HttpPost signedRequest = this.requestSigner.sign(consumerKey, consumerSecret, creds.getAccessToken(), creds.getTokenSecret(), post, null);
                this.httpRequestProvider.post(signedRequest, new HttpRequestListener(){

                    @Override
                    public void onSuccess(HttpResponse response, String responseData) {
                        block3: {
                            try {
                                JSONObject responseObject = TwitterUtilsImpl.this.jsonParser.parseObject(responseData);
                                if (listener != null) {
                                    listener.onAfterPost(context, SocialNetwork.TWITTER, responseObject);
                                }
                            }
                            catch (JSONException e) {
                                if (listener == null) break block3;
                                listener.onNetworkError(context, SocialNetwork.TWITTER, (Exception)((Object)e));
                            }
                        }
                    }

                    @Override
                    public void onError(Exception error, HttpResponse response, int errorCode, String responseData) {
                        if (listener != null) {
                            listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (listener == null) break block3;
                listener.onNetworkError(context, SocialNetwork.TWITTER, e);
            }
        }
    }

    @Override
    public void get(final Activity context, String resource, Map<String, Object> params, final SocialNetworkPostListener listener) {
        block7: {
            try {
                resource = resource.trim();
                if (!resource.contains(".json")) {
                    if (resource.contains("?")) {
                        String[] split = resource.split("\\?");
                        split[0] = split[0] + ".json";
                        resource = split[0] + split[1];
                    } else {
                        resource = resource + ".json";
                    }
                }
                String apiEndpoint = this.config.getProperty("twitter.api.endpoint");
                UrlBuilder builder = new UrlBuilder();
                builder.start(apiEndpoint + resource);
                if (params != null) {
                    Set<Map.Entry<String, Object>> entries = params.entrySet();
                    for (Map.Entry<String, Object> entry : entries) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (key == null || entry == null) continue;
                        builder.addParam(key, value.toString());
                    }
                }
                HttpGet get = new HttpGet(builder.toString());
                SocializeSession session = this.getSocialize().getSession();
                UserProviderCredentials creds = session.getUserProviderCredentials(AuthProviderType.TWITTER);
                String consumerKey = ConfigUtils.getConfig((Context)context).getProperty("twitter.consumer.key");
                String consumerSecret = ConfigUtils.getConfig((Context)context).getProperty("twitter.consumer.secret");
                HttpGet signedRequest = this.requestSigner.sign(consumerKey, consumerSecret, creds.getAccessToken(), creds.getTokenSecret(), get, null);
                this.httpRequestProvider.get(signedRequest, new HttpRequestListener(){

                    @Override
                    public void onSuccess(HttpResponse response, String responseData) {
                        block3: {
                            try {
                                JSONObject responseObject = TwitterUtilsImpl.this.jsonParser.parseObject(responseData);
                                if (listener != null) {
                                    listener.onAfterPost(context, SocialNetwork.TWITTER, responseObject);
                                }
                            }
                            catch (JSONException e) {
                                if (listener == null) break block3;
                                listener.onNetworkError(context, SocialNetwork.TWITTER, (Exception)((Object)e));
                            }
                        }
                    }

                    @Override
                    public void onError(Exception error, HttpResponse response, int errorCode, String responseData) {
                        if (listener != null) {
                            listener.onNetworkError(context, SocialNetwork.TWITTER, error);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (listener == null) break block7;
                listener.onNetworkError(context, SocialNetwork.TWITTER, e);
            }
        }
    }

    @Override
    public byte[] getImageForPost(Activity context, Uri imagePath) throws IOException {
        return this.imageUtils.scaleImage((Context)context, imagePath);
    }

    @Override
    public byte[] getImageForPost(Activity context, Bitmap image, Bitmap.CompressFormat format) throws IOException {
        return this.imageUtils.scaleImage((Context)context, image, format);
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    public void setUserSystem(UserSystem userSystem) {
        this.userSystem = userSystem;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setRequestSigner(OAuthRequestSigner requestSigner) {
        this.requestSigner = requestSigner;
    }

    public void setHttpRequestProvider(HttpRequestProvider httpRequestProvider) {
        this.httpRequestProvider = httpRequestProvider;
    }

    public void setImageUtils(ImageUtils imageUtils) {
        this.imageUtils = imageUtils;
    }

    public void setAuthProviderInfoBuilder(AuthProviderInfoBuilder authProviderInfoBuilder) {
        this.authProviderInfoBuilder = authProviderInfoBuilder;
    }

    public void setJsonParser(JSONParser jsonParser) {
        this.jsonParser = jsonParser;
    }
}

