/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks.twitter;

import android.app.Activity;
import android.content.Context;
import com.socialize.LocationUtils;
import com.socialize.UserUtils;
import com.socialize.api.action.ActionType;
import com.socialize.entity.Entity;
import com.socialize.entity.PropagationInfo;
import com.socialize.error.SocializeException;
import com.socialize.networks.AbstractSocialNetworkSharer;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.networks.twitter.Tweet;
import com.socialize.networks.twitter.TwitterUtilsProxy;
import com.socialize.ui.profile.UserSettings;
import com.socialize.util.StringUtils;

public class TwitterSharer
extends AbstractSocialNetworkSharer {
    private TwitterUtilsProxy twitterUtils;

    @Override
    protected SocialNetwork getNetwork() {
        return SocialNetwork.TWITTER;
    }

    @Override
    protected void doShare(Activity context, Entity entity, PropagationInfo urlSet, String comment, SocialNetworkListener listener, ActionType type) throws SocializeException {
        Tweet tweet = new Tweet();
        switch (type) {
            case SHARE: {
                if (!StringUtils.isEmpty(comment)) break;
                comment = "Shared " + entity.getDisplayName();
                break;
            }
            case LIKE: {
                comment = "\u2764 likes " + entity.getDisplayName();
                break;
            }
            case VIEW: {
                comment = "Viewed " + entity.getDisplayName();
            }
        }
        StringBuilder status = new StringBuilder();
        if (StringUtils.isEmpty(comment)) {
            status.append(entity.getDisplayName());
        } else {
            status.append(comment);
        }
        status.append(", ");
        status.append(urlSet.getEntityUrl());
        tweet.setText(status.toString());
        UserSettings settings = UserUtils.getUserSettings((Context)context);
        if (settings != null && settings.isLocationEnabled()) {
            tweet.setLocation(LocationUtils.getLastKnownLocation((Context)context));
            tweet.setShareLocation(true);
        }
        this.twitterUtils.tweet(context, tweet, listener);
    }

    public void setTwitterUtils(TwitterUtilsProxy twitterUtils) {
        this.twitterUtils = twitterUtils;
    }
}

