/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks.facebook.v3;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.facebook.AccessToken;
import com.facebook.FacebookOperationCanceledException;
import com.facebook.FacebookRequestError;
import com.facebook.HttpMethod;
import com.facebook.Request;
import com.facebook.RequestAsyncTask;
import com.facebook.Response;
import com.facebook.Session;
import com.facebook.SessionLoginBehavior;
import com.facebook.SessionState;
import com.facebook.model.GraphUser;
import com.socialize.auth.AuthProviderResponse;
import com.socialize.error.SocializeException;
import com.socialize.listener.AuthProviderListener;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.listener.SocializeListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkPostListener;
import com.socialize.networks.facebook.BaseFacebookFacade;
import com.socialize.networks.facebook.OnPermissionResult;
import com.socialize.util.StringUtils;
import java.util.Arrays;

public class FacebookFacadeV3
extends BaseFacebookFacade {
    @Override
    public void onActivityResult(Activity context, int requestCode, int resultCode, Intent data) {
        Session activeSession = this.getActiveSession((Context)context);
        if (activeSession != null) {
            activeSession.onActivityResult(context, requestCode, resultCode, data);
        }
    }

    @Override
    public int getSDKMajorVersion() {
        return 3;
    }

    @Override
    @Deprecated
    public void authenticate(Activity context, String appId, String[] permissions, boolean sso, AuthProviderListener listener) {
        this.logout((Context)context);
        this.login(context, appId, permissions, sso, true, listener);
    }

    @Override
    public void authenticate(Activity context, String appId, String[] permissions, boolean sso, boolean read, AuthProviderListener listener) {
        this.login(context, appId, permissions, sso, read, listener);
    }

    protected void login(Activity context, boolean read, AuthProviderListener listener) {
        this.login(context, this.config.getProperty("facebook.app.id"), read ? READ_PERMISSIONS : WRITE_PERMISSIONS, this.config.getBooleanProperty("facebook.sso.enabled", true), read, listener);
    }

    @Override
    public void onResume(Activity context, SocializeAuthListener listener) {
        Session session = Session.getActiveSession();
        if (session == null) {
            session = this.createNewSession(context, this.config.getProperty("facebook.app.id"));
            String strToken = this.getAccessToken((Context)context);
            if (!StringUtils.isEmpty(strToken)) {
                AccessToken accessToken = AccessToken.createFromExistingAccessToken((String)strToken, null, null, null, null);
                this.openSessionWithToken(session, accessToken);
                Session.setActiveSession((Session)session);
            }
        }
    }

    protected Session createNewSession(Activity context, String appId) {
        return new Session.Builder((Context)context).setApplicationId(appId).build();
    }

    protected void openSessionWithToken(Session session, AccessToken token) {
        session.open(token, null);
    }

    protected void openSessionForRead(Session session, Session.OpenRequest auth) {
        session.openForRead(auth);
    }

    protected void openSessionForPublish(Session session, Session.OpenRequest auth) {
        session.openForPublish(auth);
    }

    protected void login(Activity context, String appId, String[] permissions, boolean sso, boolean read, AuthProviderListener listener) {
        Session.OpenRequest auth = new Session.OpenRequest(context);
        if (permissions != null) {
            auth.setPermissions(Arrays.asList(permissions));
        }
        if (sso) {
            auth.setLoginBehavior(SessionLoginBehavior.SSO_WITH_FALLBACK);
        } else {
            auth.setLoginBehavior(SessionLoginBehavior.SUPPRESS_SSO);
        }
        auth.setCallback(this.createLoginCallback(listener));
        Session session = this.createNewSession(context, appId);
        Session.setActiveSession((Session)session);
        if (read) {
            this.openSessionForRead(session, auth);
        } else {
            this.openSessionForPublish(session, auth);
        }
    }

    protected Session.StatusCallback createLoginCallback(final AuthProviderListener listener) {
        return new Session.StatusCallback(){

            public void call(Session session, SessionState state, Exception exception) {
                if (exception != null && exception instanceof FacebookOperationCanceledException) {
                    if (FacebookFacadeV3.this.logger != null) {
                        FacebookFacadeV3.this.logger.error("Facebook operation failed", (Throwable)exception);
                    }
                    FacebookFacadeV3.this.handleCancel(listener);
                    return;
                }
                switch (state) {
                    case OPENED: {
                        if (!FacebookFacadeV3.this.isSessionOpen(session)) break;
                        FacebookFacadeV3.this.getUser(session, listener);
                        break;
                    }
                    case CLOSED: {
                        if (exception == null) break;
                        FacebookFacadeV3.this.handleError(exception, listener);
                        break;
                    }
                    case CLOSED_LOGIN_FAILED: {
                        if (exception == null) break;
                        FacebookFacadeV3.this.handleAuthFail(exception, listener);
                    }
                }
            }
        };
    }

    protected boolean isSessionOpen(Session session) {
        return session.isOpened();
    }

    protected void getUser(final Session session, final AuthProviderListener listener) {
        Request.executeMeRequestAsync((Session)session, (Request.GraphUserCallback)new Request.GraphUserCallback(){

            public void onCompleted(GraphUser user, Response response) {
                if (response.getError() != null) {
                    FacebookFacadeV3.this.handleError((Exception)response.getError().getException(), listener);
                } else if (user != null) {
                    FacebookFacadeV3.this.handleResult(session, user, listener);
                }
            }
        });
    }

    protected void handleError(Exception exception, SocializeListener listener) {
        if (listener != null) {
            listener.onError(SocializeException.wrap(exception));
        }
    }

    protected void handleAuthFail(Exception exception, AuthProviderListener listener) {
        if (listener != null) {
            listener.onAuthFail(SocializeException.wrap(exception));
        }
    }

    protected void handleCancel(AuthProviderListener listener) {
        if (listener != null) {
            listener.onCancel();
        }
    }

    protected void handleResult(Session session, GraphUser user, AuthProviderListener listener) {
        if (listener != null) {
            AuthProviderResponse response = new AuthProviderResponse();
            response.setUserId(user.getId());
            response.setToken(session.getAccessToken());
            listener.onAuthSuccess(response);
        }
    }

    @Override
    public void extendAccessToken(Activity context, SocializeAuthListener listener) {
    }

    @Override
    public void getCurrentPermissions(Activity context, String token, final OnPermissionResult callback) {
        Session activeSession = this.getActiveSession((Context)context);
        if (activeSession != null) {
            if (activeSession.getAccessToken().equals(token)) {
                callback.onSuccess(activeSession.getPermissions().toArray(new String[activeSession.getPermissions().size()]));
            } else {
                AccessToken accessToken = AccessToken.createFromExistingAccessToken((String)token, null, null, null, null);
                if (activeSession.isOpened()) {
                    activeSession.closeAndClearTokenInformation();
                    activeSession = new Session.Builder((Context)context).setApplicationId(this.config.getProperty("facebook.app.id")).build();
                }
                activeSession.open(accessToken, new Session.StatusCallback(){

                    public void call(Session session, SessionState state, Exception exception) {
                        if (exception != null) {
                            if (callback != null) {
                                callback.onError(SocializeException.wrap(exception));
                            } else if (FacebookFacadeV3.this.logger != null) {
                                FacebookFacadeV3.this.logger.error("Error accessing permissions for alternate token", (Throwable)exception);
                            } else {
                                Log.e((String)"Socialize", (String)"Error accessing permissions for alternate token", (Throwable)exception);
                            }
                        } else {
                            Session.setActiveSession((Session)session);
                            if (callback != null) {
                                callback.onSuccess(session.getPermissions().toArray(new String[session.getPermissions().size()]));
                            }
                        }
                    }
                });
            }
        } else {
            this.handleNotSignedIn(context, callback);
        }
    }

    @Override
    public void logout(Context context) {
        Session activeSession = this.getActiveSession(context);
        if (activeSession != null) {
            activeSession.closeAndClearTokenInformation();
        }
    }

    @Override
    @Deprecated
    public boolean isLinked(Context context) {
        return super.isLinked(context) && this.getActiveSession(context) != null;
    }

    @Override
    protected void doFacebookCall(final Activity context, final Bundle data, final String graphPath, final HttpMethod method, final SocialNetworkPostListener listener) {
        Session activeSession = this.getActiveSession((Context)context);
        boolean read = method.equals((Object)HttpMethod.GET);
        if (activeSession != null) {
            if (activeSession.isOpened()) {
                Request request = new Request(activeSession, graphPath, data, method, new Request.Callback(){

                    public void onCompleted(Response response) {
                        FacebookFacadeV3.this.handleFBResponse(context, response, listener);
                    }
                });
                RequestAsyncTask task = new RequestAsyncTask(new Request[]{request});
                task.execute((Object[])new Void[0]);
            } else {
                this.login(context, read, new AuthProviderListener(){

                    @Override
                    public void onError(SocializeException error) {
                        if (listener != null) {
                            listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                        }
                        FacebookFacadeV3.this.handleNonListenerError("", error);
                    }

                    @Override
                    public void onCancel() {
                        if (listener != null) {
                            listener.onCancel();
                        }
                    }

                    @Override
                    public void onAuthSuccess(AuthProviderResponse response) {
                        FacebookFacadeV3.this.doFacebookCall(context, data, graphPath, method, listener);
                    }

                    @Override
                    public void onAuthFail(SocializeException error) {
                        if (listener != null) {
                            listener.onNetworkError(context, SocialNetwork.FACEBOOK, error);
                        }
                        FacebookFacadeV3.this.handleNonListenerError("", error);
                        FacebookFacadeV3.this.unlink((Context)context, null);
                    }
                });
            }
        } else {
            this.handleNotSignedIn(context, listener);
        }
    }

    protected Session getActiveSession(Context context) {
        Session activeSession = Session.getActiveSession();
        if (activeSession == null) {
            activeSession = new Session.Builder(context).setApplicationId(this.config.getProperty("facebook.app.id")).build();
            Session.setActiveSession((Session)activeSession);
        }
        return activeSession;
    }

    protected void handleFBResponse(Activity context, Response response, SocialNetworkPostListener listener) {
        FacebookRequestError error = response.getError();
        if (error != null) {
            if (listener != null) {
                listener.onNetworkError(context, SocialNetwork.FACEBOOK, (Exception)error.getException());
            }
            if (this.logger != null) {
                this.logger.error(error.getErrorMessage(), (Throwable)error.getException());
            } else {
                Log.e((String)"Socialize", (String)error.getErrorMessage(), (Throwable)error.getException());
            }
            switch (error.getCategory()) {
                case AUTHENTICATION_REOPEN_SESSION: {
                    this.unlink((Context)context, null);
                    break;
                }
                case AUTHENTICATION_RETRY: {
                    this.unlink((Context)context, null);
                    break;
                }
                case PERMISSION: {
                    this.unlink((Context)context, null);
                }
            }
        } else if (listener != null) {
            listener.onAfterPost(context, SocialNetwork.FACEBOOK, response.getGraphObject().getInnerJSONObject());
        }
    }

    protected void handleNotSignedIn(Activity context, SocializeListener listener) {
        String msg = "Not signed into Facebook";
        if (listener != null) {
            listener.onError(new SocializeException(msg));
        } else {
            this.handleNonListenerError(msg, new SocializeException(msg));
        }
    }

    protected void handleNotSignedIn(Activity context, SocialNetworkPostListener listener) {
        String msg = "Not signed into Facebook";
        if (listener != null) {
            listener.onNetworkError(context, SocialNetwork.FACEBOOK, new SocializeException(msg));
        } else {
            this.handleNonListenerError(msg, new SocializeException(msg));
        }
    }

    protected void handleNonListenerError(String msg, Exception error) {
        if (this.logger != null) {
            this.logger.error(msg, (Throwable)error);
        } else {
            Log.e((String)"Socialize", (String)msg, (Throwable)error);
        }
    }
}

