/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks.facebook.v2;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.facebook.HttpMethod;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.SocializeSession;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.DefaultUserProviderCredentials;
import com.socialize.auth.UserProviderCredentials;
import com.socialize.auth.UserProviderCredentialsMap;
import com.socialize.auth.facebook.FacebookDialogListener;
import com.socialize.auth.facebook.FacebookSessionStore;
import com.socialize.error.SocializeException;
import com.socialize.facebook.AsyncFacebookRunner;
import com.socialize.facebook.Facebook;
import com.socialize.facebook.FacebookError;
import com.socialize.listener.AuthProviderListener;
import com.socialize.listener.ListenerHolder;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.PostData;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.networks.SocialNetworkPostListener;
import com.socialize.networks.facebook.BaseFacebookFacade;
import com.socialize.networks.facebook.FacebookUtilsProxy;
import com.socialize.networks.facebook.OnPermissionResult;
import com.socialize.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class FacebookFacadeV2
extends BaseFacebookFacade {
    private FacebookUtilsProxy facebookUtils;
    private IBeanFactory<AsyncFacebookRunner> facebookRunnerFactory;
    private FacebookSessionStore facebookSessionStore;

    @Override
    public void onActivityResult(Activity context, int requestCode, int resultCode, Intent data) {
        this.getFacebook((Context)context).authorizeCallback(requestCode, resultCode, data);
    }

    @Override
    public int getSDKMajorVersion() {
        return 2;
    }

    @Override
    public void authenticate(Activity context, String appId, String[] permissions, boolean sso, boolean read, AuthProviderListener listener) {
        this.authenticate(context, appId, permissions, sso, listener);
    }

    @Override
    @Deprecated
    public void authenticate(final Activity context, String appId, String[] permissions, boolean sso, final AuthProviderListener listener) {
        Facebook facebook = this.getFacebook((Context)context);
        this.facebookSessionStore.restore(facebook, (Context)context);
        FacebookDialogListener facebookDialogListener = new FacebookDialogListener((Context)context, facebook, this.facebookSessionStore, listener){

            @Override
            public void onFinish() {
                context.finish();
            }

            @Override
            public void handleError(Throwable error) {
                if (listener != null) {
                    listener.onError(new SocializeException(error));
                } else {
                    error.printStackTrace();
                }
            }
        };
        if (sso) {
            facebook.authorize(context, permissions, facebookDialogListener);
        } else {
            facebook.authorize(context, permissions, -1, facebookDialogListener);
        }
    }

    @Override
    public void onResume(Activity context, SocializeAuthListener listener) {
        this.extendAccessToken(context, listener);
    }

    @Override
    public void extendAccessToken(final Activity context, final SocializeAuthListener listener) {
        block7: {
            try {
                String accessToken;
                Facebook facebook = this.getFacebook((Context)context);
                if (this.isLinked((Context)context)) {
                    if (facebook != null && !facebook.extendAccessTokenIfNeeded((Context)context, new Facebook.ServiceListener(){

                        @Override
                        public void onFacebookError(FacebookError e) {
                            if (FacebookFacadeV2.this.logger != null) {
                                FacebookFacadeV2.this.logger.warn("An error occurred while attempting to extend a Facebook access token.  The local Facebook account will be cleared.", (Throwable)e);
                            }
                            FacebookFacadeV2.this.unlink((Context)context, null);
                        }

                        @Override
                        public void onError(Error e) {
                            if (FacebookFacadeV2.this.logger != null) {
                                FacebookFacadeV2.this.logger.warn("An error occurred while attempting to extend a Facebook access token.  The local Facebook account will be cleared.", (Throwable)e);
                            }
                            FacebookFacadeV2.this.unlink((Context)context, null);
                        }

                        @Override
                        public void onComplete(Bundle values) {
                            SocializeSession session = FacebookFacadeV2.this.getSocialize().getSession();
                            if (session != null) {
                                final String newAccessToken = values.getString("access_token");
                                if (!StringUtils.isEmpty(newAccessToken)) {
                                    if (FacebookFacadeV2.this.logger != null && FacebookFacadeV2.this.logger.isDebugEnabled()) {
                                        FacebookFacadeV2.this.logger.debug("Got new Facebook access token [" + newAccessToken + "]");
                                    }
                                    FacebookFacadeV2.this.link(context, newAccessToken, false, new SocializeAuthListener(){

                                        @Override
                                        public void onError(SocializeException error) {
                                            if (FacebookFacadeV2.this.logger != null) {
                                                FacebookFacadeV2.this.logger.error("An error occurred while attempting to update authentication details", (Throwable)error);
                                            }
                                            if (listener != null) {
                                                listener.onError(error);
                                            }
                                        }

                                        @Override
                                        public void onCancel() {
                                            if (listener != null) {
                                                listener.onCancel();
                                            }
                                        }

                                        @Override
                                        public void onAuthSuccess(SocializeSession session) {
                                            UserProviderCredentialsMap map = session.getUserProviderCredentials();
                                            UserProviderCredentials creds = map.get(AuthProviderType.FACEBOOK);
                                            DefaultUserProviderCredentials newCreds = new DefaultUserProviderCredentials();
                                            if (creds != null) {
                                                newCreds.merge(creds);
                                            }
                                            newCreds.setAccessToken(newAccessToken);
                                            map.put(AuthProviderType.FACEBOOK, newCreds);
                                            FacebookFacadeV2.this.getSocialize().setSession(session);
                                            FacebookFacadeV2.this.getSocialize().saveSession((Context)context);
                                            if (listener != null) {
                                                listener.onAuthSuccess(session);
                                            }
                                        }

                                        @Override
                                        public void onAuthFail(SocializeException error) {
                                            if (FacebookFacadeV2.this.logger != null) {
                                                FacebookFacadeV2.this.logger.error("An error occurred while attempting to update authentication details", (Throwable)error);
                                            }
                                            if (listener != null) {
                                                listener.onAuthFail(error);
                                            }
                                        }
                                    });
                                } else if (FacebookFacadeV2.this.logger != null) {
                                    FacebookFacadeV2.this.logger.warn("Access token returned from Facebook was empty during request to extend");
                                }
                            }
                        }
                    }) && this.logger != null) {
                        this.logger.warn("Failed to bind to the Facebook RefreshToken Service");
                    }
                } else if (facebook != null && !StringUtils.isEmpty(accessToken = facebook.getAccessToken())) {
                    new FacebookSessionStore().clear((Context)context);
                }
            }
            catch (Exception e) {
                if (listener != null) {
                    listener.onError(SocializeException.wrap(e));
                }
                if (this.logger == null) break block7;
                this.logger.error("Failure during Facebook Token Refresh", (Throwable)e);
            }
        }
    }

    @Override
    public void post(Activity parent, SocialNetworkListener listener, PostData postData) {
        boolean okToGo = true;
        if (listener != null) {
            boolean bl = okToGo = !listener.onBeforePost(parent, SocialNetwork.FACEBOOK, postData);
        }
        if (okToGo) {
            Bundle bundle = new Bundle();
            Map<String, Object> postValues = postData.getPostValues();
            if (postValues != null) {
                Set<Map.Entry<String, Object>> entries = postValues.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    if (entry == null) continue;
                    Object value = entry.getValue();
                    String key = entry.getKey();
                    if (key == null || value == null) continue;
                    if (value instanceof byte[]) {
                        bundle.putByteArray(entry.getKey(), (byte[])value);
                        continue;
                    }
                    bundle.putString(entry.getKey(), value.toString());
                }
            }
            Facebook fb = this.getFacebook((Context)parent);
            FacebookSessionStore store = this.newFacebookSessionStore();
            store.restore(fb, (Context)parent);
            AsyncFacebookRunner runner = this.newAsyncFacebookRunner(fb);
            AsyncFacebookRunner.RequestListener requestListener = this.newRequestListener(parent, listener);
            String path = postData.getPath();
            if (StringUtils.isEmpty(path)) {
                path = "me/links";
            }
            runner.request(path, bundle, "POST", requestListener, null);
        }
    }

    @Override
    public void getCurrentPermissions(final Activity parent, String token, final OnPermissionResult callback) {
        Facebook fb = new Facebook(this.getFacebookAppId());
        fb.setAccessToken(token);
        AsyncFacebookRunner runner = this.newAsyncFacebookRunner(fb);
        runner.request("me/permissions", new AsyncFacebookRunner.RequestListener(){

            @Override
            public void onMalformedURLException(MalformedURLException e, Object state) {
                FacebookFacadeV2.this.handlePermissionError(parent, callback, e);
            }

            @Override
            public void onIOException(IOException e, Object state) {
                FacebookFacadeV2.this.handlePermissionError(parent, callback, e);
            }

            @Override
            public void onFileNotFoundException(FileNotFoundException e, Object state) {
                FacebookFacadeV2.this.handlePermissionError(parent, callback, e);
            }

            @Override
            public void onFacebookError(FacebookError e, Object state) {
                FacebookFacadeV2.this.handlePermissionError(parent, callback, e);
            }

            @Override
            public void onComplete(final String response, Object state) {
                if (callback != null) {
                    parent.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                JSONObject json = new JSONObject(response);
                                if (json.has("data") && !json.isNull("data")) {
                                    JSONObject data = json.getJSONArray("data").getJSONObject(0);
                                    JSONArray names = data.names();
                                    ArrayList<String> current = new ArrayList<String>();
                                    for (int i = 0; i < names.length(); ++i) {
                                        String permission = names.getString(i);
                                        int status = data.getInt(permission);
                                        if (status != 1) continue;
                                        current.add(permission);
                                    }
                                    Object[] values = current.toArray(new String[current.size()]);
                                    Arrays.sort(values);
                                    callback.onSuccess((String[])values);
                                }
                            }
                            catch (JSONException e) {
                                callback.onError(new SocializeException(e));
                            }
                        }
                    });
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(Context context) {
        new FacebookSessionStore().clear(context);
        Facebook mFacebook = this.getFacebook(context);
        try {
            if (mFacebook != null) {
                mFacebook.logout(context);
            }
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("Failed to log out of Facebook", (Throwable)e);
            } else {
                SocializeLogger.e("Failed to log out of Facebook", e);
            }
        }
        finally {
            if (this.facebookSessionStore != null) {
                this.facebookSessionStore.clear(context);
            }
        }
    }

    protected Facebook getFacebook(Context context) {
        return this.facebookUtils.getFacebook(context);
    }

    protected AsyncFacebookRunner newAsyncFacebookRunner(Facebook fb) {
        if (this.facebookRunnerFactory != null) {
            return (AsyncFacebookRunner)this.facebookRunnerFactory.getBean(new Object[]{fb});
        }
        return new AsyncFacebookRunner(fb);
    }

    protected FacebookSessionStore newFacebookSessionStore() {
        return new FacebookSessionStore();
    }

    protected JSONObject newJSONObject(String response) throws JSONException {
        return new JSONObject(response);
    }

    protected AsyncFacebookRunner.RequestListener newRequestListener(final Activity parent, final SocialNetworkPostListener listener) {
        String defaultErrorMessage = "Facebook Error";
        return new AsyncFacebookRunner.RequestListener(){

            @Override
            public void onMalformedURLException(MalformedURLException e, Object state) {
                FacebookFacadeV2.this.handleFacebookError(parent, 0, "Facebook Error", e, listener);
            }

            @Override
            public void onIOException(IOException e, Object state) {
                FacebookFacadeV2.this.handleFacebookError(parent, 0, "Facebook Error", e, listener);
            }

            @Override
            public void onFileNotFoundException(FileNotFoundException e, Object state) {
                FacebookFacadeV2.this.handleFacebookError(parent, 0, "Facebook Error", e, listener);
            }

            @Override
            public void onFacebookError(FacebookError e, Object state) {
                FacebookFacadeV2.this.handleFacebookError(parent, 0, "Facebook Error", e, listener);
            }

            @Override
            public void onComplete(String response, Object state) {
                JSONObject responseObject = null;
                if (!StringUtils.isEmpty(response)) {
                    try {
                        responseObject = FacebookFacadeV2.this.newJSONObject(response);
                        if (responseObject.has("error")) {
                            JSONObject error = responseObject.getJSONObject("error");
                            int code = 0;
                            if (error.has("code") && !error.isNull("code")) {
                                code = error.getInt("code");
                            }
                            if (error.has("message") && !error.isNull("message")) {
                                String msg = error.getString("message");
                                if (FacebookFacadeV2.this.logger != null) {
                                    FacebookFacadeV2.this.logger.error(msg);
                                } else {
                                    System.err.println(msg);
                                }
                                FacebookFacadeV2.this.handleFacebookError(parent, code, msg, new SocializeException(msg), listener);
                            } else {
                                FacebookFacadeV2.this.handleFacebookError(parent, code, "Facebook Error", new SocializeException("Facebook Error (Unknown)"), listener);
                            }
                            return;
                        }
                    }
                    catch (JSONException e) {
                        FacebookFacadeV2.this.onError(parent, "Facebook Error", e, listener);
                        return;
                    }
                }
                if (listener != null) {
                    final JSONObject fResponse = responseObject;
                    parent.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onAfterPost(parent, SocialNetwork.FACEBOOK, fResponse);
                        }
                    });
                }
            }
        };
    }

    @Override
    protected void doFacebookCall(Activity parent, Bundle data, String graphPath, HttpMethod method, SocialNetworkPostListener listener) {
        Facebook fb = this.getFacebook((Context)parent);
        FacebookSessionStore store = this.newFacebookSessionStore();
        store.restore(fb, (Context)parent);
        AsyncFacebookRunner runner = this.newAsyncFacebookRunner(fb);
        AsyncFacebookRunner.RequestListener requestListener = this.newRequestListener(parent, listener);
        runner.request(graphPath, data, method.toString(), requestListener, null);
    }

    public void setFacebookUtils(FacebookUtilsProxy facebookUtils) {
        this.facebookUtils = facebookUtils;
    }

    public void setFacebookRunnerFactory(IBeanFactory<AsyncFacebookRunner> facebookRunnerFactory) {
        this.facebookRunnerFactory = facebookRunnerFactory;
    }

    public void setFacebookSessionStore(FacebookSessionStore facebookSessionStore) {
        this.facebookSessionStore = facebookSessionStore;
    }

    @Override
    public void setHolder(ListenerHolder holder) {
        this.holder = holder;
    }
}

