/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks.facebook.v2;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.action.ShareType;
import com.socialize.auth.AuthProviderType;
import com.socialize.auth.facebook.FacebookSessionStore;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.Entity;
import com.socialize.entity.PropagationInfo;
import com.socialize.entity.PropagationInfoResponse;
import com.socialize.entity.Share;
import com.socialize.error.SocializeException;
import com.socialize.facebook.AsyncFacebookRunner;
import com.socialize.facebook.Facebook;
import com.socialize.facebook.FacebookError;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.DefaultPostData;
import com.socialize.networks.PostData;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.networks.SocialNetworkPostListener;
import com.socialize.networks.facebook.FacebookUtilsProxy;
import com.socialize.networks.facebook.v2.FacebookPermissionCallback;
import com.socialize.networks.facebook.v2.FacebookWallPoster;
import com.socialize.util.ImageUtils;
import com.socialize.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class DefaultFacebookWallPoster
implements FacebookWallPoster {
    private SocializeLogger logger;
    private ImageUtils imageUtils;
    private FacebookUtilsProxy facebookUtils;
    private IBeanFactory<AsyncFacebookRunner> facebookRunnerFactory;
    private SocializeConfig config;

    @Override
    public void postLike(Activity parent, Entity entity, PropagationInfo propInfo, SocialNetworkListener listener) {
        if (this.config.isOGLike()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("object", propInfo.getEntityUrl());
            this.post(parent, "me/og.likes", params, listener);
        } else {
            this.post(parent, entity, "", propInfo, listener);
        }
    }

    @Override
    public void postComment(Activity parent, Entity entity, String comment, PropagationInfo propInfo, SocialNetworkListener listener) {
        this.post(parent, entity, comment, propInfo, listener);
    }

    @Override
    public void postOG(Activity parent, Entity entity, String message, String action, PropagationInfo propInfo, SocialNetworkListener listener) {
        String entityUrl;
        String linkName = entityUrl = propInfo.getEntityUrl();
        String link = entityUrl;
        if (entity != null) {
            linkName = entity.getDisplayName();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", linkName);
        params.put("message", message);
        params.put("link", link);
        params.put("type", "link");
        DefaultPostData postData = new DefaultPostData();
        postData.setPostValues(params);
        postData.setEntity(entity);
        postData.setPropagationInfo(propInfo);
        this.post(parent, listener, postData);
    }

    @Override
    public void post(Activity parent, Entity entity, String message, PropagationInfo propInfo, SocialNetworkListener listener) {
        this.postOG(parent, entity, message, null, propInfo, listener);
    }

    @Override
    public void post(Activity parent, SocialNetworkListener listener, PostData postData) {
        boolean okToGo = true;
        if (listener != null) {
            boolean bl = okToGo = !listener.onBeforePost(parent, SocialNetwork.FACEBOOK, postData);
        }
        if (okToGo) {
            Bundle bundle = new Bundle();
            Map<String, Object> postValues = postData.getPostValues();
            if (postValues != null) {
                Set<Map.Entry<String, Object>> entries = postValues.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    if (entry == null) continue;
                    Object value = entry.getValue();
                    String key = entry.getKey();
                    if (key == null || value == null) continue;
                    if (value instanceof byte[]) {
                        bundle.putByteArray(entry.getKey(), (byte[])value);
                        continue;
                    }
                    bundle.putString(entry.getKey(), value.toString());
                }
            }
            Facebook fb = this.getFacebook((Context)parent);
            FacebookSessionStore store = this.newFacebookSessionStore();
            store.restore(fb, (Context)parent);
            AsyncFacebookRunner runner = this.newAsyncFacebookRunner(fb);
            AsyncFacebookRunner.RequestListener requestListener = this.newRequestListener(parent, listener);
            String path = postData.getPath();
            if (StringUtils.isEmpty(path)) {
                path = "me/links";
            }
            runner.request(path, bundle, "POST", requestListener, null);
        }
    }

    @Override
    public void postPhoto(Activity parent, Share share, String comment, Uri photoUri, SocialNetworkListener listener) {
        PropagationInfoResponse propagationInfoResponse = share.getPropagationInfoResponse();
        PropagationInfo propInfo = propagationInfoResponse.getPropagationInfo(ShareType.FACEBOOK);
        if (propInfo != null) {
            String link = propInfo.getAppUrl();
            String appId = this.getFacebookAppId();
            if (!StringUtils.isEmpty(appId)) {
                this.postPhoto(parent, link, comment, photoUri, listener);
            } else {
                String msg = "Cannot post message to Facebook.  No app id found.  Make sure you specify facebook.app.id in socialize.properties";
                this.onError(parent, msg, new SocializeException(msg), listener);
            }
        } else {
            String msg = "Cannot post message to Facebook.  No propagation info found";
            this.onError(parent, msg, new SocializeException(msg), listener);
        }
    }

    @Override
    public void postPhoto(Activity parent, String link, String caption, Uri photoUri, SocialNetworkListener listener) {
        try {
            Bundle params = new Bundle();
            params.putString("caption", caption + ": " + link);
            params.putByteArray("photo", this.imageUtils.scaleImage((Context)parent, photoUri));
            Facebook fb = this.getFacebook((Context)parent);
            FacebookSessionStore store = this.newFacebookSessionStore();
            store.restore(fb, (Context)parent);
            AsyncFacebookRunner runner = this.newAsyncFacebookRunner(fb);
            AsyncFacebookRunner.RequestListener requestListener = this.newRequestListener(parent, listener);
            runner.request("me/photos", params, "POST", requestListener, null);
        }
        catch (IOException e) {
            if (listener != null) {
                listener.onNetworkError(parent, SocialNetwork.FACEBOOK, e);
            }
            if (this.logger != null) {
                this.logger.error("Unable to scale image for upload", (Throwable)e);
            }
            SocializeLogger.e(e.getMessage(), e);
        }
    }

    @Override
    public void post(Activity parent, String graphPath, Map<String, Object> postData, SocialNetworkPostListener listener) {
        this.doFacebookCall(parent, postData, graphPath, "POST", listener);
    }

    @Override
    public void get(Activity parent, String graphPath, Map<String, Object> postData, SocialNetworkPostListener listener) {
        this.doFacebookCall(parent, postData, graphPath, "GET", listener);
    }

    @Override
    public void delete(Activity parent, String graphPath, Map<String, Object> postData, SocialNetworkPostListener listener) {
        this.doFacebookCall(parent, postData, graphPath, "DELETE", listener);
    }

    protected void doFacebookCall(Activity parent, Map<String, Object> postData, String graphPath, String method, SocialNetworkPostListener listener) {
        Bundle bundle = new Bundle();
        if (postData != null) {
            Set<Map.Entry<String, Object>> entries = postData.entrySet();
            for (Map.Entry<String, Object> entry : entries) {
                Object value = entry.getValue();
                if (value instanceof byte[]) {
                    bundle.putByteArray(entry.getKey(), (byte[])value);
                    continue;
                }
                bundle.putString(entry.getKey(), value.toString());
            }
        }
        this.doFacebookCall(parent, bundle, graphPath, method, listener);
    }

    @Override
    public void getCurrentPermissions(final Activity parent, String token, final FacebookPermissionCallback callback) {
        Facebook fb = new Facebook(this.getFacebookAppId());
        fb.setAccessToken(token);
        AsyncFacebookRunner runner = this.newAsyncFacebookRunner(fb);
        runner.request("me/permissions", new AsyncFacebookRunner.RequestListener(){

            @Override
            public void onMalformedURLException(MalformedURLException e, Object state) {
                DefaultFacebookWallPoster.this.handlePermissionError(parent, callback, e);
            }

            @Override
            public void onIOException(IOException e, Object state) {
                DefaultFacebookWallPoster.this.handlePermissionError(parent, callback, e);
            }

            @Override
            public void onFileNotFoundException(FileNotFoundException e, Object state) {
                DefaultFacebookWallPoster.this.handlePermissionError(parent, callback, e);
            }

            @Override
            public void onFacebookError(FacebookError e, Object state) {
                DefaultFacebookWallPoster.this.handlePermissionError(parent, callback, e);
            }

            @Override
            public void onComplete(final String response, final Object state) {
                if (callback != null) {
                    parent.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.onComplete(response, state);
                        }
                    });
                }
            }
        });
    }

    protected void handlePermissionError(Activity parent, final FacebookPermissionCallback callback, final Exception e) {
        if (callback != null) {
            parent.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    callback.onError(SocializeException.wrap(e));
                }
            });
        }
    }

    protected void doFacebookCall(Activity parent, Bundle data, String graphPath, String method, SocialNetworkPostListener listener) {
        Facebook fb = this.getFacebook((Context)parent);
        FacebookSessionStore store = this.newFacebookSessionStore();
        store.restore(fb, (Context)parent);
        AsyncFacebookRunner runner = this.newAsyncFacebookRunner(fb);
        AsyncFacebookRunner.RequestListener requestListener = this.newRequestListener(parent, listener);
        runner.request(graphPath, data, method, requestListener, null);
    }

    protected Facebook getFacebook(Context context) {
        return this.facebookUtils.getFacebook(context);
    }

    protected AsyncFacebookRunner.RequestListener newRequestListener(final Activity parent, final SocialNetworkPostListener listener) {
        String defaultErrorMessage = "Facebook Error";
        return new AsyncFacebookRunner.RequestListener(){

            @Override
            public void onMalformedURLException(MalformedURLException e, Object state) {
                DefaultFacebookWallPoster.this.handleFacebookError(parent, 0, "Facebook Error", e, listener);
            }

            @Override
            public void onIOException(IOException e, Object state) {
                DefaultFacebookWallPoster.this.handleFacebookError(parent, 0, "Facebook Error", e, listener);
            }

            @Override
            public void onFileNotFoundException(FileNotFoundException e, Object state) {
                DefaultFacebookWallPoster.this.handleFacebookError(parent, 0, "Facebook Error", e, listener);
            }

            @Override
            public void onFacebookError(FacebookError e, Object state) {
                DefaultFacebookWallPoster.this.handleFacebookError(parent, 0, "Facebook Error", e, listener);
            }

            @Override
            public void onComplete(String response, Object state) {
                JSONObject responseObject = null;
                if (!StringUtils.isEmpty(response)) {
                    try {
                        responseObject = DefaultFacebookWallPoster.this.newJSONObject(response);
                        if (responseObject.has("error")) {
                            JSONObject error = responseObject.getJSONObject("error");
                            int code = 0;
                            if (error.has("code") && !error.isNull("code")) {
                                code = error.getInt("code");
                            }
                            if (error.has("message") && !error.isNull("message")) {
                                String msg = error.getString("message");
                                if (DefaultFacebookWallPoster.this.logger != null) {
                                    DefaultFacebookWallPoster.this.logger.error(msg);
                                } else {
                                    System.err.println(msg);
                                }
                                DefaultFacebookWallPoster.this.handleFacebookError(parent, code, msg, new SocializeException(msg), listener);
                            } else {
                                DefaultFacebookWallPoster.this.handleFacebookError(parent, code, "Facebook Error", new SocializeException("Facebook Error (Unknown)"), listener);
                            }
                            return;
                        }
                    }
                    catch (JSONException e) {
                        DefaultFacebookWallPoster.this.onError(parent, "Facebook Error", e, listener);
                        return;
                    }
                }
                if (listener != null) {
                    final JSONObject fResponse = responseObject;
                    parent.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            listener.onAfterPost(parent, SocialNetwork.FACEBOOK, fResponse);
                        }
                    });
                }
            }
        };
    }

    protected void handleFacebookError(Activity parent, int code, String msg, Throwable e, SocialNetworkPostListener listener) {
        if (code == 190) {
            this.getSocialize().clear3rdPartySession((Context)parent, AuthProviderType.FACEBOOK);
        }
        this.onError(parent, msg, e, listener);
    }

    protected JSONObject newJSONObject(String response) throws JSONException {
        return new JSONObject(response);
    }

    protected AsyncFacebookRunner newAsyncFacebookRunner(Facebook fb) {
        if (this.facebookRunnerFactory != null) {
            return (AsyncFacebookRunner)this.facebookRunnerFactory.getBean(new Object[]{fb});
        }
        return new AsyncFacebookRunner(fb);
    }

    protected FacebookSessionStore newFacebookSessionStore() {
        return new FacebookSessionStore();
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    protected String getFacebookAppId() {
        return this.config.getProperty("facebook.app.id");
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    protected void onError(final Activity parent, String msg, final Throwable e, final SocialNetworkPostListener listener) {
        if (this.logger != null) {
            if (e != null) {
                this.logger.error(msg, e);
            } else {
                this.logger.error(msg);
            }
        } else if (e != null) {
            SocializeLogger.e(msg, e);
        } else {
            System.err.println(msg);
        }
        if (listener != null) {
            parent.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    listener.onNetworkError(parent, SocialNetwork.FACEBOOK, SocializeException.wrap(e));
                }
            });
        }
    }

    public void setImageUtils(ImageUtils imageUtils) {
        this.imageUtils = imageUtils;
    }

    public void setFacebookRunnerFactory(IBeanFactory<AsyncFacebookRunner> facebookRunnerFactory) {
        this.facebookRunnerFactory = facebookRunnerFactory;
    }

    public void setFacebookUtils(FacebookUtilsProxy facebookUtils) {
        this.facebookUtils = facebookUtils;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }
}

