/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetworkSignOutListener;
import com.socialize.networks.SocialNetworkSignOutTask;
import com.socialize.util.Drawables;

public class SocialNetworkSignOutClickListener
implements View.OnClickListener {
    private Drawables drawables;
    private IBeanFactory<SocialNetworkSignOutTask> signOutTaskFactory;
    private SocializeLogger logger;
    private AlertDialog dialog;
    private SocialNetworkSignOutListener listener;
    private String networkName;
    private String iconImage;

    public void onClick(View v) {
        this.dialog = this.makeDialog(v.getContext());
        this.dialog.show();
    }

    protected AlertDialog makeDialog(final Context context) {
        return new AlertDialog.Builder(context).setIcon(this.drawables == null ? null : this.drawables.getDrawable(this.iconImage)).setTitle((CharSequence)("Sign Out of " + this.networkName)).setMessage((CharSequence)("Are you sure you want to sign out of " + this.networkName + "?")).setCancelable(false).setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                SocialNetworkSignOutClickListener.this.doSignOut(context);
            }
        }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                if (SocialNetworkSignOutClickListener.this.listener != null) {
                    SocialNetworkSignOutClickListener.this.listener.onCancel();
                }
            }
        }).create();
    }

    protected void doSignOut(Context context) {
        SocialNetworkSignOutTask task = (SocialNetworkSignOutTask)this.signOutTaskFactory.getBean(new Object[]{context});
        task.setSignOutListener(this.listener);
        task.doExecute(new Void[0]);
    }

    protected AlertDialog getDialog() {
        return this.dialog;
    }

    protected SocialNetworkSignOutListener newSocialNetworkSignOutListener(final View v) {
        return new SocialNetworkSignOutListener(){

            @Override
            public void onCancel() {
            }

            @Override
            public void onSignOut() {
                SocialNetworkSignOutClickListener.this.getSocialize().saveSession(v.getContext());
            }
        };
    }

    protected void exitProfileActivity(View v) {
        Context context = v.getContext();
        if (context instanceof Activity) {
            ((Activity)context).finish();
        }
    }

    protected void logError(String msg, Exception error) {
        if (this.logger != null) {
            this.logger.error(msg, (Throwable)error);
        } else {
            SocializeLogger.e(msg, error);
        }
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    public void setDrawables(Drawables drawables) {
        this.drawables = drawables;
    }

    public void setSignOutTaskFactory(IBeanFactory<SocialNetworkSignOutTask> signOutTaskFactory) {
        this.signOutTaskFactory = signOutTaskFactory;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setListener(SocialNetworkSignOutListener listener) {
        this.listener = listener;
    }

    public void setNetworkName(String networkName) {
        this.networkName = networkName;
    }

    public void setIconImage(String iconImage) {
        this.iconImage = iconImage;
    }
}

