/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks;

import android.content.Context;
import android.view.View;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.api.SocializeSession;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.networks.SocialNetworkAuthClickListener;
import com.socialize.networks.SocialNetworkSignOutClickListener;
import com.socialize.networks.SocialNetworkSignOutListener;
import com.socialize.ui.view.CustomCheckbox;

public class SocialNetworkCheckbox
extends CustomCheckbox {
    private SocialNetworkAuthClickListener socialNetworkAuthClickListener;
    private SocialNetworkSignOutClickListener socialNetworkSignOutClickListener;
    private IBeanFactory<SocialNetworkSignOutClickListener> socialNetworkSignOutClickListenerFactory;
    private View.OnClickListener localListener = null;
    private SocializeAuthListener localAuthListener = null;
    private SocialNetworkSignOutListener localSignOutListener = null;

    public SocialNetworkCheckbox(Context context) {
        super(context);
    }

    @Override
    public void init() {
        super.init();
        this.socialNetworkSignOutClickListener = (SocialNetworkSignOutClickListener)this.socialNetworkSignOutClickListenerFactory.getBean();
        this.socialNetworkSignOutClickListener.setListener(new SocialNetworkSignOutListener(){

            @Override
            public void onSignOut() {
                SocialNetworkCheckbox.this.setChecked(false);
                if (SocialNetworkCheckbox.this.localSignOutListener != null) {
                    SocialNetworkCheckbox.this.localSignOutListener.onSignOut();
                }
            }

            @Override
            public void onCancel() {
                SocialNetworkCheckbox.this.setChecked(true);
                if (SocialNetworkCheckbox.this.localSignOutListener != null) {
                    SocialNetworkCheckbox.this.localSignOutListener.onCancel();
                }
            }
        });
        this.socialNetworkAuthClickListener.setListener(new SocializeAuthListener(){

            @Override
            public void onError(SocializeException error) {
                SocialNetworkCheckbox.this.setChecked(false);
                if (SocialNetworkCheckbox.this.localAuthListener != null) {
                    SocialNetworkCheckbox.this.localAuthListener.onError(error);
                }
            }

            @Override
            public void onCancel() {
                SocialNetworkCheckbox.this.setChecked(false);
                if (SocialNetworkCheckbox.this.localAuthListener != null) {
                    SocialNetworkCheckbox.this.localAuthListener.onCancel();
                }
            }

            @Override
            public void onAuthSuccess(SocializeSession session) {
                SocialNetworkCheckbox.this.setChecked(true);
                if (SocialNetworkCheckbox.this.localAuthListener != null) {
                    SocialNetworkCheckbox.this.localAuthListener.onAuthSuccess(session);
                }
            }

            @Override
            public void onAuthFail(SocializeException error) {
                SocialNetworkCheckbox.this.setChecked(false);
                if (SocialNetworkCheckbox.this.localAuthListener != null) {
                    SocialNetworkCheckbox.this.localAuthListener.onAuthFail(error);
                }
            }
        });
        super.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SocialNetworkCheckbox.this.isChecked()) {
                    SocialNetworkCheckbox.this.socialNetworkAuthClickListener.onClick(v);
                } else {
                    SocialNetworkCheckbox.this.socialNetworkSignOutClickListener.onClick(v);
                }
                if (SocialNetworkCheckbox.this.localListener != null) {
                    SocialNetworkCheckbox.this.localListener.onClick(v);
                }
            }
        });
    }

    public void setSignInListener(SocializeAuthListener listener) {
        this.localAuthListener = listener;
    }

    public void setSignOutListener(SocialNetworkSignOutListener localSignOutListener) {
        this.localSignOutListener = localSignOutListener;
    }

    @Override
    public void setOnClickListener(View.OnClickListener l) {
        this.localListener = l;
    }

    public void setSocialNetworkAuthClickListener(SocialNetworkAuthClickListener socialNetworkAuthClickListener) {
        this.socialNetworkAuthClickListener = socialNetworkAuthClickListener;
    }

    public void setSocialNetworkSignOutClickListenerFactory(IBeanFactory<SocialNetworkSignOutClickListener> socialNetworkSignOutClickListenerFactory) {
        this.socialNetworkSignOutClickListenerFactory = socialNetworkSignOutClickListenerFactory;
    }
}

