/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks;

import android.app.Activity;
import android.view.View;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.SocializeSession;
import com.socialize.auth.AuthProviderType;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.facebook.FacebookUtils;
import com.socialize.networks.twitter.TwitterUtils;

public abstract class SocialNetworkAuthClickListener
implements View.OnClickListener {
    private SocializeAuthListener listener;

    public void onClick(View view) {
        view.setEnabled(false);
        SocialNetwork network = this.getSocialNetwork();
        SocializeAuthListener authListener = this.getAuthListener(view);
        if (!this.getSocialize().isAuthenticatedForWrite(AuthProviderType.valueOf(network), new String[0])) {
            switch (network) {
                case FACEBOOK: {
                    FacebookUtils.linkForRead((Activity)view.getContext(), this.getAuthListener(view), new String[0]);
                    break;
                }
                case TWITTER: {
                    TwitterUtils.link((Activity)view.getContext(), this.getAuthListener(view));
                }
            }
        } else {
            authListener.onAuthSuccess(this.getSocialize().getSession());
        }
    }

    protected SocializeAuthListener getAuthListener(final View view) {
        return new SocializeAuthListener(){

            @Override
            public void onError(SocializeException error) {
                if (SocialNetworkAuthClickListener.this.listener != null) {
                    SocialNetworkAuthClickListener.this.listener.onError(error);
                }
                view.setEnabled(true);
            }

            @Override
            public void onAuthSuccess(SocializeSession session) {
                if (SocialNetworkAuthClickListener.this.listener != null) {
                    SocialNetworkAuthClickListener.this.listener.onAuthSuccess(session);
                }
                view.setEnabled(true);
            }

            @Override
            public void onAuthFail(SocializeException error) {
                if (SocialNetworkAuthClickListener.this.listener != null) {
                    SocialNetworkAuthClickListener.this.listener.onAuthFail(error);
                }
                view.setEnabled(true);
            }

            @Override
            public void onCancel() {
                if (SocialNetworkAuthClickListener.this.listener != null) {
                    SocialNetworkAuthClickListener.this.listener.onCancel();
                }
                view.setEnabled(true);
            }
        };
    }

    protected abstract SocialNetwork getSocialNetwork();

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }

    public void setListener(SocializeAuthListener listener) {
        this.listener = listener;
    }
}

