/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.networks;

import android.app.Activity;
import android.content.Context;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ActionType;
import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderInfoFactory;
import com.socialize.auth.AuthProviderType;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.Entity;
import com.socialize.entity.PropagationInfo;
import com.socialize.error.SocializeException;
import com.socialize.listener.SocializeAuthListener;
import com.socialize.log.SocializeLogger;
import com.socialize.networks.SocialNetwork;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.networks.SocialNetworkSharer;

public abstract class AbstractSocialNetworkSharer
implements SocialNetworkSharer {
    private SocializeConfig config;
    private SocializeLogger logger;
    private AuthProviderInfoFactory<AuthProviderInfo> authProviderInfoFactory;

    @Override
    public void share(final Activity context, final Entity entity, final PropagationInfo urlSet, final String comment, boolean autoAuth, final ActionType type, final SocialNetworkListener listener) {
        try {
            AuthProviderType authProviderType = AuthProviderType.valueOf(this.getNetwork());
            if (this.getSocialize().isSupported((Context)context, authProviderType)) {
                if (this.getSocialize().isAuthenticatedForWrite(authProviderType, new String[0])) {
                    this.doShare(context, entity, urlSet, comment, listener, type);
                } else if (autoAuth) {
                    String consumerKey = this.config.getProperty("socialize.consumer.key");
                    String consumerSecret = this.config.getProperty("socialize.consumer.secret");
                    AuthProviderInfo authProviderInfo = this.authProviderInfoFactory.getInstanceForWrite(new String[0]);
                    this.getSocialize().authenticate((Context)context, consumerKey, consumerSecret, authProviderInfo, new SocializeAuthListener(){

                        @Override
                        public void onError(SocializeException error) {
                            AbstractSocialNetworkSharer.this.doError(error, context, listener);
                        }

                        @Override
                        public void onAuthSuccess(SocializeSession session) {
                            try {
                                AbstractSocialNetworkSharer.this.doShare(context, entity, urlSet, comment, listener, type);
                            }
                            catch (SocializeException e) {
                                AbstractSocialNetworkSharer.this.doError(SocializeException.wrap(e), context, listener);
                            }
                        }

                        @Override
                        public void onAuthFail(SocializeException error) {
                            AbstractSocialNetworkSharer.this.doError(error, context, listener);
                        }

                        @Override
                        public void onCancel() {
                        }
                    });
                } else {
                    SocializeException error = new SocializeException("User is not authenticated with [" + this.getNetwork().name() + "]");
                    if (this.logger != null) {
                        this.logger.error("Error during share", (Throwable)error);
                    } else {
                        SocializeLogger.e(error.getMessage(), error);
                    }
                    if (listener != null) {
                        listener.onNetworkError(context, this.getNetwork(), error);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.doError(SocializeException.wrap(e), context, listener);
        }
    }

    protected void doError(SocializeException e, Activity parent, SocialNetworkListener listener) {
        String msg = "Error sharing to " + this.getNetwork().name();
        if (this.logger != null) {
            this.logger.error(msg, (Throwable)e);
        } else {
            SocializeLogger.e(msg, e);
        }
        if (listener != null) {
            listener.onNetworkError(parent, this.getNetwork(), e);
        }
    }

    protected abstract SocialNetwork getNetwork();

    protected abstract void doShare(Activity var1, Entity var2, PropagationInfo var3, String var4, SocialNetworkListener var5, ActionType var6) throws SocializeException;

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setAuthProviderInfoFactory(AuthProviderInfoFactory<AuthProviderInfo> authProviderInfoFactory) {
        this.authProviderInfoFactory = authProviderInfoFactory;
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }
}

