/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.loopy;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import com.sharethis.loopy.sdk.Item;
import com.sharethis.loopy.sdk.Loopy;
import com.sharethis.loopy.sdk.ShareCallback;
import com.sharethis.loopy.sdk.ShareDialogListener;
import com.sharethis.loopy.sdk.util.StringUtils;
import com.socialize.api.action.ShareType;
import com.socialize.config.SocializeConfig;
import com.socialize.entity.DefaultPropagationInfo;
import com.socialize.entity.Entity;
import com.socialize.entity.PropagationInfo;
import com.socialize.networks.PostData;
import com.socialize.networks.SocialNetworkListener;
import com.socialize.share.SharePostDataFactory;

public class LoopyService {
    private SocializeConfig config;
    private SharePostDataFactory sharePostDataFactory;

    public boolean isLoopyEnabled() {
        return this.config.isLoopyEnabled();
    }

    public SocializeConfig getConfig() {
        return this.config;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    public void setSharePostDataFactory(SharePostDataFactory sharePostDataFactory) {
        this.sharePostDataFactory = sharePostDataFactory;
    }

    public void onStop(Activity context) {
        if (this.config.isLoopyEnabled()) {
            Loopy.onStop((Context)context);
        }
    }

    public void onStart(Activity context) {
        if (this.config.isLoopyEnabled()) {
            Loopy.onStart((Context)context);
        }
    }

    public void onCreate(Activity context) {
        if (this.config.isLoopyEnabled()) {
            Loopy.onCreate((Context)context, (String)this.config.getProperty("socialize.consumer.key"), (String)this.config.getProperty("socialize.consumer.secret"));
        }
    }

    public void onDestroy(Activity context) {
        if (this.config.isLoopyEnabled()) {
            Loopy.onDestroy((Context)context);
        }
    }

    public PropagationInfo setShortlinks(PropagationInfo propagationInfo, Item item, Throwable error) {
        PropagationInfo infoInUse = propagationInfo;
        if (error == null && !StringUtils.isEmpty((String)item.getShortlink())) {
            DefaultPropagationInfo dpi = new DefaultPropagationInfo();
            dpi.setAppUrl(infoInUse.getAppUrl());
            dpi.setEntityUrl(item.getShortlink());
            infoInUse = dpi;
        }
        return infoInUse;
    }

    public void getTrackableUrl(Entity entity, ShareType shareType, String url, ShareCallback callback) {
        Item item = this.toItem(entity, url);
        Loopy.shareAndLink((Item)item, (String)shareType.getDisplayName(), (ShareCallback)callback);
    }

    public void showShareDialog(final Activity context, String title, final String text, final Entity entity, final PropagationInfo info, final SocialNetworkListener listener) {
        Item item = this.toItem(entity, info.getEntityUrl());
        Intent intent = new Intent("android.intent.action.SEND");
        Loopy.showShareDialog((Context)context, (String)title, (Item)item, (Intent)intent, (ShareDialogListener)new ShareDialogListener(){
            boolean shareCancelled = false;

            public void onLinkGenerated(Item item, Intent shareIntent, Throwable error) {
                PropagationInfo loopyInfo = LoopyService.this.setShortlinks(info, item, error);
                PostData postData = LoopyService.this.sharePostDataFactory.create(entity, loopyInfo, text, false, true);
                if (listener != null) {
                    this.shareCancelled = listener.onBeforePost(context, null, postData);
                }
                String title = String.valueOf(postData.getPostValues().get("title"));
                String body = String.valueOf(postData.getPostValues().get("text"));
                String subject = String.valueOf(postData.getPostValues().get("subject"));
                shareIntent.putExtra("android.intent.extra.TITLE", title);
                shareIntent.putExtra("android.intent.extra.TEXT", body);
                shareIntent.putExtra("android.intent.extra.SUBJECT", subject);
            }

            public void onShow(DialogInterface dialog) {
                if (listener != null) {
                    listener.onAfterPost(context, null, null);
                }
                super.onShow(dialog);
            }
        });
    }

    Item toItem(Entity entity, String url) {
        Item item = new Item();
        item.setUrl(url);
        item.setTitle(entity.getDisplayName());
        item.setType(entity.getType());
        return item;
    }
}

