/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.log;

import android.content.Context;
import android.util.Log;
import com.socialize.config.SocializeConfig;
import com.socialize.log.AsyncSDCardExternalLogger;
import com.socialize.log.ExternalLogger;
import com.socialize.util.StringUtils;

public class SocializeLogger {
    public static String LOG_TAG = "Socialize";
    public static final int INITIALIZE_FAILED = 0;
    public static final int NOT_INITIALIZED = 1;
    public static final int NOT_AUTHENTICATED = 2;
    public static final int NO_CONFIG = 3;
    public static final int NO_UDID = 4;
    public static final int ERROR_CODE_LOAD_FAIL = 5;
    private LogLevel logLevel = LogLevel.WARN;
    private SocializeConfig config;
    private boolean logThread = true;
    private boolean initialized = false;
    private ExternalLogger externalLogger;

    public SocializeLogger() {
    }

    public SocializeLogger(LogLevel level) {
        this.logLevel = level;
    }

    public void init(Context context, SocializeConfig config) {
        String tag;
        if (config.isDiagnosticLoggingEnabled() && this.externalLogger == null) {
            this.externalLogger = this.newExternalLogger();
            this.externalLogger.init(context);
        }
        String ll = config.getProperty("log.level");
        this.logThread = config.getBooleanProperty("log.thread", true);
        if (!StringUtils.isEmpty(ll)) {
            this.logLevel = LogLevel.valueOf(ll);
        }
        if (!StringUtils.isEmpty(tag = config.getProperty("log.tag"))) {
            LOG_TAG = tag;
        }
        this.config = config;
        this.initialized = true;
    }

    protected ExternalLogger newExternalLogger() {
        return new AsyncSDCardExternalLogger();
    }

    public void destroy() {
        if (this.externalLogger != null) {
            this.externalLogger.destroy();
            this.externalLogger = null;
        }
    }

    public ExternalLogger getExternalLogger() {
        return this.externalLogger;
    }

    public void setExternalLogger(ExternalLogger externalLogger) {
        this.externalLogger = externalLogger;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void debug(int messageId) {
        this.debug(this.getMessage(messageId));
    }

    public void info(int messageId) {
        this.info(this.getMessage(messageId));
    }

    public void warn(int messageId) {
        this.warn(this.getMessage(messageId));
    }

    public void error(int messageId) {
        this.error(this.getMessage(messageId));
    }

    public void warn(int messageId, Throwable error) {
        this.warn(this.getMessage(messageId), error);
    }

    public void error(int messageId, Throwable error) {
        this.error(this.getMessage(messageId), error);
    }

    public void debug(String msg) {
        msg = this.getMessage(msg);
        SocializeLogger.d(msg);
        if (this.externalLogger != null && this.externalLogger.canWrite()) {
            this.externalLogger.log(LogLevel.DEBUG, System.currentTimeMillis(), LOG_TAG, msg);
        }
    }

    public void debug(String msg, Throwable error) {
        msg = this.getMessage(msg);
        SocializeLogger.d(msg, error);
        if (this.externalLogger != null && this.externalLogger.canWrite()) {
            this.externalLogger.log(LogLevel.DEBUG, System.currentTimeMillis(), LOG_TAG, msg);
        }
    }

    public void info(String msg) {
        msg = this.getMessage(msg);
        SocializeLogger.i(msg);
        if (this.externalLogger != null && this.externalLogger.canWrite()) {
            this.externalLogger.log(LogLevel.INFO, System.currentTimeMillis(), LOG_TAG, msg);
        }
    }

    public void warn(String msg) {
        msg = this.getMessage(msg);
        SocializeLogger.w(msg);
        if (this.externalLogger != null && this.externalLogger.canWrite()) {
            this.externalLogger.log(LogLevel.WARN, System.currentTimeMillis(), LOG_TAG, msg);
        }
    }

    public void error(String msg) {
        msg = this.getMessage(msg);
        SocializeLogger.e(msg);
        if (this.externalLogger != null && this.externalLogger.canWrite()) {
            this.externalLogger.log(LogLevel.ERROR, System.currentTimeMillis(), LOG_TAG, msg);
        }
    }

    public void warn(String msg, Throwable error) {
        msg = this.getMessage(msg);
        SocializeLogger.w(msg, error);
        if (this.externalLogger != null && this.externalLogger.canWrite()) {
            this.externalLogger.log(LogLevel.WARN, System.currentTimeMillis(), LOG_TAG, msg, error);
        }
    }

    public void error(String msg, Throwable error) {
        msg = this.getMessage(msg);
        SocializeLogger.e(msg, error);
        if (this.externalLogger != null && this.externalLogger.canWrite()) {
            this.externalLogger.log(LogLevel.ERROR, System.currentTimeMillis(), LOG_TAG, msg, error);
        }
    }

    public boolean isVerboseEnabled() {
        return this.logLevel.ordinal() <= LogLevel.VERBOSE.ordinal();
    }

    public boolean isDebugEnabled() {
        return this.logLevel.ordinal() <= LogLevel.DEBUG.ordinal();
    }

    public boolean isInfoEnabled() {
        return this.logLevel.ordinal() <= LogLevel.INFO.ordinal();
    }

    public boolean isWarnEnabled() {
        return this.logLevel.ordinal() <= LogLevel.WARN.ordinal();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected String getMessage(String message) {
        if (this.logThread) {
            return "Thread[" + Thread.currentThread().getName() + "]: " + message;
        }
        return message;
    }

    public String getMessage(int id) {
        if (this.config != null) {
            String msg = this.config.getProperty("log.msg." + id);
            if (msg == null) {
                msg = "";
            }
            return this.getMessage(msg);
        }
        return this.getMessage("Log System Error!  The log system has not been initialized correctly.  No config found.");
    }

    public boolean isLogThread() {
        return this.logThread;
    }

    public void setLogThread(boolean logThread) {
        this.logThread = logThread;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public static void d(String msg) {
        Log.d((String)LOG_TAG, (String)msg);
    }

    public static void d(String msg, Throwable error) {
        Log.d((String)LOG_TAG, (String)msg, (Throwable)error);
    }

    public static void i(String msg) {
        Log.i((String)LOG_TAG, (String)msg);
    }

    public static void e(String msg, Throwable error) {
        Log.e((String)LOG_TAG, (String)msg, (Throwable)error);
    }

    public static void e(String msg) {
        Log.e((String)LOG_TAG, (String)msg);
    }

    public static void w(String msg, Throwable error) {
        Log.w((String)LOG_TAG, (String)msg, (Throwable)error);
    }

    public static void w(String msg) {
        Log.w((String)LOG_TAG, (String)msg);
    }

    public static enum LogLevel {
        VERBOSE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

