/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.log;

import android.content.Context;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import com.socialize.log.ExternalLogger;
import com.socialize.log.SocializeLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class SDCardExternalLogger
implements ExternalLogger {
    private static final String TAG = SDCardExternalLogger.class.getSimpleName();
    private static final String LOG_FILE_NAME = "socialize.log";
    private PrintWriter writer;
    private boolean canWrite = true;

    @Override
    public boolean canWrite() {
        return this.canWrite;
    }

    @Override
    public void init(Context context) {
        boolean bl = this.canWrite = context.getPackageManager().checkPermission("android.permission.WRITE_EXTERNAL_STORAGE", context.getPackageName()) == 0;
        if (this.canWrite) {
            this.createWriter(context, LOG_FILE_NAME);
        }
    }

    @Override
    public void destroy() {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public void log(SocializeLogger.LogLevel level, long time, String tag, String message) {
        if (this.writer != null) {
            this.writer.print(String.valueOf(time));
            this.writer.print(" ");
            this.writer.print(level.toString());
            this.writer.print(" ");
            this.writer.print(tag);
            this.writer.print(" ");
            this.writer.print(Thread.currentThread().getName());
            this.writer.print(" - ");
            this.writer.println(message);
        }
    }

    @Override
    public final void log(SocializeLogger.LogLevel level, long time, String tag, String message, Throwable error) {
        if (error != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(message).append(": ").append(this.stackTraceToString(error));
            this.log(level, time, TAG, builder.toString());
        }
        this.log(level, time, tag, message);
    }

    public static Set<Uri> getExternalLogFilePaths(Context context) {
        File[] list;
        File dir = SDCardExternalLogger.getLogFilePath(context);
        HashSet<Uri> files = new HashSet<Uri>();
        if (dir.exists() && (list = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".log");
            }
        })) != null) {
            for (File file : list) {
                files.add(Uri.fromFile((File)file));
            }
        }
        return files;
    }

    public static void clearExternalLogFiles(Context context) {
        File[] list;
        File dir = SDCardExternalLogger.getLogFilePath(context);
        if (dir.exists() && (list = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".log");
            }
        })) != null) {
            for (File file : list) {
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
    }

    private static File getLogFilePath(Context context) {
        return new File(Environment.getExternalStorageDirectory(), "socialize-" + context.getPackageName());
    }

    private PrintWriter createWriter(Context context, String logFilename) {
        try {
            this.destroy();
            String state = Environment.getExternalStorageState();
            if (state.equals("mounted")) {
                File log;
                File dir = SDCardExternalLogger.getLogFilePath(context);
                if (!dir.mkdirs()) {
                    Log.w((String)TAG, (String)("Could not create log directory: " + dir.getAbsolutePath()));
                }
                if ((log = new File(dir, logFilename)).exists()) {
                    log.delete();
                }
                Log.i((String)TAG, (String)("Opening " + log.getAbsolutePath()));
                this.writer = new PrintWriter((Writer)new FileWriter(log), true);
                return this.writer;
            }
            Log.w((String)TAG, (String)("Could not create log file because external storage state was " + state));
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)"Failed while opening the log file.", (Throwable)ioe);
        }
        return null;
    }

    String stackTraceToString(Throwable error) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        error.printStackTrace(pw);
        try {
            pw.flush();
            return new String(out.toByteArray(), "utf-8");
        }
        catch (Exception ignore) {
            error.printStackTrace();
            ignore.printStackTrace();
            return "";
        }
    }
}

