/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.location;

import android.app.Activity;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import com.socialize.util.AppUtils;

public class SocializeLocationManager {
    LocationManager lm = null;
    private AppUtils appUtils;

    public SocializeLocationManager(AppUtils deviceUtils) {
        this.appUtils = deviceUtils;
    }

    public void init(Context context) {
        if (this.appUtils.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION") || this.appUtils.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION")) {
            this.lm = (LocationManager)context.getSystemService("location");
        }
    }

    public String getBestProvider(Criteria criteria, boolean enabledOnly) {
        return this.lm == null ? null : this.lm.getBestProvider(criteria, enabledOnly);
    }

    public Location getLastKnownLocation(String provider) {
        return this.lm == null ? null : this.lm.getLastKnownLocation(provider);
    }

    public boolean isProviderEnabled(String provider) {
        return this.lm == null ? false : this.lm.isProviderEnabled(provider);
    }

    public void requestLocationUpdates(Activity activity, final String provider, final long minTime, final float minDistance, final LocationListener listener) {
        if (this.lm != null) {
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    SocializeLocationManager.this.lm.requestLocationUpdates(provider, minTime, minDistance, listener);
                }
            });
        }
    }

    public void removeUpdates(LocationListener listener) {
        if (this.lm != null && listener != null) {
            this.lm.removeUpdates(listener);
        }
    }
}

