/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.launcher;

import com.socialize.launcher.LaunchAction;
import com.socialize.launcher.LaunchManager;
import com.socialize.launcher.Launcher;
import com.socialize.log.SocializeLogger;
import java.util.Map;

public class SocializeLaunchManager
implements LaunchManager {
    private Map<String, Launcher> launchers;
    private SocializeLogger logger;

    @Override
    public Launcher getLaucher(String action) {
        try {
            return this.getLaucher(LaunchAction.valueOf(action));
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("Launch action [" + action + "] provided is not a known action", (Throwable)e);
            } else {
                SocializeLogger.e(e.getMessage(), e);
            }
            return null;
        }
    }

    @Override
    public Launcher getLaucher(LaunchAction action) {
        if (this.launchers != null) {
            return this.launchers.get(action.name());
        }
        return null;
    }

    public void setLaunchers(Map<String, Launcher> launchers) {
        this.launchers = launchers;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

