/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.launcher;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import com.socialize.CommentUtils;
import com.socialize.api.SocializeSession;
import com.socialize.api.action.ActionType;
import com.socialize.api.action.activity.ActivitySystem;
import com.socialize.entity.SocializeAction;
import com.socialize.error.SocializeException;
import com.socialize.launcher.BaseLauncher;
import com.socialize.log.SocializeLogger;
import com.socialize.notifications.NotificationAuthenticator;
import com.socialize.util.EntityLoaderUtils;
import com.socialize.util.StringUtils;

public class CommentListLauncher
extends BaseLauncher {
    private EntityLoaderUtils entityLoaderUtils;
    private SocializeLogger logger;
    private ActivitySystem activitySystem;
    private NotificationAuthenticator notificationAuthenticator;

    @Override
    public boolean launch(Activity context, Bundle data) {
        if (this.entityLoaderUtils != null) {
            this.entityLoaderUtils.initEntityLoader();
        }
        Object idObj = data.get("socialize.action.id");
        String actionType = data.getString("socialize.action.type");
        if (idObj != null && !StringUtils.isEmpty(actionType)) {
            long id = Long.parseLong(idObj.toString());
            try {
                ActionType type = ActionType.valueOf(actionType);
                SocializeSession session = this.notificationAuthenticator.authenticate((Context)context);
                SocializeAction action = this.activitySystem.getAction(session, id, type);
                if (action != null) {
                    CommentUtils.showCommentView(context, action.getEntity());
                    return true;
                }
                this.handleWarn("No action found for id [" + id + "].");
            }
            catch (SocializeException e) {
                this.handleError("Failed to load entity", e);
            }
        } else {
            this.handleWarn("No action id found.  Action based notification cannot be handled");
        }
        return false;
    }

    protected void handleError(String msg, Exception e) {
        if (this.logger != null) {
            this.logger.error(msg, (Throwable)e);
        } else {
            SocializeLogger.e(e.getMessage(), e);
        }
    }

    protected void handleWarn(String msg) {
        if (this.logger != null) {
            this.logger.warn(msg);
        } else {
            System.err.println(msg);
        }
    }

    public void setEntityLoaderUtils(EntityLoaderUtils entityLoaderUtils) {
        this.entityLoaderUtils = entityLoaderUtils;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    public void setActivitySystem(ActivitySystem activitySystem) {
        this.activitySystem = activitySystem;
    }

    public void setNotificationAuthenticator(NotificationAuthenticator notificationAuthenticator) {
        this.notificationAuthenticator = notificationAuthenticator;
    }
}

