/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.launcher;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.socialize.launcher.BaseLauncher;
import com.socialize.util.AppUtils;
import com.socialize.util.EntityLoaderUtils;

public abstract class ActivityLauncher
extends BaseLauncher {
    private AppUtils appUtils;
    private EntityLoaderUtils entityLoaderUtils;

    @Override
    public boolean launch(Activity context, Bundle data) {
        if (this.entityLoaderUtils != null) {
            this.entityLoaderUtils.initEntityLoader();
        }
        Class<?>[] activityClasses = this.getActivityClasses();
        Class<?> activityClass = null;
        for (Class<?> cls : activityClasses) {
            if (!this.appUtils.isActivityAvailable((Context)context, cls)) continue;
            activityClass = cls;
            break;
        }
        if (activityClass != null) {
            Intent intent = this.newIntent(context, activityClass);
            intent.putExtras(data);
            this.handleIntent(context, intent, data);
            context.startActivity(intent);
            return true;
        }
        return false;
    }

    public void setAppUtils(AppUtils appUtils) {
        this.appUtils = appUtils;
    }

    public void setEntityLoaderUtils(EntityLoaderUtils entityLoaderUtils) {
        this.entityLoaderUtils = entityLoaderUtils;
    }

    protected Intent newIntent(Activity context, Class<?> activityClass) {
        return new Intent((Context)context, activityClass);
    }

    protected void handleIntent(Activity context, Intent intent, Bundle data) {
    }

    public abstract Class<?>[] getActivityClasses();
}

