/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.launcher;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.socialize.ConfigUtils;
import com.socialize.Socialize;
import com.socialize.SocializeService;
import com.socialize.config.SocializeConfig;
import com.socialize.launcher.BaseLauncher;
import com.socialize.launcher.Launcher;
import com.socialize.log.SocializeLogger;

public class ActionDelegateLauncher
extends BaseLauncher {
    private Launcher actionLauncher;
    private Launcher commentListLauncher;
    private SocializeLogger logger;

    @Override
    public boolean launch(Activity context, Bundle data) {
        return this.getLauncher((Context)context).launch(context, data);
    }

    @Override
    public void onResult(Activity context, int requestCode, int resultCode, Intent returnedIntent, Intent originalIntent) {
        this.getLauncher((Context)context).onResult(context, requestCode, resultCode, returnedIntent, originalIntent);
    }

    @Override
    public boolean shouldFinish(Activity context) {
        return this.getLauncher((Context)context).shouldFinish(context);
    }

    public void setActionLauncher(Launcher actionLauncher) {
        this.actionLauncher = actionLauncher;
    }

    public void setCommentListLauncher(Launcher commentListLauncher) {
        this.commentListLauncher = commentListLauncher;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    protected Launcher getLauncher(Context context) {
        try {
            if (this.getConfig(context).getBooleanProperty("socialize.comments.on.notify", false)) {
                return this.commentListLauncher;
            }
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("Failed to inspect socialize config", (Throwable)e);
            }
            SocializeLogger.e(e.getMessage(), e);
        }
        return this.actionLauncher;
    }

    protected SocializeConfig getConfig(Context context) {
        return ConfigUtils.getConfig(context);
    }

    protected SocializeService getSocialize() {
        return Socialize.getSocialize();
    }
}

