/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.i18n;

import android.content.Context;
import com.socialize.i18n.LocalizationService;
import com.socialize.log.SocializeLogger;
import com.socialize.util.ResourceLocator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class DefaultLocalizationService
implements LocalizationService {
    private ResourceLocator resourceLocator;
    private Properties properties;
    private SocializeLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Context context) {
        InputStream in = null;
        try {
            this.properties = this.createProperties();
            in = this.resourceLocator.locate(context, "i18n.properties");
            this.properties.load(in);
        }
        catch (Exception e) {
            if (this.logger != null) {
                this.logger.error("Failure loading i18n resources", (Throwable)e);
            } else {
                e.printStackTrace();
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignore) {
                    ignore.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getString(String key) {
        if (this.properties != null) {
            String property = this.properties.getProperty(key);
            if (property == null) {
                return key;
            }
            return property;
        }
        return null;
    }

    public void setResourceLocator(ResourceLocator resourceLocator) {
        this.resourceLocator = resourceLocator;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    protected Properties createProperties() {
        return new Properties();
    }
}

