/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.i18n;

import android.content.Context;
import android.content.res.Resources;
import com.socialize.i18n.LocalizationService;
import com.socialize.util.StringUtils;
import java.util.Map;
import java.util.TreeMap;

public class CustomLocalizationService
implements LocalizationService {
    private static final Map<String, String> strings = new TreeMap<String, String>();
    private String packageName;
    private LocalizationService defaultLocalizationService;
    private Resources resources;

    public void init(Context context) {
        this.packageName = context.getPackageName();
        this.resources = context.getResources();
    }

    @Override
    public String getString(String key) {
        if (key == null) {
            return "";
        }
        String str = strings.get(key);
        if (StringUtils.isEmpty(str)) {
            int resId = this.resources.getIdentifier(key, "string", this.packageName);
            if (resId > 0) {
                try {
                    str = this.resources.getString(resId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (str == null) {
                str = this.defaultLocalizationService.getString(key);
            }
            if (str != null) {
                strings.put(key, str);
            } else {
                str = key;
            }
        }
        return str;
    }

    public void setDefaultLocalizationService(LocalizationService defaultLocalizationService) {
        this.defaultLocalizationService = defaultLocalizationService;
    }
}

