/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.api.action.ShareType;
import com.socialize.entity.DefaultPropagationInfo;
import com.socialize.entity.JSONFactory;
import com.socialize.entity.PropagationInfoResponse;
import com.socialize.log.SocializeLogger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PropagationInfoResponseFactory
extends JSONFactory<PropagationInfoResponse> {
    private SocializeLogger logger;

    @Override
    public Object instantiateObject(JSONObject object) {
        return new PropagationInfoResponse();
    }

    @Override
    protected void fromJSON(JSONObject from, PropagationInfoResponse to) throws JSONException {
        JSONArray names = from.names();
        if (names != null) {
            int length = names.length();
            for (int i = 0; i < length; ++i) {
                String name = names.get(i).toString().trim();
                try {
                    ShareType network = ShareType.valueOf(name.toUpperCase());
                    JSONObject jsonObject = this.getJSONObject(from, name);
                    if (jsonObject == null) continue;
                    DefaultPropagationInfo set = new DefaultPropagationInfo();
                    set.setAppUrl(this.getString(jsonObject, "application_url"));
                    set.setEntityUrl(this.getString(jsonObject, "entity_url"));
                    to.addUrlSet(network, set);
                    continue;
                }
                catch (Exception ignore) {
                    if (this.logger == null) continue;
                    this.logger.error("Invalid share type [" + name + "]");
                }
            }
        }
    }

    @Override
    protected void toJSON(PropagationInfoResponse from, JSONObject to) throws JSONException {
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }
}

