/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.entity.Comment;
import com.socialize.entity.SocializeActionFactory;
import com.socialize.util.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class CommentFactory
extends SocializeActionFactory<Comment> {
    @Override
    protected void postFromJSON(JSONObject object, Comment comment) throws JSONException {
        String attr = "text";
        String notificationAttr = "subscribe";
        if (object.has("text") && !object.isNull("text")) {
            comment.setText(object.getString("text"));
        } else if (this.logger != null && this.logger.isWarnEnabled()) {
            this.logger.warn("Attribute [text] not found in [" + comment.getClass().getSimpleName() + "]");
        }
        if (object.has("subscribe") && !object.isNull("subscribe")) {
            comment.setNotificationsEnabled(object.getBoolean("subscribe"));
        }
    }

    @Override
    protected void postToJSON(Comment comment, JSONObject object) throws JSONException {
        String text = comment.getText();
        if (!StringUtils.isEmpty(text)) {
            object.put("text", (Object)text);
        }
        object.put("subscribe", comment.isNotificationsEnabled());
    }

    @Override
    public Object instantiateObject(JSONObject object) {
        return new Comment();
    }
}

