/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.entity;

import com.socialize.entity.Entity;
import com.socialize.entity.EntityStatsImpl;
import com.socialize.entity.SocializeObjectFactory;
import com.socialize.entity.UserEntityStatsImpl;
import com.socialize.util.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractEntityFactory<T extends Entity>
extends SocializeObjectFactory<T> {
    private static final String LIKES = "likes";
    private static final String SHARES = "shares";
    private static final String COMMENTS = "comments";
    private static final String VIEWS = "views";
    private static final String TOTAL = "total_activity";
    private static final String USER_ACTION_SUMMARY = "user_action_summary";

    @Override
    protected void postFromJSON(JSONObject object, T entry) throws JSONException {
        ((Entity)entry).setName(this.getString(object, "name"));
        ((Entity)entry).setKey(this.getString(object, "key"));
        ((Entity)entry).setMetaData(this.getString(object, "meta"));
        ((Entity)entry).setType(this.getString(object, "type"));
        EntityStatsImpl stats = this.newEntityStatsImpl();
        stats.setLikes(this.getInt(object, LIKES));
        stats.setShares(this.getInt(object, SHARES));
        stats.setComments(this.getInt(object, COMMENTS));
        stats.setViews(this.getInt(object, VIEWS));
        stats.setTotalActivityCount(this.getInt(object, TOTAL));
        ((Entity)entry).setEntityStats(stats);
        if (object.has(USER_ACTION_SUMMARY) && !object.isNull(USER_ACTION_SUMMARY)) {
            JSONObject userStats = object.getJSONObject(USER_ACTION_SUMMARY);
            UserEntityStatsImpl userEntityStats = this.newUserEntityStatsImpl();
            userEntityStats.setComments(this.getInt(userStats, COMMENTS));
            userEntityStats.setShares(this.getInt(userStats, SHARES));
            int liked = this.getInt(userStats, LIKES);
            userEntityStats.setLiked(liked > 0);
            ((Entity)entry).setUserEntityStats(userEntityStats);
        }
    }

    @Override
    protected void postToJSON(T entry, JSONObject object) throws JSONException {
        String name = ((Entity)entry).getName();
        String key = ((Entity)entry).getKey();
        String meta = ((Entity)entry).getMetaData();
        String type = ((Entity)entry).getType();
        if (!StringUtils.isEmpty(name)) {
            object.put("name", (Object)name);
        }
        if (!StringUtils.isEmpty(key)) {
            object.put("key", (Object)key);
        }
        if (!StringUtils.isEmpty(type)) {
            object.put("type", (Object)type);
        }
        if (!StringUtils.isEmpty(meta)) {
            object.put("meta", (Object)meta);
        } else {
            object.put("meta", (Object)"");
        }
    }

    protected EntityStatsImpl newEntityStatsImpl() {
        return new EntityStatsImpl();
    }

    protected UserEntityStatsImpl newUserEntityStatsImpl() {
        return new UserEntityStatsImpl();
    }
}

