/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.cache;

import com.socialize.cache.ICacheEventListener;
import com.socialize.cache.ICacheable;
import com.socialize.cache.ICacheableFactory;
import com.socialize.cache.ISuicidal;
import com.socialize.cache.Key;
import com.socialize.cache.TTLObject;
import com.socialize.log.SocializeLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;

public class TTLCache<K extends Comparable<K>, E extends ICacheable<K>> {
    public static int DEFAULT_CACHE_COUNT = 1000;
    private TreeMap<Key<K>, TTLObject<K, E>> objects;
    private Map<K, Key<K>> keys;
    private SocializeLogger logger;
    private boolean debug = false;
    private boolean extendOnGet = true;
    private long reapCycle = 60000L;
    private long defaultTTL = 3600000L;
    private int maxCapacity = -1;
    private long maxCapacityBytes = -1L;
    private long currentSizeInBytes = 0L;
    private boolean hardByteLimit = false;
    private ICacheEventListener<K, E> eventListener;
    protected ICacheableFactory<K, E> objectFactory;
    private static Timer reapTimer;
    private Reaper reaper;
    private boolean reaping = false;

    public TTLCache() {
        this(10, DEFAULT_CACHE_COUNT);
    }

    public TTLCache(int initialCapacity) {
        this(initialCapacity, DEFAULT_CACHE_COUNT);
    }

    public TTLCache(int initialCapacity, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.objects = this.makeMap();
        this.keys = new HashMap<K, Key<K>>(initialCapacity);
        this.startReaper();
    }

    public void destroy() {
        this.stopReaper();
        this.clear(true);
    }

    public void clear() {
        this.clear(false);
    }

    public void pause() {
        this.stopReaper();
    }

    public void resume() {
        this.startReaper();
    }

    protected synchronized void clear(boolean destroy) {
        this.keys.clear();
        Collection<TTLObject<K, E>> values = this.objects.values();
        for (TTLObject<K, E> ttlObject : values) {
            ttlObject.getObject().onRemove(destroy);
        }
        this.objects.clear();
        this.currentSizeInBytes = 0L;
    }

    public void setReapCycle(long milliseconds) {
        this.reapCycle = milliseconds;
        this.startReaper();
    }

    protected synchronized void startReaper() {
        this.stopReaper();
        if (this.reapCycle > 0L) {
            this.reaper = new Reaper();
            if (reapTimer == null) {
                reapTimer = new Timer("CacheReaper", true);
            }
            reapTimer.schedule((TimerTask)this.reaper, this.reapCycle, this.reapCycle);
        }
    }

    protected synchronized void stopReaper() {
        if (this.reaper != null) {
            this.reaper.cancel();
            this.reaper = null;
        }
        if (reapTimer != null) {
            reapTimer.purge();
        }
        this.reaping = false;
    }

    public boolean put(K strKey, E object, long ttl) {
        return this.put(strKey, object, ttl, false);
    }

    public boolean put(K strKey, E object, boolean eternal) {
        return this.put(strKey, object, this.defaultTTL, eternal);
    }

    public boolean put(K strKey, E object) {
        return this.put(strKey, object, this.defaultTTL, this.defaultTTL <= 0L);
    }

    protected synchronized boolean put(K k, E object, long ttl, boolean eternal) {
        if (this.exists(k)) {
            TTLObject<K, E> ttlObject = this.getTTLObject(k);
            Key<K> key = this.keys.get(k);
            key.setTime(System.currentTimeMillis());
            ttlObject.setEternal(eternal);
            ttlObject.extendLife(ttl);
            ttlObject.setObject(object);
            if (this.eventListener != null) {
                this.eventListener.onPut(object);
            }
            return true;
        }
        TTLObject<K, E> t = new TTLObject<K, E>(object, k, ttl);
        t.setEternal(eternal);
        long addedSize = object.getSizeInBytes();
        long newSize = this.currentSizeInBytes + addedSize;
        boolean oversize = false;
        boolean bl = oversize = this.hardByteLimit && this.maxCapacityBytes > 0L && newSize > this.maxCapacityBytes;
        if (!oversize) {
            Key<K> key = new Key<K>(k, System.currentTimeMillis());
            this.keys.put(k, key);
            this.objects.put(key, t);
            t.getObject().onPut(k);
            this.currentSizeInBytes = newSize;
            if (this.eventListener != null) {
                this.eventListener.onPut(object);
            }
            return true;
        }
        return false;
    }

    protected TTLObject<K, E> getTTLObject(K strKey) {
        TTLObject<K, E> obj = null;
        Key<K> key = this.keys.get(strKey);
        if (key != null) {
            obj = this.objects.get(key);
        }
        return obj;
    }

    public synchronized E getRaw(K strKey) {
        TTLObject<K, E> obj = this.getTTLObject(strKey);
        if (obj != null && !this.isExpired(obj)) {
            return obj.getObject();
        }
        return null;
    }

    public synchronized E get(K key) {
        TTLObject<K, E> obj = this.getTTLObject(key);
        if (obj != null && !this.isExpired(obj)) {
            if (this.extendOnGet) {
                this.extendTTL(key);
            }
            if (this.eventListener != null) {
                this.eventListener.onGet(obj.getObject());
            }
            obj.getObject().onGet();
            return obj.getObject();
        }
        if (obj != null) {
            this.destroy(obj.getKey());
            obj = null;
        }
        if (obj == null && this.objectFactory != null) {
            E object = this.objectFactory.create(key);
            if (object != null && !this.put(key, object) && this.logger != null) {
                this.logger.warn("Failed to put object into cache. Cache size exceeded");
            }
            return object;
        }
        return null;
    }

    public Collection<E> values() {
        ArrayList<E> values = null;
        Collection<TTLObject<K, E>> ttls = this.objects.values();
        if (ttls != null) {
            values = new ArrayList<E>(ttls.size());
            for (TTLObject<K, E> t : ttls) {
                if (this.isExpired(t)) continue;
                values.add(t.getObject());
            }
        }
        return values;
    }

    public boolean exists(K k) {
        Key<K> key = this.keys.get(k);
        if (key != null) {
            return this.objects.get(key) != null;
        }
        return false;
    }

    public boolean keyExists(K k) {
        return this.keys.get(k) != null;
    }

    public E remove(K key) {
        return this.remove(key, false);
    }

    public E destroy(K key) {
        return this.remove(key, true);
    }

    public synchronized E remove(K strKey, boolean destroy) {
        Key<K> key = this.keys.get(strKey);
        TTLObject<K, E> removed = null;
        if (key != null) {
            removed = this.objects.remove(key);
            if (removed != null) {
                this.currentSizeInBytes -= removed.getObject().getSizeInBytes();
                removed.getObject().onRemove(destroy);
            }
            this.keys.remove(strKey);
        }
        if (removed != null) {
            return removed.getObject();
        }
        return null;
    }

    public synchronized void extendTTL(K strKey) {
        TTLObject<K, E> object = this.getTTLObject(strKey);
        if (object != null) {
            object.setLifeExpectancy(System.currentTimeMillis() + object.getTtl());
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isExpired(TTLObject<K, E> object) {
        ISuicidal s;
        E o = object.getObject();
        if (o instanceof ISuicidal && (s = (ISuicidal)o).isDead()) {
            return true;
        }
        return !object.isEternal() && object.getLifeExpectancy() <= System.currentTimeMillis();
    }

    public boolean doReap() {
        return this.reap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean reap() {
        if (!this.reaping) {
            int reaped = 0;
            try {
                int size;
                this.reaping = true;
                if (this.eventListener != null) {
                    this.eventListener.onReapStart();
                }
                if ((size = this.objects.size()) > 0) {
                    String msg;
                    Set<Key<K>> localKeys = this.objects.keySet();
                    TreeMap<Key<Key<Key<K>>>, TTLObject<Key<Key<K>>, E>> newMap = this.makeMap();
                    long time = System.currentTimeMillis();
                    boolean ok = true;
                    TTLObject<K, E> object = null;
                    for (Key<K> key : localKeys) {
                        object = this.objects.get(key);
                        if (object != null) {
                            ISuicidal s;
                            ok = true;
                            if (object.getObject() instanceof ISuicidal && (s = (ISuicidal)object.getObject()).isDead()) {
                                --size;
                                if (this.debug && this.logger != null) {
                                    String msg2 = "Object [" + object.getObject().toString() + "] has comitted suicide and will be purged from cache [" + size + "] objects remain";
                                    this.logger.debug(msg2);
                                }
                                ok = false;
                            }
                            if (ok) {
                                if (object.isEternal() || object.getLifeExpectancy() >= time) {
                                    newMap.put(key, object);
                                } else {
                                    ok = false;
                                    --size;
                                    if (this.debug && this.logger != null) {
                                        msg = "Object [" + object.getObject().toString() + "] with ttl of [" + object.getTtl() + "] has expired and will be purged from cache [" + size + "] objects remain";
                                        this.logger.debug(msg);
                                    }
                                }
                            }
                            if (ok) continue;
                            if (this.logger != null && this.logger.isDebugEnabled()) {
                                this.logger.debug("Removing with key [" + key + "] during reap");
                            }
                            this.keys.remove(key.getKey());
                            this.currentSizeInBytes -= object.getObject().getSizeInBytes();
                            ++reaped;
                            object.getObject().onRemove(true);
                            continue;
                        }
                        if (this.logger == null) continue;
                        this.logger.warn("No object found with key [" + key + "]");
                        this.objects.remove(key);
                    }
                    size = newMap.size();
                    if (this.maxCapacity > 0 && size > this.maxCapacity || this.maxCapacityBytes > 0L && this.currentSizeInBytes > this.maxCapacityBytes) {
                        if (this.debug && this.logger != null) {
                            String msg3 = "TTLCache has count of [" + size + "], size of [" + this.currentSizeInBytes + "] bytes  which exceeds maximum of [" + this.maxCapacity + "], [" + this.maxCapacityBytes + "] bytes.  Excess items will be trimmed";
                            this.logger.debug(msg3);
                        }
                        Key<Key<K>> key = null;
                        while (this.maxCapacity > 0 && size > this.maxCapacity || this.maxCapacityBytes > 0L && this.currentSizeInBytes > this.maxCapacityBytes) {
                            key = newMap.firstKey();
                            if (this.debug && this.logger != null) {
                                String msg4 = "Removing item with key [" + key + "] from cache";
                                this.logger.debug(msg4);
                            }
                            TTLObject<Key<K>, E> removed = newMap.remove(key);
                            this.keys.remove(key.getKey());
                            size = newMap.size();
                            this.currentSizeInBytes -= removed.getObject().getSizeInBytes();
                            removed.getObject().onRemove(true);
                            ++reaped;
                            if (!this.debug || this.logger == null) continue;
                            msg = "[" + size + "] objects remain with size of [" + this.currentSizeInBytes + "]";
                            this.logger.debug(msg);
                        }
                    }
                    this.objects = newMap;
                }
            }
            finally {
                if (this.eventListener != null) {
                    this.eventListener.onReapEnd(reaped);
                }
                this.reaping = false;
            }
            return true;
        }
        return false;
    }

    protected TreeMap<Key<K>, TTLObject<K, E>> makeMap() {
        return new TreeMap<Key<K>, TTLObject<K, E>>();
    }

    public int size() {
        return this.objects.size();
    }

    public long sizeInBytes() {
        return this.currentSizeInBytes;
    }

    public boolean isExtendOnGet() {
        return this.extendOnGet;
    }

    public void setExtendOnGet(boolean extendOnGet) {
        this.extendOnGet = extendOnGet;
    }

    public long getMaxCapacityBytes() {
        return this.maxCapacityBytes;
    }

    public void setMaxCapacityBytes(long maxCapacityBytes) {
        this.maxCapacityBytes = maxCapacityBytes;
    }

    public ICacheEventListener<K, E> getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(ICacheEventListener<K, E> eventListener) {
        this.eventListener = eventListener;
    }

    public void extendMax(int extension) {
        this.maxCapacity += extension;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public ICacheableFactory<K, E> getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(ICacheableFactory<K, E> constructor) {
        this.objectFactory = constructor;
    }

    public long getDefaultTTL() {
        return this.defaultTTL;
    }

    public void setDefaultTTL(long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    public boolean isHardByteLimit() {
        return this.hardByteLimit;
    }

    public void setHardByteLimit(boolean hardByteLimit) {
        this.hardByteLimit = hardByteLimit;
    }

    public SocializeLogger getLogger() {
        return this.logger;
    }

    public void setLogger(SocializeLogger logger) {
        this.logger = logger;
    }

    protected class Reaper
    extends TimerTask {
        protected Reaper() {
        }

        @Override
        public void run() {
            TTLCache.this.reap();
        }
    }
}

