/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.twitter;

import android.content.Context;
import android.view.View;
import android.webkit.WebView;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.auth.twitter.ITwitterAuthWebView;
import com.socialize.auth.twitter.OAuthRequestListener;
import com.socialize.auth.twitter.OAuthRequestTokenUrlListener;
import com.socialize.auth.twitter.TwitterAuthListener;
import com.socialize.auth.twitter.TwitterOAuthProvider;
import com.socialize.auth.twitter.TwitterWebViewClient;
import com.socialize.error.SocializeException;
import com.socialize.oauth.signpost.OAuthTokenListener;
import com.socialize.oauth.signpost.commonshttp.CommonsHttpOAuthConsumer;
import com.socialize.oauth.signpost.http.HttpParameters;

public class TwitterAuthWebView
extends WebView
implements ITwitterAuthWebView {
    private TwitterWebViewClient twitterWebViewClient;
    private IBeanFactory<TwitterWebViewClient> twitterWebViewClientFactory;

    public TwitterAuthWebView(Context context) {
        super(context);
    }

    @Override
    public void init() {
        this.twitterWebViewClient = this.newTwitterWebViewClient();
        this.setWebViewClient(this.twitterWebViewClient);
    }

    @Override
    public synchronized void authenticate(String consumerKey, String consumerSecret, TwitterAuthListener listener) {
        TwitterOAuthProvider provider = this.newTwitterOAuthProvider();
        CommonsHttpOAuthConsumer consumer = this.newCommonsHttpOAuthConsumer(consumerKey, consumerSecret);
        OAuthRequestListener oAuthRequestListener = this.newOAuthRequestListener(listener, provider, consumer);
        this.twitterWebViewClient.setOauthRequestListener(oAuthRequestListener);
        provider.retrieveRequestTokenAsync(consumer, "socializeoauth://sign-in-with-twitter", this.newOAuthRequestTokenUrlListener(listener));
    }

    public void setTwitterWebViewClientFactory(IBeanFactory<TwitterWebViewClient> twitterWebViewClientFactory) {
        this.twitterWebViewClientFactory = twitterWebViewClientFactory;
    }

    protected OAuthRequestTokenUrlListener newOAuthRequestTokenUrlListener(final TwitterAuthListener listener) {
        return new OAuthRequestTokenUrlListener(){

            @Override
            public void onRequestUrl(String url) {
                TwitterAuthWebView.this.loadUrl(url);
            }

            @Override
            public void onError(Exception e) {
                if (listener != null) {
                    listener.onError(SocializeException.wrap(e));
                }
            }
        };
    }

    protected OAuthRequestListener newOAuthRequestListener(final TwitterAuthListener listener, final TwitterOAuthProvider provider, final CommonsHttpOAuthConsumer consumer) {
        return new OAuthRequestListener(){

            @Override
            public void onCancel(String cancelToken) {
                if (listener != null) {
                    listener.onCancel();
                }
            }

            @Override
            public void onRequestToken(String token, String verifier) {
                block2: {
                    try {
                        provider.retrieveAccessTokenAsync(consumer, verifier, TwitterAuthWebView.this.newOAuthTokenListener(listener));
                    }
                    catch (Exception e) {
                        if (listener == null) break block2;
                        listener.onError(SocializeException.wrap(e));
                    }
                }
            }
        };
    }

    protected OAuthTokenListener newOAuthTokenListener(final TwitterAuthListener listener) {
        return new OAuthTokenListener(){

            @Override
            public void onResponse(HttpParameters parameters) {
                String token = parameters.getFirst("oauth_token");
                String secret = parameters.getFirst("oauth_token_secret");
                String userId = parameters.getFirst("user_id");
                String screenName = parameters.getFirst("screen_name");
                if (listener != null) {
                    listener.onAuthSuccess(token, secret, screenName, userId);
                }
            }

            @Override
            public void onError(Exception e) {
                if (listener != null) {
                    listener.onError(SocializeException.wrap(e));
                }
            }
        };
    }

    protected TwitterWebViewClient newTwitterWebViewClient() {
        if (this.twitterWebViewClientFactory != null) {
            return (TwitterWebViewClient)((Object)this.twitterWebViewClientFactory.getBean());
        }
        return new TwitterWebViewClient();
    }

    protected TwitterOAuthProvider newTwitterOAuthProvider() {
        return new TwitterOAuthProvider();
    }

    protected CommonsHttpOAuthConsumer newCommonsHttpOAuthConsumer(String consumerKey, String consumerSecret) {
        return new CommonsHttpOAuthConsumer(consumerKey, consumerSecret);
    }

    @Override
    public View getView() {
        return this;
    }
}

