/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.twitter;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.auth.twitter.ITwitterAuthWebView;
import com.socialize.auth.twitter.TwitterAuthListener;
import com.socialize.auth.twitter.TwitterAuthWebView;
import com.socialize.error.SocializeException;

public class TwitterAuthView
extends RelativeLayout {
    private ITwitterAuthWebView webView;
    private String consumerKey;
    private String consumerSecret;
    private TwitterAuthListener twitterAuthListener;
    private IBeanFactory<ITwitterAuthWebView> twitterAuthWebViewFactory;

    public TwitterAuthView(Context context) {
        super(context);
    }

    public TwitterAuthView(Context context, String consumerKey, String consumerSecret) {
        super(context);
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public void init() {
        this.setBackgroundColor(-16777216);
        RelativeLayout.LayoutParams params = this.newLayoutParams(-1, -1);
        this.webView = this.newTwitterAuthWebView(this.getContext());
        this.webView.init();
        this.webView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.addView(this.webView.getView());
    }

    protected RelativeLayout.LayoutParams newLayoutParams(int width, int height) {
        return new RelativeLayout.LayoutParams(width, height);
    }

    protected ITwitterAuthWebView newTwitterAuthWebView(Context context) {
        if (this.twitterAuthWebViewFactory != null) {
            return (ITwitterAuthWebView)this.twitterAuthWebViewFactory.getBean();
        }
        return new TwitterAuthWebView(context);
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setTwitterAuthListener(TwitterAuthListener twitterAuthListener) {
        this.twitterAuthListener = twitterAuthListener;
    }

    public void setTwitterAuthWebViewFactory(IBeanFactory<ITwitterAuthWebView> twitterAuthWebViewFactory) {
        this.twitterAuthWebViewFactory = twitterAuthWebViewFactory;
    }

    public void authenticate() {
        if (this.webView != null) {
            this.webView.authenticate(this.consumerKey, this.consumerSecret, this.newTwitterAuthListener());
        }
    }

    protected TwitterAuthListener newTwitterAuthListener() {
        return new TwitterAuthListener(){

            @Override
            public void onError(SocializeException e) {
                TwitterAuthView.this.webView.setVisibility(8);
                if (TwitterAuthView.this.twitterAuthListener != null) {
                    TwitterAuthView.this.twitterAuthListener.onError(e);
                }
            }

            @Override
            public void onCancel() {
                TwitterAuthView.this.webView.setVisibility(8);
                if (TwitterAuthView.this.twitterAuthListener != null) {
                    TwitterAuthView.this.twitterAuthListener.onCancel();
                }
            }

            @Override
            public void onAuthSuccess(String token, String secret, String screenName, String userId) {
                TwitterAuthView.this.webView.setVisibility(8);
                if (TwitterAuthView.this.twitterAuthListener != null) {
                    TwitterAuthView.this.twitterAuthListener.onAuthSuccess(token, secret, screenName, userId);
                }
            }
        };
    }
}

