/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.twitter;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.socialize.android.ioc.IBeanFactory;
import com.socialize.auth.twitter.TwitterAuthDialogListener;
import com.socialize.auth.twitter.TwitterAuthListener;
import com.socialize.auth.twitter.TwitterAuthProviderInfo;
import com.socialize.auth.twitter.TwitterAuthView;
import com.socialize.config.SocializeConfig;
import com.socialize.error.SocializeException;
import com.socialize.ui.dialog.DialogRegistration;

public class TwitterAuthUtils {
    private SocializeConfig config;
    private TwitterAuthProviderInfo info;
    private IBeanFactory<TwitterAuthView> twitterAuthViewFactory;

    public Dialog showAuthDialog(Context context, TwitterAuthProviderInfo info, TwitterAuthListener listener) {
        Dialog dialog = this.newDialog(context);
        dialog.setTitle((CharSequence)"Twitter Authentication");
        dialog.setCancelable(true);
        dialog.setOnCancelListener(this.newOnCancelListener(listener));
        TwitterAuthView view = (TwitterAuthView)((Object)this.twitterAuthViewFactory.getBean(new Object[]{info.getConsumerKey(), info.getConsumerSecret()}));
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        view.setLayoutParams(params);
        dialog.setContentView((View)view);
        view.setTwitterAuthListener(this.newTwitterAuthDialogListener(dialog, listener));
        view.authenticate();
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(dialog.getWindow().getAttributes());
        lp.width = -1;
        lp.height = -1;
        DialogRegistration.register(context, dialog);
        dialog.show();
        return dialog;
    }

    protected DialogInterface.OnCancelListener newOnCancelListener(final TwitterAuthListener listener) {
        return new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (listener != null) {
                    listener.onCancel();
                }
            }
        };
    }

    protected Dialog newDialog(Context context) {
        return new Dialog(context, 16973835);
    }

    protected TwitterAuthDialogListener newTwitterAuthDialogListener(Dialog dialog, final TwitterAuthListener listener) {
        return new TwitterAuthDialogListener(dialog){

            @Override
            public void onError(Dialog dialog, Exception e) {
                dialog.dismiss();
                if (listener != null) {
                    listener.onError(SocializeException.wrap(e));
                }
            }

            @Override
            public void onCancel(Dialog dialog) {
                dialog.dismiss();
                if (listener != null) {
                    listener.onCancel();
                }
            }

            @Override
            public void onAuthSuccess(Dialog dialog, String token, String secret, String screenName, String userId) {
                dialog.dismiss();
                if (listener != null) {
                    listener.onAuthSuccess(token, secret, screenName, userId);
                }
            }
        };
    }

    public TwitterAuthProviderInfo getAuthProviderInfo() {
        if (this.info == null) {
            this.info = new TwitterAuthProviderInfo();
            this.info.setConsumerKey(this.config.getProperty("twitter.consumer.key"));
            this.info.setConsumerSecret(this.config.getProperty("twitter.consumer.secret"));
        }
        return this.info;
    }

    public void setTwitterAuthViewFactory(IBeanFactory<TwitterAuthView> twitterAuthViewFactory) {
        this.twitterAuthViewFactory = twitterAuthViewFactory;
    }

    public void setConfig(SocializeConfig config) {
        this.config = config;
    }

    protected AlertDialog.Builder newAlertDialogBuilder(Context context) {
        return new AlertDialog.Builder(context);
    }

    protected TwitterAuthView newTwitterAuthView(Context context) {
        return new TwitterAuthView(context);
    }
}

