/*
 * Decompiled with CFR 0.152.
 */
package com.socialize.auth.twitter;

import com.socialize.auth.AuthProviderInfo;
import com.socialize.auth.AuthProviderType;
import com.socialize.error.SocializeException;
import com.socialize.util.StringUtils;

public class TwitterAuthProviderInfo
implements AuthProviderInfo {
    private static final long serialVersionUID = 2029759815212317302L;
    private String consumerKey;
    private String consumerSecret;

    @Override
    public AuthProviderType getType() {
        return AuthProviderType.TWITTER;
    }

    @Override
    public void validate() throws SocializeException {
        if (StringUtils.isEmpty(this.consumerKey)) {
            throw new SocializeException("No twitter consumer key found.");
        }
        if (StringUtils.isEmpty(this.consumerSecret)) {
            throw new SocializeException("No twitter consumer secret found.");
        }
    }

    @Override
    public boolean isValid() {
        return !StringUtils.isEmpty(this.consumerKey) && !StringUtils.isEmpty(this.consumerSecret);
    }

    @Override
    public boolean matches(AuthProviderInfo info) {
        return this.equals(info);
    }

    @Override
    public boolean merge(AuthProviderInfo info) {
        if (info instanceof TwitterAuthProviderInfo) {
            TwitterAuthProviderInfo that = (TwitterAuthProviderInfo)info;
            this.consumerKey = that.consumerKey;
            this.consumerSecret = that.consumerSecret;
            return true;
        }
        return false;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.consumerKey == null ? 0 : this.consumerKey.hashCode());
        result = 31 * result + (this.consumerSecret == null ? 0 : this.consumerSecret.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TwitterAuthProviderInfo other = (TwitterAuthProviderInfo)obj;
        if (this.consumerKey == null ? other.consumerKey != null : !this.consumerKey.equals(other.consumerKey)) {
            return false;
        }
        return !(this.consumerSecret == null ? other.consumerSecret != null : !this.consumerSecret.equals(other.consumerSecret));
    }
}

